/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.JavaCodeReader;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public final class SmartBracesAutoEditStrategy
implements IAutoEditStrategy {
    private final ITextViewer fTextViewer;
    private ITextInputListener fTextInputListener;
    private final IDocumentListener fDocumentListener = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent event) {
            SmartBracesAutoEditStrategy.this.fSourceRegion = null;
            SmartBracesAutoEditStrategy.this.fUndoEvent = null;
        }

        public void documentChanged(DocumentEvent event) {
        }
    };
    private IRegion fSourceRegion;
    private DocumentEvent fUndoEvent;

    public SmartBracesAutoEditStrategy(ITextViewer textViewer) {
        if (textViewer == null) {
            throw new IllegalArgumentException();
        }
        this.fTextViewer = textViewer;
    }

    private void install(IRegion userRegion, DocumentEvent undoEvent) {
        if (userRegion == null || undoEvent == null) {
            throw new IllegalArgumentException();
        }
        this.fSourceRegion = userRegion;
        this.fUndoEvent = undoEvent;
        if (this.fTextInputListener != null) {
            return;
        }
        IDocument document = this.fTextViewer.getDocument();
        document.addDocumentListener(this.fDocumentListener);
        this.fTextInputListener = new ITextInputListener(){

            public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
                if (oldInput != null) {
                    oldInput.removeDocumentListener(SmartBracesAutoEditStrategy.this.fDocumentListener);
                }
            }

            public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                if (newInput != null) {
                    newInput.addDocumentListener(SmartBracesAutoEditStrategy.this.fDocumentListener);
                }
            }
        };
        this.fTextViewer.addTextInputListener(this.fTextInputListener);
    }

    private boolean isBackspace(DocumentCommand command) {
        return (command.text == null || command.text.length() == 0) && this.fSourceRegion.getOffset() == command.offset && this.fSourceRegion.getLength() == command.length;
    }

    private boolean isDelete(DocumentCommand command) {
        return (command.text == null || command.text.length() == 0) && this.fSourceRegion.getOffset() + this.fSourceRegion.getLength() == command.offset && command.length > 0;
    }

    private boolean isClosingBracket(DocumentCommand command) {
        return command.offset == this.fSourceRegion.getOffset() + this.fSourceRegion.getLength() && command.length <= 1 && "}".equals(command.text);
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        try {
            if (!command.doit) {
                return;
            }
            if (this.fSourceRegion != null) {
                if (this.isBackspace(command) || this.isClosingBracket(command)) {
                    command.addCommand(this.fUndoEvent.getOffset(), this.fUndoEvent.getLength(), this.fUndoEvent.getText(), this.fDocumentListener);
                    command.owner = this.fDocumentListener;
                    command.doit = false;
                    this.fSourceRegion = null;
                    this.fUndoEvent = null;
                } else if (this.isDelete(command)) {
                    command.caretOffset = command.offset;
                    command.offset = this.fUndoEvent.getOffset();
                    command.length = this.fUndoEvent.getLength();
                    command.text = this.fUndoEvent.getText();
                    command.owner = this.fDocumentListener;
                    command.doit = false;
                    this.fSourceRegion = null;
                    this.fUndoEvent = null;
                }
            } else if (command.text != null && command.text.equals("{")) {
                this.smartBraces(document, command);
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    private static String getLineDelimiter(IDocument document) {
        try {
            if (document.getNumberOfLines() > 1) {
                return document.getLineDelimiter(0);
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        return System.getProperty("line.separator");
    }

    private static String getLineIndentation(IDocument document, int line, int maxOffset) throws BadLocationException {
        int lineOffset = document.getLineOffset(line);
        String string = document.get(lineOffset, maxOffset - lineOffset);
        int length = string.length();
        int i = 0;
        while (i != length && Character.isWhitespace(string.charAt(i))) {
            ++i;
        }
        return string.substring(0, i);
    }

    private static IRegion getToken(IDocument document, IRegion scanRegion, int tokenId) throws BadLocationException {
        String source = document.get(scanRegion.getOffset(), scanRegion.getLength());
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(source.toCharArray());
        try {
            int id = scanner.getNextToken();
            while (id != 158 && id != tokenId) {
                id = scanner.getNextToken();
            }
            if (id == 158) {
                return null;
            }
            int tokenOffset = scanner.getCurrentTokenStartPosition();
            int tokenLength = scanner.getCurrentTokenEndPosition() + 1 - tokenOffset;
            return new Region(tokenOffset + scanRegion.getOffset(), tokenLength);
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
    }

    private void addReplace(IDocument document, DocumentCommand command, int offset, int length, String text) throws BadLocationException {
        command.addCommand(offset, length, text, this.fDocumentListener);
        command.owner = this.fDocumentListener;
        command.doit = false;
        String oldText = document.get(offset, length);
        int delta = offset <= command.offset ? 0 : (command.text == null ? 0 : command.text.length()) - command.length;
        Region replacedRegion = new Region(command.offset, command.text == null ? 0 : command.text.length());
        DocumentEvent undoEvent = new DocumentEvent(document, offset + delta, text == null ? 0 : text.length(), oldText);
        this.install((IRegion)replacedRegion, undoEvent);
    }

    private void makeBlock(IDocument document, DocumentCommand command) throws BadLocationException {
        int offset = command.offset;
        int insertionLine = document.getLineOfOffset(offset);
        String lineDelimiter = SmartBracesAutoEditStrategy.getLineDelimiter(document);
        String lineIndentation = SmartBracesAutoEditStrategy.getLineIndentation(document, insertionLine, offset);
        StringBuffer buffer = new StringBuffer();
        buffer.append(lineIndentation);
        buffer.append("}");
        buffer.append(lineDelimiter);
        int replaceOffset = document.getLineOffset(insertionLine) + document.getLineLength(insertionLine);
        this.addReplace(document, command, replaceOffset, 0, buffer.toString());
    }

    private void makeBlock(IDocument document, DocumentCommand command, IRegion replace, IRegion statement, IRegion nextStatement, IRegion prevStatement, boolean followingControl) throws BadLocationException {
        int insertionLine = document.getLineOfOffset(replace.getOffset());
        int statementLine = document.getLineOfOffset(statement.getOffset() + statement.getLength());
        String outerSpace = prevStatement.getOffset() + prevStatement.getLength() == replace.getOffset() ? "" : " ";
        String innerSpace = replace.getOffset() + replace.getLength() == statement.getOffset() ? "" : " ";
        switch (statementLine - insertionLine) {
            case 0: {
                int replaceOffset = statement.getOffset() + statement.getLength();
                int replaceLength = document.getChar(replaceOffset) == ' ' ? 1 : 0;
                this.addReplace(document, command, replaceOffset, replaceLength, String.valueOf(innerSpace) + "}" + outerSpace);
                break;
            }
            default: {
                this.makeBlock(document, command);
            }
        }
    }

    private static Statement getNextStatement(Statement statement) {
        ASTNode node = statement.getParent();
        while (node != null && node.getNodeType() != 8) {
            node = node.getParent();
        }
        if (node == null) {
            return null;
        }
        Block block = (Block)node;
        List statements = block.statements();
        Iterator iterator = statements.iterator();
        while (iterator.hasNext()) {
            Statement nextStatement = (Statement)iterator.next();
            if (nextStatement.getStartPosition() < statement.getStartPosition() + statement.getLength()) continue;
            return nextStatement;
        }
        return null;
    }

    private static boolean areBlocksConsistent(IDocument document, int offset) {
        JavaCodeReader reader = new JavaCodeReader();
        try {
            int begin = offset;
            int end = offset;
            do {
                begin = SmartBracesAutoEditStrategy.searchForOpeningPeer(reader, begin, 123, 125, document);
                end = SmartBracesAutoEditStrategy.searchForClosingPeer(reader, end, 123, 125, document);
                if (begin != -1 || end != -1) continue;
                return true;
            } while (begin != -1 && end != -1);
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static IRegion getSurroundingBlock(IDocument document, int offset) {
        JavaCodeReader reader = new JavaCodeReader();
        try {
            int begin = SmartBracesAutoEditStrategy.searchForOpeningPeer(reader, offset, 123, 125, document);
            int end = SmartBracesAutoEditStrategy.searchForClosingPeer(reader, offset, 123, 125, document);
            if (begin == -1 || end == -1) {
                return null;
            }
            return new Region(begin, end + 1 - begin);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static CompilationUnitInfo getCompilationUnitForMethod(IDocument document, int offset) {
        try {
            IRegion sourceRange = SmartBracesAutoEditStrategy.getSurroundingBlock(document, offset);
            if (sourceRange == null) {
                return null;
            }
            String source = document.get(sourceRange.getOffset(), sourceRange.getLength());
            StringBuffer contents = new StringBuffer();
            contents.append("class C{void m()");
            int methodOffset = contents.length();
            contents.append(source);
            contents.append('}');
            char[] buffer = contents.toString().toCharArray();
            return new CompilationUnitInfo(buffer, sourceRange.getOffset() - methodOffset);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    private static IRegion createRegion(ASTNode node, int delta) {
        if (node == null) {
            return null;
        }
        return new Region(node.getStartPosition() + delta, node.getLength());
    }

    /*
     * Unable to fully structure code
     */
    private void smartBraces(IDocument document, DocumentCommand command) throws BadLocationException {
        if (!JavaPlugin.getDefault().getPreferenceStore().getBoolean("closeBraces")) {
            return;
        }
        offset = command.offset;
        length = command.length;
        replace = new Region(offset, length);
        info = SmartBracesAutoEditStrategy.getCompilationUnitForMethod(document, offset);
        if (info == null) {
            return;
        }
        buffer = info.buffer;
        delta = info.delta;
        compilationUnit = AST.parseCompilationUnit((char[])buffer);
        problems = compilationUnit.getProblems();
        i = 0;
        while (i != problems.length) {
            if (problems[i].getID() == 1610612956) {
                return;
            }
            ++i;
        }
        node = NodeFinder.perform((ASTNode)compilationUnit, offset - delta, length);
        if (node != null) ** GOTO lbl23
        return;
lbl-1000:
        // 1 sources

        {
            node = node.getParent();
lbl23:
            // 2 sources

            ** while (node != null && length == 0 && (offset - delta == node.getStartPosition() || offset - delta == node.getStartPosition() + node.getLength()))
        }
lbl24:
        // 1 sources

        switch (node.getNodeType()) {
            case 8: {
                if (!SmartBracesAutoEditStrategy.areBlocksConsistent(document, offset)) break;
                this.makeBlock(document, command);
                break;
            }
            case 25: {
                ifStatement = (IfStatement)node;
                expression = ifStatement.getExpression();
                thenStatement = ifStatement.getThenStatement();
                elseStatement = ifStatement.getElseStatement();
                nextStatement = SmartBracesAutoEditStrategy.getNextStatement((Statement)ifStatement);
                expressionRegion = SmartBracesAutoEditStrategy.createRegion((ASTNode)expression, delta);
                thenRegion = SmartBracesAutoEditStrategy.createRegion((ASTNode)thenStatement, delta);
                elseRegion = SmartBracesAutoEditStrategy.createRegion((ASTNode)elseStatement, delta);
                nextRegion = SmartBracesAutoEditStrategy.createRegion((ASTNode)nextStatement, delta);
                elseToken = null;
                if (elseStatement != null) {
                    sourceOffset = thenRegion.getOffset() + thenRegion.getLength();
                    sourceLength = elseRegion.getOffset() - sourceOffset;
                    elseToken = SmartBracesAutoEditStrategy.getToken(document, (IRegion)new Region(sourceOffset, sourceLength), 213);
                }
                if (offset >= expressionRegion.getOffset() + expressionRegion.getLength() && offset + length <= thenRegion.getOffset()) {
                    if (thenStatement == null || thenStatement.getNodeType() == 8) {
                        return;
                    }
                    if (elseToken != null) {
                        nextRegion = elseToken;
                    }
                    sourceOffset = expressionRegion.getOffset() + expressionRegion.getLength();
                    sourceLength = thenRegion.getOffset() - sourceOffset;
                    rightParenthesisToken = SmartBracesAutoEditStrategy.getToken(document, (IRegion)new Region(sourceOffset, sourceLength), 86);
                    this.makeBlock(document, command, (IRegion)replace, thenRegion, nextRegion, rightParenthesisToken, elseStatement != null);
                    break;
                }
                if (elseStatement == null || elseStatement.getNodeType() == 8) {
                    return;
                }
                if (offset < elseToken.getOffset() + elseToken.getLength() || offset + length > elseRegion.getOffset()) break;
                this.makeBlock(document, command, (IRegion)replace, SmartBracesAutoEditStrategy.createRegion((ASTNode)elseStatement, delta), nextRegion, elseToken, false);
                break;
            }
            case 24: 
            case 61: {
                expression = node.getNodeType() == 61 ? ((WhileStatement)node).getExpression() : ((ForStatement)node).getExpression();
                body = node.getNodeType() == 61 ? ((WhileStatement)node).getBody() : ((ForStatement)node).getBody();
                nextStatement = SmartBracesAutoEditStrategy.getNextStatement((Statement)node);
                if (expression == null || body == null || body.getNodeType() == 8) {
                    return;
                }
                expressionRegion = SmartBracesAutoEditStrategy.createRegion((ASTNode)expression, delta);
                bodyRegion = SmartBracesAutoEditStrategy.createRegion((ASTNode)body, delta);
                nextRegion = SmartBracesAutoEditStrategy.createRegion((ASTNode)nextStatement, delta);
                sourceOffset = expressionRegion.getOffset() + expressionRegion.getLength();
                sourceLength = bodyRegion.getOffset() - sourceOffset;
                rightParenthesisToken = SmartBracesAutoEditStrategy.getToken(document, (IRegion)new Region(sourceOffset, sourceLength), 86);
                if (offset < expressionRegion.getOffset() + expressionRegion.getLength() || offset + length > bodyRegion.getOffset()) break;
                this.makeBlock(document, command, (IRegion)replace, bodyRegion, nextRegion, rightParenthesisToken, false);
                break;
            }
            case 19: {
                doStatement = (DoStatement)node;
                body = doStatement.getBody();
                expression = doStatement.getExpression();
                if (expression == null || body == null || body.getNodeType() == 8) {
                    return;
                }
                doRegion = SmartBracesAutoEditStrategy.createRegion((ASTNode)doStatement, delta);
                bodyRegion = SmartBracesAutoEditStrategy.createRegion((ASTNode)body, delta);
                expressionRegion = SmartBracesAutoEditStrategy.createRegion((ASTNode)expression, delta);
                sourceOffset = bodyRegion.getOffset() + bodyRegion.getLength();
                sourceLength = expressionRegion.getOffset() - sourceOffset;
                whileToken = SmartBracesAutoEditStrategy.getToken(document, (IRegion)new Region(sourceOffset, sourceLength), 117);
                prevRegion = SmartBracesAutoEditStrategy.getToken(document, doRegion, 121);
                if (offset < doRegion.getOffset() || offset + length > bodyRegion.getOffset()) break;
                this.makeBlock(document, command, (IRegion)replace, bodyRegion, whileToken, prevRegion, true);
                break;
            }
        }
    }

    private static int searchForClosingPeer(JavaCodeReader reader, int offset, int openingPeer, int closingPeer, IDocument document) throws IOException {
        reader.configureForwardReader(document, offset + 1, document.getLength(), true, true);
        int stack = 1;
        int c = reader.read();
        while (c != -1) {
            if (c == openingPeer && c != closingPeer) {
                ++stack;
            } else if (c == closingPeer) {
                --stack;
            }
            if (stack == 0) {
                return reader.getOffset();
            }
            c = reader.read();
        }
        return -1;
    }

    private static int searchForOpeningPeer(JavaCodeReader reader, int offset, int openingPeer, int closingPeer, IDocument document) throws IOException {
        reader.configureBackwardReader(document, offset, true, true);
        int stack = 1;
        int c = reader.read();
        while (c != -1) {
            if (c == closingPeer && c != openingPeer) {
                ++stack;
            } else if (c == openingPeer) {
                --stack;
            }
            if (stack == 0) {
                return reader.getOffset();
            }
            c = reader.read();
        }
        return -1;
    }

    private static class CompilationUnitInfo {
        public char[] buffer;
        public int delta;

        public CompilationUnitInfo(char[] buffer, int delta) {
            this.buffer = buffer;
            this.delta = delta;
        }
    }
}

