/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.io.IOException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocAccess;
import org.eclipse.jdt.internal.corext.javadoc.SingleCharReader;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;

public class ProposalInfo {
    private IJavaProject fJavaProject;
    private char[] fPackageName;
    private char[] fTypeName;
    private char[] fMemberName;
    private char[][] fParameterPackages;
    private char[][] fParameterTypes;
    private boolean fIsConstructor;
    private IMember fMember;

    public ProposalInfo(IJavaProject jproject, char[] packName, char[] typeQualifiedName, char[] methodName, char[][] paramPackages, char[][] paramTypes, boolean isConstructor) {
        this.fJavaProject = jproject;
        this.fPackageName = packName;
        this.fTypeName = typeQualifiedName;
        this.fMemberName = methodName;
        this.fParameterPackages = paramPackages;
        this.fParameterTypes = paramTypes;
        this.fIsConstructor = isConstructor;
    }

    public ProposalInfo(IMember member) {
        this.fMember = member;
    }

    public ProposalInfo(IJavaProject jproject, char[] packName, char[] typeQualifiedName) {
        this(jproject, packName, typeQualifiedName, null, null, null, false);
    }

    public ProposalInfo(IJavaProject jproject, char[] packName, char[] typeQualifiedName, char[] fieldName) {
        this(jproject, packName, typeQualifiedName, fieldName, null, null, false);
    }

    private String getParameterSignature(int index) {
        StringBuffer buf = new StringBuffer();
        char[] pack = this.fParameterPackages[index];
        if (pack != null && pack.length > 0) {
            buf.append(pack);
            buf.append('.');
        }
        buf.append(this.fParameterTypes[index]);
        return Signature.createTypeSignature((String)buf.toString(), (boolean)true);
    }

    private IMember getMember() throws JavaModelException {
        IType type;
        if (this.fMember == null && (type = this.fJavaProject.findType(new String(this.fPackageName), new String(this.fTypeName))) != null) {
            if (this.fMemberName != null) {
                String name = new String(this.fMemberName);
                if (this.fParameterTypes != null) {
                    String[] paramTypes = new String[this.fParameterTypes.length];
                    int i = 0;
                    while (i < this.fParameterTypes.length) {
                        paramTypes[i] = this.getParameterSignature(i);
                        ++i;
                    }
                    this.fMember = JavaModelUtil.findMethod(name, paramTypes, this.fIsConstructor, type);
                } else {
                    IField field = type.getField(name);
                    if (field.exists()) {
                        this.fMember = field;
                    }
                }
            } else {
                this.fMember = type;
            }
        }
        return this.fMember;
    }

    public String getInfo() {
        try {
            SingleCharReader reader;
            IMember member = this.getMember();
            if (member != null && (reader = JavaDocAccess.getJavaDoc(member, true)) != null) {
                return new JavaDoc2HTMLTextReader(reader).getString();
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        catch (IOException e) {
            JavaPlugin.log(e);
        }
        return null;
    }
}

