/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.template.TemplateMessages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuesser;
import org.eclipse.jdt.internal.ui.text.link.LinkedPositionManager;
import org.eclipse.jdt.internal.ui.text.link.LinkedPositionUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class ParameterGuessingProposal
extends JavaCompletionProposal {
    private final char[] fName;
    private final char[][] fParameterNames;
    private final char[][] fParamaterTypePackageNames;
    private final char[][] fParameterTypeNames;
    private final int fCodeAssistOffset;
    private final ICompilationUnit fCompilationUnit;
    private final ITextViewer fViewer;
    private IRegion fSelectedRegion;

    public ParameterGuessingProposal(int replacementOffset, int replacementLength, Image image, String displayString, ITextViewer viewer, int relevance, char[] name, char[][] paramaterTypePackageNames, char[][] parameterTypeNames, char[][] parameterNames, int codeAssistOffset, ICompilationUnit compilationUnit) {
        super("", replacementOffset, replacementLength, image, displayString, relevance);
        this.fName = name;
        this.fParamaterTypePackageNames = paramaterTypePackageNames;
        this.fParameterTypeNames = parameterTypeNames;
        this.fParameterNames = parameterNames;
        this.fViewer = viewer;
        this.fCodeAssistOffset = codeAssistOffset;
        this.fCompilationUnit = compilationUnit;
    }

    private boolean appendArguments(IDocument document, int offset) {
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        if (preferenceStore.getBoolean("content_assist_insert_completion") ^ this.fToggleEating) {
            return true;
        }
        try {
            IRegion region = document.getLineInformationOfOffset(offset);
            String line = document.get(region.getOffset(), region.getLength());
            int index = offset - region.getOffset();
            while (index != line.length() && Character.isUnicodeIdentifierPart(line.charAt(index))) {
                ++index;
            }
            if (index == line.length()) {
                return true;
            }
            return line.charAt(index) != '(';
        }
        catch (BadLocationException badLocationException) {
            return true;
        }
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            String replacementString;
            int parameterCount = this.fParameterNames.length;
            int[] positionOffsets = new int[parameterCount];
            int[] positionLengths = new int[parameterCount];
            if (this.appendArguments(document, offset)) {
                parameterCount = this.fParameterNames.length;
                positionOffsets = new int[parameterCount];
                positionLengths = new int[parameterCount];
                replacementString = this.computeGuessingCompletion(positionOffsets, positionLengths);
            } else {
                parameterCount = 0;
                positionOffsets = new int[]{};
                positionLengths = new int[]{};
                replacementString = new String(this.fName);
            }
            this.setReplacementString(replacementString);
            super.apply(document, trigger, offset);
            int replacementOffset = this.getReplacementOffset();
            if (LinkedPositionManager.hasActiveManager(document)) {
                this.fSelectedRegion = positionOffsets.length == 0 ? new Region(replacementOffset + replacementString.length(), 0) : new Region(replacementOffset + positionOffsets[0], positionLengths[0]);
            } else {
                LinkedPositionManager manager = new LinkedPositionManager(document);
                int i = 0;
                while (i != positionOffsets.length) {
                    manager.addPosition(replacementOffset + positionOffsets[i], positionLengths[i]);
                    ++i;
                }
                LinkedPositionUI editor = new LinkedPositionUI(this.fViewer, manager);
                editor.setFinalCaretOffset(replacementOffset + replacementString.length());
                editor.enter();
                this.fSelectedRegion = editor.getSelectedRegion();
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
            this.openErrorDialog((Exception)((Object)e));
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            this.openErrorDialog((Exception)((Object)e));
        }
    }

    private String[] guessParameters() throws JavaModelException {
        String[] parameters = new String[this.fParameterNames.length];
        if (this.fCompilationUnit == null) {
            int i = 0;
            while (i != this.fParameterNames.length) {
                parameters[i] = new String(this.fParameterNames[i]);
                ++i;
            }
            return parameters;
        }
        ICompilationUnit i = this.fCompilationUnit;
        synchronized (i) {
            this.fCompilationUnit.reconcile();
        }
        ParameterGuesser guesser = new ParameterGuesser(this.fCodeAssistOffset, this.fCompilationUnit);
        int i2 = this.fParameterNames.length - 1;
        while (i2 >= 0) {
            String parameter = guesser.guessParameterName(new String(this.fParamaterTypePackageNames[i2]), new String(this.fParameterTypeNames[i2]), new String(this.fParameterNames[i2]));
            parameters[i2] = parameter == null ? new String(this.fParameterNames[i2]) : parameter;
            --i2;
        }
        return parameters;
    }

    private String computeGuessingCompletion(int[] offsets, int[] lengths) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fName);
        buffer.append('(');
        String[] parameters = this.guessParameters();
        int i = 0;
        while (i < parameters.length) {
            if (i != 0) {
                buffer.append(", ");
            }
            offsets[i] = buffer.length();
            buffer.append(parameters[i]);
            lengths[i] = buffer.length() - offsets[i];
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(Exception e) {
        Shell shell = this.fViewer.getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)TemplateMessages.getString("TemplateEvaluator.error.title"), (String)e.getMessage());
    }

    public String toString() {
        return String.valueOf(this.getDisplayString()) + super.toString();
    }
}

