/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.CompletionRequestorAdapter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.ui.util.StringMatcher;

public class ParameterGuesser {
    private final ICompilationUnit fCompilationUnit;
    private final int fCodeAssistOffset;
    private List fVariables;

    public ParameterGuesser(int codeAssistOffset, ICompilationUnit compilationUnit) {
        Assert.isTrue(codeAssistOffset >= 0);
        Assert.isNotNull(compilationUnit);
        this.fCodeAssistOffset = codeAssistOffset;
        this.fCompilationUnit = compilationUnit;
    }

    public int getCodeAssistOffset() {
        return this.fCodeAssistOffset;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public String guessParameterName(String paramPackage, String paramType, String paramName) throws JavaModelException {
        if (this.fVariables == null) {
            VariableCollector variableCollector = new VariableCollector();
            this.fVariables = variableCollector.collect(this.fCodeAssistOffset, this.fCompilationUnit);
        }
        List typeMatches = this.findFieldsMatchingType(this.fVariables, paramPackage, paramType);
        return ParameterGuesser.chooseBestMatch(typeMatches, paramName);
    }

    private static String chooseBestMatch(List typeMatches, String paramName) {
        if (typeMatches == null) {
            return null;
        }
        Variable bestMatch = null;
        int bestSubstringScore = 0;
        Iterator i = typeMatches.iterator();
        while (i.hasNext()) {
            Variable variable = (Variable)i.next();
            if (variable.alreadyMatched) continue;
            int subStringScore = ParameterGuesser.getLongestCommonSubstring(variable.name, paramName).length();
            if (bestMatch == null) {
                bestMatch = variable;
                bestSubstringScore = subStringScore;
                continue;
            }
            if (variable.variableType < bestMatch.variableType) {
                bestMatch = variable;
                continue;
            }
            if (subStringScore > bestSubstringScore) {
                bestMatch = variable;
                bestSubstringScore = subStringScore;
                continue;
            }
            if (variable.positionScore > bestMatch.positionScore) {
                bestMatch = variable;
                continue;
            }
            if (!bestMatch.alreadyMatched || variable.alreadyMatched) continue;
            bestMatch = variable;
        }
        if (bestMatch == null) {
            return null;
        }
        bestMatch.alreadyMatched = true;
        return bestMatch.name;
    }

    private List findFieldsMatchingType(List variables, String typePackage, String typeName) throws JavaModelException {
        if (typeName == null || typeName.length() == 0) {
            return null;
        }
        ArrayList<Variable> matches = new ArrayList<Variable>();
        ListIterator iterator = variables.listIterator(variables.size());
        while (iterator.hasPrevious()) {
            Variable variable = (Variable)iterator.previous();
            if (!this.isTypeMatch(variable, typePackage, typeName)) continue;
            matches.add(variable);
        }
        return matches.isEmpty() ? null : matches;
    }

    private boolean isTypeMatch(Variable variable, String typePackage, String typeName) throws JavaModelException {
        if ((typePackage == null || variable.typePackage == null || typePackage.length() == 0 || variable.typePackage.length() == 0) && variable.typeName.equals(typeName)) {
            return true;
        }
        if (variable.typeName.equals(typeName) && variable.typePackage.equals(typePackage)) {
            return true;
        }
        return this.isAssignable(variable, typePackage, typeName);
    }

    private boolean isAssignable(Variable variable, String typePackage, String typeName) throws JavaModelException {
        StringBuffer paramTypeName = new StringBuffer();
        if (typePackage.length() != 0) {
            paramTypeName.append(typePackage);
            paramTypeName.append('.');
        }
        paramTypeName.append(typeName);
        StringBuffer varTypeName = new StringBuffer();
        if (variable.typePackage.length() != 0) {
            varTypeName.append(variable.typePackage);
            varTypeName.append('.');
        }
        varTypeName.append(variable.typeName);
        IJavaProject project = this.fCompilationUnit.getJavaProject();
        IType paramType = project.findType(paramTypeName.toString());
        IType varType = project.findType(varTypeName.toString());
        if (varType == null || paramType == null) {
            return false;
        }
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(varType);
        return hierarchy.contains(paramType);
    }

    private static String getLongestCommonSubstring(String first, String second) {
        String shorter = first.length() <= second.length() ? first : second;
        String longer = shorter == first ? second : first;
        int minLength = shorter.length();
        StringBuffer pattern = new StringBuffer(shorter.length() + 2);
        String longestCommonSubstring = "";
        int i = 0;
        while (i < minLength) {
            int j = i + 1;
            while (j <= minLength) {
                if (j - i >= longestCommonSubstring.length()) {
                    String substring = shorter.substring(i, j);
                    pattern.setLength(0);
                    pattern.append('*');
                    pattern.append(substring);
                    pattern.append('*');
                    StringMatcher matcher = new StringMatcher(pattern.toString(), true, false);
                    if (matcher.match(longer)) {
                        longestCommonSubstring = substring;
                    }
                }
                ++j;
            }
            ++i;
        }
        return longestCommonSubstring;
    }

    private static final class Variable {
        public static final int LOCAL = 0;
        public static final int FIELD = 1;
        public static final int INHERITED_FIELD = 2;
        public final String typePackage;
        public final String typeName;
        public final String name;
        public final int variableType;
        public final int positionScore;
        public boolean alreadyMatched;

        public Variable(String typePackage, String typeName, String name, int variableType, int positionScore) {
            this.typePackage = typePackage;
            this.typeName = typeName;
            this.name = name;
            this.variableType = variableType;
            this.positionScore = positionScore;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            if (this.typePackage.length() != 0) {
                buffer.append(this.typePackage);
                buffer.append('.');
            }
            buffer.append(this.typeName);
            buffer.append(' ');
            buffer.append(this.name);
            buffer.append(" (");
            buffer.append(this.variableType);
            buffer.append(')');
            return buffer.toString();
        }
    }

    private static final class VariableCollector
    extends CompletionRequestorAdapter {
        private String fEnclosingTypeName;
        private List fVariables;

        VariableCollector() {
        }

        public List collect(int codeAssistOffset, ICompilationUnit compilationUnit) throws JavaModelException {
            Assert.isTrue(codeAssistOffset >= 0);
            Assert.isNotNull(compilationUnit);
            this.fVariables = new ArrayList();
            String source = compilationUnit.getSource();
            if (source == null) {
                return this.fVariables;
            }
            this.fEnclosingTypeName = VariableCollector.getEnclosingTypeName(codeAssistOffset, compilationUnit);
            int completionOffset = VariableCollector.getCompletionOffset(source, codeAssistOffset);
            compilationUnit.codeComplete(completionOffset, (ICompletionRequestor)this);
            return this.fVariables;
        }

        private static String getEnclosingTypeName(int codeAssistOffset, ICompilationUnit compilationUnit) throws JavaModelException {
            IJavaElement element = compilationUnit.getElementAt(codeAssistOffset);
            if (element == null) {
                return null;
            }
            if ((element = element.getAncestor(7)) == null) {
                return null;
            }
            return element.getElementName();
        }

        private static int getCompletionOffset(String source, int start) {
            int index = start;
            while (index > 0 && !Character.isWhitespace(source.charAt(index - 1))) {
                --index;
            }
            return index;
        }

        private final boolean isInherited(String declaringTypeName) {
            return !declaringTypeName.equals(this.fEnclosingTypeName);
        }

        private void addVariable(int varType, char[] typePackageName, char[] typeName, char[] name) {
            this.fVariables.add(new Variable(new String(typePackageName), new String(typeName), new String(name), varType, this.fVariables.size()));
        }

        public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] name, char[] typePackageName, char[] typeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            if (!this.isInherited(new String(declaringTypeName))) {
                this.addVariable(1, typePackageName, typeName, name);
            } else {
                this.addVariable(2, typePackageName, typeName, name);
            }
        }

        public void acceptLocalVariable(char[] name, char[] typePackageName, char[] typeName, int modifiers, int completionStart, int completionEnd, int relevance) {
            this.addVariable(0, typePackageName, typeName, name);
        }
    }
}

