/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class MethodStubCompletionProposal
extends JavaTypeCompletionProposal {
    private String fTypeName;
    private String fMethodName;
    private String[] fParamTypes;
    private IJavaProject fJavaProject;

    public MethodStubCompletionProposal(IJavaProject jproject, ICompilationUnit cu, String declaringTypeName, String methodName, String[] paramTypes, int start, int length, String displayName, String completionProposal) {
        super(completionProposal, cu, start, length, null, displayName, 0);
        Assert.isNotNull((Object)jproject);
        Assert.isNotNull((Object)methodName);
        Assert.isNotNull((Object)declaringTypeName);
        Assert.isNotNull((Object)paramTypes);
        this.fTypeName = declaringTypeName;
        this.fParamTypes = paramTypes;
        this.fMethodName = methodName;
        this.fJavaProject = jproject;
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset, ImportsStructure impStructure) throws CoreException, BadLocationException {
        IMethod method;
        IType declaringType = this.fJavaProject.findType(this.fTypeName);
        if (declaringType != null && (method = JavaModelUtil.findMethod(this.fMethodName, this.fParamTypes, false, declaringType)) != null) {
            IJavaElement currElem;
            StubUtility.GenStubSettings settings = new StubUtility.GenStubSettings(JavaPreferencesSettings.getCodeGenerationSettings());
            IType definingType = null;
            if (impStructure != null && (currElem = impStructure.getCompilationUnit().getElementAt(offset)) != null) {
                definingType = (IType)currElem.getAncestor(7);
            }
            settings.noBody = definingType != null && definingType.isInterface();
            settings.callSuper = declaringType.isClass() && !Flags.isAbstract((int)method.getFlags()) && !Flags.isStatic((int)method.getFlags());
            settings.methodOverwrites = !Flags.isStatic((int)method.getFlags());
            String definingTypeName = definingType != null ? definingType.getElementName() : "";
            String stub = StubUtility.genStub(this.fCompilationUnit, definingTypeName, method, declaringType, settings, impStructure);
            String lineDelim = StubUtility.getLineDelimiterFor(document);
            IRegion region = document.getLineInformationOfOffset(this.getReplacementOffset());
            int lineStart = region.getOffset();
            int indent = Strings.computeIndent(document.get(lineStart, this.getReplacementOffset() - lineStart), settings.tabWidth);
            String replacement = StubUtility.codeFormat(stub, indent, lineDelim);
            this.setReplacementString(Strings.trimLeadingTabsAndSpaces(replacement));
            return true;
        }
        return false;
    }
}

