/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;

public class JavaStringAutoIndentStrategy
extends DefaultAutoIndentStrategy {
    private boolean isLineDelimiters(IDocument document, String text) throws BadLocationException {
        String[] delimiters = document.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.equals((String[])delimiters, (String)text) > -1;
        }
        return false;
    }

    private String getLineIndentation(IDocument document, int offset) throws BadLocationException {
        int adjustedOffset = offset == document.getLength() ? offset - 1 : offset;
        IRegion line = document.getLineInformationOfOffset(adjustedOffset);
        int start = line.getOffset();
        int end = this.findEndOfWhiteSpace(document, start, offset);
        return document.get(start, end - start);
    }

    private String getModifiedText(String string, String lineDelimiter, String indentation) throws BadLocationException {
        String indentedLine = String.valueOf(lineDelimiter) + indentation;
        Document document = new Document(string);
        StringBuffer buffer = new StringBuffer();
        IRegion line = document.getLineInformation(0);
        buffer.append(document.get(line.getOffset(), line.getLength()));
        buffer.append("\" +");
        int lineCount = document.getNumberOfLines();
        int i = 1;
        while (i < lineCount - 1) {
            line = document.getLineInformation(i);
            buffer.append(indentedLine);
            buffer.append('\"');
            buffer.append(document.get(line.getOffset(), line.getLength()));
            buffer.append("\" +");
            ++i;
        }
        line = document.getLineInformation(lineCount - 1);
        buffer.append(indentedLine);
        buffer.append('\"');
        buffer.append(document.get(line.getOffset(), line.getLength()));
        return buffer.toString();
    }

    private void javaStringIndentAfterNewLine(IDocument document, DocumentCommand command) throws BadLocationException {
        ITypedRegion partition = document.getPartition(command.offset);
        int offset = partition.getOffset();
        int length = partition.getLength();
        if (command.offset == offset) {
            return;
        }
        if (command.offset == offset + length && document.getChar(offset + length - 1) == '\"') {
            return;
        }
        String[] legalLineDelimiters = document.getLegalLineDelimiters();
        String lineDelimiter = legalLineDelimiters[0];
        String indentation = this.getLineIndentation(document, command.offset);
        IRegion line = document.getLineInformationOfOffset(offset);
        String string = document.get(line.getOffset(), offset - line.getOffset());
        if (string.trim().length() != 0) {
            indentation = String.valueOf(indentation) + String.valueOf('\t');
        }
        command.text = this.getModifiedText(command.text, lineDelimiter, indentation);
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        try {
            if (command.length != 0 || command.text == null) {
                return;
            }
            IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
            if (preferenceStore.getBoolean("wrapStrings") && this.isLineDelimiters(document, command.text)) {
                this.javaStringIndentAfterNewLine(document, command);
            }
        }
        catch (BadLocationException badLocationException) {}
    }
}

