/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.IProblemRequestorExtension;
import org.eclipse.jdt.internal.ui.text.java.IReconcilingParticipant;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private ITextEditor fEditor;
    private IWorkingCopyManager fManager;
    private IDocumentProvider fDocumentProvider;
    private IProgressMonitor fProgressMonitor;
    private boolean fNotify = true;

    public JavaReconcilingStrategy(ITextEditor editor) {
        this.fEditor = editor;
        this.fManager = JavaPlugin.getDefault().getWorkingCopyManager();
        this.fDocumentProvider = JavaPlugin.getDefault().getCompilationUnitDocumentProvider();
    }

    private IProblemRequestorExtension getProblemRequestorExtension() {
        IAnnotationModel model = this.fDocumentProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (model instanceof IProblemRequestorExtension) {
            return (IProblemRequestorExtension)model;
        }
        return null;
    }

    private void reconcile() {
        ICompilationUnit unit = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
        if (unit != null) {
            try {
                IProblemRequestorExtension extension = this.getProblemRequestorExtension();
                if (extension != null) {
                    extension.setProgressMonitor(this.fProgressMonitor);
                }
                ICompilationUnit iCompilationUnit = unit;
                synchronized (iCompilationUnit) {
                    unit.reconcile(true, this.fProgressMonitor);
                }
                if (extension != null) {
                    extension.setProgressMonitor(null);
                }
                try {
                    if (this.fEditor instanceof IReconcilingParticipant && this.fNotify && !this.fProgressMonitor.isCanceled()) {
                        IReconcilingParticipant p = (IReconcilingParticipant)this.fEditor;
                        p.reconciled();
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.fNotify = true;
                    throw throwable;
                }
                Object var4_6 = null;
                this.fNotify = true;
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    public void reconcile(IRegion partition) {
        this.reconcile();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile();
    }

    public void setDocument(IDocument document) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public void initialReconcile() {
        this.reconcile();
    }

    public void notifyParticipants(boolean notify) {
        this.fNotify = notify;
    }
}

