/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;

public class JavaFormattingStrategy
implements IFormattingStrategy {
    private String fInitialIndentation;
    private ISourceViewer fViewer;

    public JavaFormattingStrategy(ISourceViewer viewer) {
        this.fViewer = viewer;
    }

    public void formatterStarts(String initialIndentation) {
        this.fInitialIndentation = initialIndentation;
    }

    public void formatterStops() {
    }

    public String format(String content, boolean isLineStart, String indentation, int[] positions) {
        ICodeFormatter formatter = ToolFactory.createCodeFormatter();
        IDocument doc = this.fViewer.getDocument();
        String lineDelimiter = StubUtility.getLineDelimiterFor(doc);
        int indent = 0;
        if (this.fInitialIndentation != null) {
            indent = Strings.computeIndent(this.fInitialIndentation, CodeFormatterUtil.getTabWidth());
        }
        return formatter.format(content, indent, positions, lineDelimiter);
    }
}

