/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.template.ContextType;
import org.eclipse.jdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.text.JavaCodeReader;
import org.eclipse.jdt.internal.ui.text.java.ExperimentalResultCollector;
import org.eclipse.jdt.internal.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComparator;
import org.eclipse.jdt.internal.ui.text.java.JavaParameterListValidator;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.internal.ui.text.java.ResultCollector;
import org.eclipse.jdt.internal.ui.text.template.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.TemplateProposal;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class JavaCompletionProcessor
implements IContentAssistProcessor {
    private static final String VISIBILITY = "org.eclipse.jdt.core.codeComplete.visibilityCheck";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    protected IWorkingCopyManager fManager;
    private IEditorPart fEditor;
    private ResultCollector fCollector;
    private IContextInformationValidator fValidator;
    private char[] fProposalAutoActivationSet;
    private JavaCompletionProposalComparator fComparator;
    private boolean fAllowAddImports;
    private TemplateEngine fTemplateEngine;
    private ExperimentalResultCollector fExperimentalCollector;
    private int fNumberOfComputedResults = 0;

    public JavaCompletionProcessor(IEditorPart editor) {
        this.fEditor = editor;
        this.fCollector = new ResultCollector();
        this.fManager = JavaPlugin.getDefault().getWorkingCopyManager();
        ContextType contextType = ContextTypeRegistry.getInstance().getContextType("java");
        if (contextType != null) {
            this.fTemplateEngine = new TemplateEngine(contextType);
        }
        this.fExperimentalCollector = new ExperimentalResultCollector();
        this.fAllowAddImports = true;
        this.fComparator = new JavaCompletionProposalComparator();
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    public void restrictProposalsToVisibility(boolean restrict) {
        Hashtable options = JavaCore.getOptions();
        Object value = options.get(VISIBILITY);
        if (value instanceof String) {
            String newValue;
            String string = newValue = restrict ? ENABLED : DISABLED;
            if (!newValue.equals((String)value)) {
                options.put(VISIBILITY, newValue);
                JavaCore.setOptions((Hashtable)options);
            }
        }
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }

    public void restrictProposalsToMatchingCases(boolean restrict) {
    }

    public void allowAddingImports(boolean allowAddingImports) {
        this.fAllowAddImports = allowAddingImports;
    }

    public String getErrorMessage() {
        if (this.fNumberOfComputedResults == 0) {
            String errorMsg = this.fCollector.getErrorMessage();
            if (errorMsg == null || errorMsg.trim().length() == 0) {
                errorMsg = JavaUIMessages.getString("JavaEditor.codeassist.noCompletions");
            }
            return errorMsg;
        }
        if (PreferenceConstants.getPreferenceStore().getBoolean("content_assist_fill_method_arguments")) {
            return this.fExperimentalCollector.getErrorMessage();
        }
        return this.fCollector.getErrorMessage();
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new JavaParameterListValidator();
        }
        return this.fValidator;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    private boolean looksLikeMethod(JavaCodeReader reader) throws IOException {
        int curr = reader.read();
        while (curr != -1 && Character.isWhitespace((char)curr)) {
            curr = reader.read();
        }
        if (curr == -1) {
            return false;
        }
        return Character.isJavaIdentifierPart((char)curr) || Character.isJavaIdentifierStart((char)curr);
    }

    private int guessContextInformationPosition(ITextViewer viewer, int offset) {
        int contextPosition = offset;
        IDocument document = viewer.getDocument();
        try {
            JavaCodeReader reader = new JavaCodeReader();
            reader.configureBackwardReader(document, offset, true, true);
            int nestingLevel = 0;
            int curr = reader.read();
            while (curr != -1) {
                if (')' == (char)curr) {
                    ++nestingLevel;
                } else if ('(' == (char)curr && --nestingLevel < 0) {
                    int start = reader.getOffset();
                    if (this.looksLikeMethod(reader)) {
                        return start + 1;
                    }
                }
                curr = reader.read();
            }
        }
        catch (IOException iOException) {}
        return contextPosition;
    }

    private List addContextInformations(ITextViewer viewer, int offset) {
        ICompletionProposal[] proposals = this.internalComputeCompletionProposals(viewer, offset, -1);
        ArrayList<ContextInformationWrapper> result = new ArrayList<ContextInformationWrapper>();
        int i = 0;
        while (i < proposals.length) {
            IContextInformation contextInformation = proposals[i].getContextInformation();
            if (contextInformation != null) {
                ContextInformationWrapper wrapper = new ContextInformationWrapper(contextInformation);
                wrapper.setContextInformationPosition(offset);
                result.add(wrapper);
            }
            ++i;
        }
        return result;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        int contextInformationPosition = this.guessContextInformationPosition(viewer, offset);
        List result = this.addContextInformations(viewer, contextInformationPosition);
        return result.toArray(new IContextInformation[result.size()]);
    }

    private ICompletionProposal[] order(ICompletionProposal[] proposals) {
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        int contextInformationPosition = this.guessContextInformationPosition(viewer, offset);
        return this.internalComputeCompletionProposals(viewer, offset, contextInformationPosition);
    }

    private ICompletionProposal[] internalComputeCompletionProposals(ITextViewer viewer, int offset, int contextOffset) {
        Shell shell;
        ICompilationUnit unit = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
        ResultCollector collector = PreferenceConstants.getPreferenceStore().getBoolean("content_assist_fill_method_arguments") ? this.fExperimentalCollector : this.fCollector;
        try {
            if (unit != null) {
                collector.setPreventEating(false);
                collector.reset(offset, contextOffset, unit.getJavaProject(), (ICompilationUnit)(this.fAllowAddImports ? unit : null));
                collector.setViewer(viewer);
                Point selection = viewer.getSelectedRange();
                if (selection.y > 0) {
                    collector.setReplacementLength(selection.y);
                }
                unit.codeComplete(offset, (ICompletionRequestor)collector);
            }
        }
        catch (JavaModelException x) {
            shell = viewer.getTextWidget().getShell();
            ErrorDialog.openError((Shell)shell, (String)JavaTextMessages.getString("CompletionProcessor.error.accessing.title"), (String)JavaTextMessages.getString("CompletionProcessor.error.accessing.message"), (IStatus)x.getStatus());
        }
        ICompletionProposal[] results = collector.getResults();
        if (this.fTemplateEngine != null) {
            try {
                this.fTemplateEngine.reset();
                this.fTemplateEngine.complete(viewer, offset, unit);
            }
            catch (JavaModelException x) {
                shell = viewer.getTextWidget().getShell();
                ErrorDialog.openError((Shell)shell, (String)JavaTextMessages.getString("CompletionProcessor.error.accessing.title"), (String)JavaTextMessages.getString("CompletionProcessor.error.accessing.message"), (IStatus)x.getStatus());
            }
            TemplateProposal[] templateResults = this.fTemplateEngine.getResults();
            JavaCompletionProposal[] keyWordResults = collector.getKeywordCompletions();
            int i = 0;
            while (i < keyWordResults.length) {
                String keyword = keyWordResults[i].getReplacementString();
                int k = 0;
                while (k < templateResults.length) {
                    TemplateProposal curr = templateResults[k];
                    if (keyword.equals(curr.getTemplate().getName())) {
                        curr.setRelevance(keyWordResults[i].getRelevance());
                    }
                    ++k;
                }
                ++i;
            }
            IJavaCompletionProposal[] total = new IJavaCompletionProposal[results.length + templateResults.length];
            System.arraycopy(templateResults, 0, total, 0, templateResults.length);
            System.arraycopy(results, 0, total, templateResults.length, results.length);
            results = total;
        }
        this.fNumberOfComputedResults = results == null ? 0 : results.length;
        return this.order(results);
    }

    private static class ContextInformationWrapper
    implements IContextInformation,
    IContextInformationExtension {
        private final IContextInformation fContextInformation;
        private int fPosition;

        public ContextInformationWrapper(IContextInformation contextInformation) {
            this.fContextInformation = contextInformation;
        }

        public String getContextDisplayString() {
            return this.fContextInformation.getContextDisplayString();
        }

        public Image getImage() {
            return this.fContextInformation.getImage();
        }

        public String getInformationDisplayString() {
            return this.fContextInformation.getInformationDisplayString();
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public void setContextInformationPosition(int position) {
            this.fPosition = position;
        }
    }
}

