/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.jdt.internal.ui.text.JavaWhitespaceDetector;
import org.eclipse.jdt.internal.ui.text.JavaWordDetector;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class JavaCodeScanner
extends AbstractJavaScanner {
    private static final String SOURCE_VERSION = "org.eclipse.jdt.core.compiler.source";
    private static String[] fgKeywords = new String[]{"abstract", "break", "case", "catch", "class", "const", "continue", "default", "do", "else", "extends", "final", "finally", "for", "goto", "if", "implements", "import", "instanceof", "interface", "native", "new", "package", "private", "protected", "public", "return", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "volatile", "while"};
    private static String[] fgNewKeywords = new String[]{"assert"};
    private static String[] fgTypes = new String[]{"void", "boolean", "char", "byte", "short", "strictfp", "int", "long", "float", "double"};
    private static String[] fgConstants = new String[]{"false", "null", "true"};
    private static String[] fgTokenProperties = new String[]{"java_keyword", "java_string", "java_default"};
    private VersionedWordRule fVersionedWordRule;

    public JavaCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token token = this.getToken("java_string");
        rules.add(new SingleLineRule("'", "'", (IToken)token, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new JavaWhitespaceDetector()));
        Object version = null;
        try {
            version = JavaCore.getOptions().get(SOURCE_VERSION);
        }
        catch (NullPointerException nullPointerException) {}
        if (version instanceof String) {
            token = this.getToken("java_default");
            this.fVersionedWordRule = new VersionedWordRule(new JavaWordDetector(), (IToken)token, "1.4", true, version);
            token = this.getToken("java_keyword");
            int i = 0;
            while (i < fgNewKeywords.length) {
                this.fVersionedWordRule.addWord(fgNewKeywords[i], (IToken)token);
                ++i;
            }
            rules.add((Object)this.fVersionedWordRule);
        }
        token = this.getToken("java_default");
        WordRule wordRule = new WordRule((IWordDetector)new JavaWordDetector(), (IToken)token);
        token = this.getToken("java_keyword");
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)token);
            ++i;
        }
        i = 0;
        while (i < fgTypes.length) {
            wordRule.addWord(fgTypes[i], (IToken)token);
            ++i;
        }
        i = 0;
        while (i < fgConstants.length) {
            wordRule.addWord(fgConstants[i], (IToken)token);
            ++i;
        }
        rules.add(wordRule);
        this.setDefaultReturnToken((IToken)this.getToken("java_default"));
        return rules;
    }

    public void setRules(IRule[] rules) {
        int i = 0;
        while (i < rules.length) {
            if (rules[i].equals((Object)this.fVersionedWordRule)) break;
            ++i;
        }
        if (i == rules.length) {
            this.fVersionedWordRule = null;
        }
        super.setRules(rules);
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return event.getProperty().equals(SOURCE_VERSION) || super.affectsBehavior(event);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(SOURCE_VERSION)) {
            Object value = event.getNewValue();
            if (value instanceof String) {
                String s = (String)value;
                if (this.fVersionedWordRule != null) {
                    this.fVersionedWordRule.setCurrentVersion(s);
                }
            }
        } else if (super.affectsBehavior(event)) {
            super.adaptToPreferenceChange(event);
        }
    }

    private static class VersionedWordRule
    extends WordRule {
        private final IToken fDefaultToken;
        private final String fVersion;
        private final boolean fEnable;
        private String fCurrentVersion;

        public VersionedWordRule(IWordDetector detector, IToken defaultToken, String version, boolean enable, String currentVersion) {
            super(detector);
            this.fDefaultToken = defaultToken;
            this.fVersion = version;
            this.fEnable = enable;
            this.fCurrentVersion = currentVersion;
        }

        public void setCurrentVersion(String version) {
            this.fCurrentVersion = version;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            IToken token = super.evaluate(scanner);
            if (this.fEnable) {
                if (this.fCurrentVersion.equals(this.fVersion) || token.isUndefined()) {
                    return token;
                }
                return this.fDefaultToken;
            }
            if (this.fCurrentVersion.equals(this.fVersion)) {
                return Token.UNDEFINED;
            }
            return token;
        }
    }
}

