/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;

public class JavaAutoIndentStrategy
extends DefaultAutoIndentStrategy {
    private static final String COMMENT = "//";
    private int fTabWidth = -1;
    private boolean fUseSpaces = JavaAutoIndentStrategy.getPreferenceStore().getBoolean("spacesForTabs");

    protected int findMatchingOpenBracket(IDocument d, int line, int end, int closingBracketIncrease) throws BadLocationException {
        int start = d.getLineOffset(line);
        int brackcount = this.getBracketCount(d, start, end, false) - closingBracketIncrease;
        while (brackcount < 0) {
            if (--line < 0) {
                return -1;
            }
            start = d.getLineOffset(line);
            end = start + d.getLineLength(line) - 1;
            brackcount += this.getBracketCount(d, start, end, false);
        }
        return line;
    }

    private int getBracketCount(IDocument d, int start, int end, boolean ignoreCloseBrackets) throws BadLocationException {
        int bracketcount = 0;
        block7: while (start < end) {
            char curr = d.getChar(start);
            ++start;
            switch (curr) {
                case '/': {
                    if (start >= end) break;
                    char next = d.getChar(start);
                    if (next == '*') {
                        start = this.getCommentEnd(d, start + 1, end);
                        break;
                    }
                    if (next != '/') break;
                    start = end;
                    break;
                }
                case '*': {
                    char next;
                    if (start >= end || (next = d.getChar(start)) != '/') continue block7;
                    bracketcount = 0;
                    ++start;
                    break;
                }
                case '{': {
                    ++bracketcount;
                    ignoreCloseBrackets = false;
                    break;
                }
                case '}': {
                    if (ignoreCloseBrackets) break;
                    --bracketcount;
                    break;
                }
                case '\"': 
                case '\'': {
                    start = this.getStringEnd(d, start, end, curr);
                }
            }
        }
        return bracketcount;
    }

    private int getCommentEnd(IDocument d, int pos, int end) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            if (curr != '*' || ++pos >= end || d.getChar(pos) != '/') continue;
            return pos + 1;
        }
        return end;
    }

    protected String getIndentOfLine(IDocument d, int line) throws BadLocationException {
        if (line > -1) {
            int start = d.getLineOffset(line);
            int end = start + d.getLineLength(line) - 1;
            int whiteend = this.findEndOfWhiteSpace(d, start, end);
            return d.get(start, whiteend - start);
        }
        return "";
    }

    private int getStringEnd(IDocument d, int pos, int end, char ch) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            ++pos;
            if (curr == '\\') {
                ++pos;
                continue;
            }
            if (curr != ch) continue;
            return pos;
        }
        return end;
    }

    protected void smartInsertAfterBracket(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int indLine;
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            int start = d.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(d, start, c.offset);
            if (whiteend == c.offset && (indLine = this.findMatchingOpenBracket(d, line, c.offset, 1)) != -1 && indLine != line) {
                StringBuffer replaceText = new StringBuffer(this.getIndentOfLine(d, indLine));
                replaceText.append(d.get(whiteend, c.offset - whiteend));
                replaceText.append(c.text);
                c.length += c.offset - start;
                c.offset = start;
                c.text = replaceText.toString();
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    protected void smartIndentAfterNewLine(IDocument d, DocumentCommand c) {
        int docLength = d.getLength();
        if (c.offset == -1 || docLength == 0) {
            return;
        }
        try {
            int p = c.offset == docLength ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            StringBuffer buf = new StringBuffer(c.text);
            if (c.offset < docLength && d.getChar(c.offset) == '}') {
                int indLine = this.findMatchingOpenBracket(d, line, c.offset, 0);
                if (indLine == -1) {
                    indLine = line;
                }
                buf.append(this.getIndentOfLine(d, indLine));
            } else {
                ITypedRegion region;
                int start = d.getLineOffset(line);
                IDocumentPartitioner partitioner = d.getDocumentPartitioner();
                if (partitioner != null && "__java_javadoc".equals((region = partitioner.getPartition(start)).getType())) {
                    start = d.getLineInformationOfOffset(region.getOffset()).getOffset();
                }
                int whiteend = this.findEndOfWhiteSpace(d, start, c.offset);
                buf.append(d.get(start, whiteend - start));
                if (this.getBracketCount(d, start, c.offset, true) > 0) {
                    buf.append(this.createIndent(1, this.useSpaces()));
                }
            }
            c.text = buf.toString();
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    private static String getLineDelimiter(IDocument document) {
        try {
            if (document.getNumberOfLines() > 1) {
                return document.getLineDelimiter(0);
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        return System.getProperty("line.separator");
    }

    private static boolean startsWithClosingBrace(String string) {
        int length = string.length();
        int i = 0;
        while (i != length && Character.isWhitespace(string.charAt(i))) {
            ++i;
        }
        if (i == length) {
            return false;
        }
        return string.charAt(i) == '}';
    }

    protected void smartPaste(IDocument document, DocumentCommand command) {
        String lineDelimiter = JavaAutoIndentStrategy.getLineDelimiter(document);
        try {
            int offset;
            int line;
            int lineOffset;
            String prefix;
            int newIndentSize;
            String blockIndent;
            String pastedText = command.text;
            Assert.isNotNull(pastedText);
            Assert.isTrue(pastedText.length() > 1);
            int selectionStart = command.offset;
            IRegion region = document.getLineInformationOfOffset(selectionStart);
            String notSelected = document.get(region.getOffset(), selectionStart - region.getOffset());
            String selected = document.get(selectionStart, region.getOffset() + region.getLength() - selectionStart);
            if (notSelected.trim().length() == 0 && selected.trim().length() != 0) {
                pastedText = String.valueOf(notSelected) + pastedText;
                command.length += notSelected.length();
                command.offset = region.getOffset();
            }
            String insideBlockIndent = (blockIndent = this.getBlockIndent(document, command)) == null ? "" : String.valueOf(blockIndent) + this.createIndent(1, this.useSpaces());
            int insideBlockIndentSize = JavaAutoIndentStrategy.calculateDisplayedWidth(insideBlockIndent, this.getTabWidth());
            int previousIndentSize = this.getIndentSize(document, command);
            int n = newIndentSize = insideBlockIndentSize < previousIndentSize ? insideBlockIndentSize : previousIndentSize;
            if (JavaAutoIndentStrategy.startsWithClosingBrace(pastedText)) {
                int outsideBlockIndentSize;
                newIndentSize = outsideBlockIndentSize = blockIndent == null ? 0 : JavaAutoIndentStrategy.calculateDisplayedWidth(blockIndent, this.getTabWidth());
            }
            boolean formatFirstLine = (prefix = document.get(lineOffset = document.getLineOffset(line = document.getLineOfOffset(offset = command.offset)), offset - lineOffset)).trim().length() == 0;
            String formattedParagraph = this.format(pastedText, newIndentSize, lineDelimiter, formatFirstLine);
            if (formatFirstLine) {
                int end = command.offset + command.length;
                command.offset = lineOffset;
                command.length = end - command.offset;
            }
            command.text = formattedParagraph;
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    private static String getIndentOfLine(String line) {
        int i = 0;
        while (i < line.length()) {
            if (!Character.isWhitespace(line.charAt(i))) break;
            ++i;
        }
        return line.substring(0, i);
    }

    private static int getIndentSizeOfFirstLine(String paragraph, boolean includeFirstLine, int tabWidth) {
        LineIterator iterator = new LineIterator(paragraph);
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            if (!includeFirstLine) {
                includeFirstLine = true;
                continue;
            }
            String indent = null;
            if (line.startsWith(COMMENT)) {
                String commentedLine = line.substring(2);
                if (commentedLine.trim().length() == 0) continue;
                indent = COMMENT + JavaAutoIndentStrategy.getIndentOfLine(commentedLine);
            } else {
                if (line.trim().length() == 0) continue;
                indent = JavaAutoIndentStrategy.getIndentOfLine(line);
            }
            return JavaAutoIndentStrategy.calculateDisplayedWidth(indent, tabWidth);
        }
        return 0;
    }

    private static int getMinimalIndentSize(String paragraph, boolean includeFirstLine, int tabWidth) {
        int minIndentSize = Integer.MAX_VALUE;
        LineIterator iterator = new LineIterator(paragraph);
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            if (!includeFirstLine) {
                includeFirstLine = true;
                continue;
            }
            String indent = null;
            if (line.startsWith(COMMENT)) {
                String commentedLine = line.substring(2);
                if (commentedLine.trim().length() == 0) continue;
                indent = COMMENT + JavaAutoIndentStrategy.getIndentOfLine(commentedLine);
            } else {
                if (line.trim().length() == 0) continue;
                indent = JavaAutoIndentStrategy.getIndentOfLine(line);
            }
            int indentSize = JavaAutoIndentStrategy.calculateDisplayedWidth(indent, tabWidth);
            if (indentSize >= minIndentSize) continue;
            minIndentSize = indentSize;
        }
        return minIndentSize == Integer.MAX_VALUE ? 0 : minIndentSize;
    }

    private static int calculateDisplayedWidth(String string, int tabWidth) {
        int column = 0;
        int i = 0;
        while (i < string.length()) {
            column = '\t' == string.charAt(i) ? (column += tabWidth - column % tabWidth) : ++column;
            ++i;
        }
        return column;
    }

    private static boolean isLineEmpty(IDocument document, int line) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        String string = document.get(region.getOffset(), region.getLength());
        return string.trim().length() == 0;
    }

    private int getIndentSize(IDocument document, DocumentCommand command) {
        StringBuffer buffer = new StringBuffer();
        int docLength = document.getLength();
        if (command.offset == -1 || docLength == 0) {
            return 0;
        }
        try {
            int p = command.offset == docLength ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(p);
            IRegion region = document.getLineInformation(line);
            String string = document.get(region.getOffset(), command.offset - region.getOffset());
            if (line != 0 && string.trim().length() == 0) {
                --line;
            }
            while (line != 0 && JavaAutoIndentStrategy.isLineEmpty(document, line)) {
                --line;
            }
            int start = document.getLineOffset(line);
            IDocumentPartitioner partitioner = document.getDocumentPartitioner();
            if (partitioner != null) {
                ITypedRegion typedRegion = partitioner.getPartition(start);
                if ("__java_javadoc".equals(typedRegion.getType())) {
                    start = document.getLineInformationOfOffset(typedRegion.getOffset()).getOffset();
                } else if ("__java_singleline_comment".equals(typedRegion.getType())) {
                    buffer.append(COMMENT);
                    start += 2;
                }
            }
            int whiteend = this.findEndOfWhiteSpace(document, start, command.offset);
            buffer.append(document.get(start, whiteend - start));
            if (this.getBracketCount(document, start, command.offset, true) > 0) {
                buffer.append(this.createIndent(1, this.useSpaces()));
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        return JavaAutoIndentStrategy.calculateDisplayedWidth(buffer.toString(), this.getTabWidth());
    }

    private String getBlockIndent(IDocument d, DocumentCommand c) {
        if (c.offset < 0 || d.getLength() == 0) {
            return null;
        }
        try {
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            int indLine = this.findMatchingOpenBracket(d, line, c.offset, 1);
            if (indLine != -1) {
                return this.getIndentOfLine(d, indLine);
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    private String createIndent(int level, boolean useSpaces) {
        StringBuffer buffer = new StringBuffer();
        if (useSpaces) {
            int width = level * this.getTabWidth();
            int i = 0;
            while (i != width) {
                buffer.append(' ');
                ++i;
            }
        } else {
            int i = 0;
            while (i != level) {
                buffer.append('\t');
                ++i;
            }
        }
        return buffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static String changePrefix(String string, int displayedWidth, boolean useSpaces, int tabWidth) {
        block4: {
            buffer = new StringBuffer(string);
            column = JavaAutoIndentStrategy.calculateDisplayedWidth(buffer.toString(), tabWidth);
            if (column > displayedWidth) {
                return string;
            }
            if (!useSpaces) ** GOTO lbl20
            while (column != displayedWidth) {
                buffer.append(' ');
                ++column;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                if (column + tabWidth - column % tabWidth <= displayedWidth) {
                    buffer.append('\t');
                    column += tabWidth - column % tabWidth;
                    continue;
                }
                buffer.append(' ');
                ++column;
lbl20:
                // 3 sources

                ** while (column != displayedWidth)
            }
        }
        return buffer.toString();
    }

    private String format(String paragraph, int newIndentSize, String lineDelimiter, boolean indentFirstLine) {
        int minIndentSize;
        int tabWidth = this.getTabWidth();
        int firstLineIndentSize = JavaAutoIndentStrategy.getIndentSizeOfFirstLine(paragraph, indentFirstLine, tabWidth);
        if (newIndentSize < firstLineIndentSize - (minIndentSize = JavaAutoIndentStrategy.getMinimalIndentSize(paragraph, indentFirstLine, tabWidth))) {
            newIndentSize = firstLineIndentSize - minIndentSize;
        }
        StringBuffer buffer = new StringBuffer();
        LineIterator iterator = new LineIterator(paragraph);
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            if (indentFirstLine) {
                String lineIndent = null;
                lineIndent = line.startsWith(COMMENT) ? COMMENT + JavaAutoIndentStrategy.getIndentOfLine(line.substring(2)) : JavaAutoIndentStrategy.getIndentOfLine(line);
                String lineContent = line.substring(lineIndent.length());
                if (lineContent.length() == 0) {
                    buffer.append(line);
                } else {
                    int indentSize = JavaAutoIndentStrategy.calculateDisplayedWidth(lineIndent, tabWidth);
                    int deltaSize = newIndentSize - firstLineIndentSize;
                    lineIndent = JavaAutoIndentStrategy.changePrefix(lineIndent.trim(), indentSize + deltaSize, this.useSpaces(), tabWidth);
                    buffer.append(lineIndent);
                    buffer.append(lineContent);
                }
            } else {
                indentFirstLine = true;
                buffer.append(line);
            }
            if (!iterator.hasNext()) continue;
            buffer.append(lineDelimiter);
        }
        return buffer.toString();
    }

    private boolean equalsDelimiter(IDocument d, String txt) {
        String[] delimiters = d.getLegalLineDelimiters();
        int i = 0;
        while (i < delimiters.length) {
            if (txt.equals(delimiters[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void smartIndentAfterBlockDelimiter(IDocument document, DocumentCommand command) {
        if (command.text.charAt(0) == '}') {
            this.smartInsertAfterBracket(document, command);
        }
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.length == 0 && c.text != null && this.equalsDelimiter(d, c.text)) {
            this.smartIndentAfterNewLine(d, c);
        } else if (c.text.length() == 1) {
            this.smartIndentAfterBlockDelimiter(d, c);
        } else if (c.text.length() > 1 && JavaAutoIndentStrategy.getPreferenceStore().getBoolean("smartPaste")) {
            this.smartPaste(d, c);
        }
        this.clearCachedValues();
    }

    private static IPreferenceStore getPreferenceStore() {
        return JavaPlugin.getDefault().getPreferenceStore();
    }

    private boolean useSpaces() {
        return this.fUseSpaces;
    }

    private int getTabWidth() {
        if (this.fTabWidth == -1) {
            this.fTabWidth = Integer.parseInt((String)JavaCore.getOptions().get("org.eclipse.jdt.core.formatter.tabulation.size"));
        }
        return this.fTabWidth;
    }

    private void clearCachedValues() {
        this.fTabWidth = -1;
        this.fUseSpaces = JavaAutoIndentStrategy.getPreferenceStore().getBoolean("spacesForTabs");
    }

    private static final class LineIterator
    implements Iterator {
        private final IDocument fDocument;
        private int fLineIndex;

        public LineIterator(String string) {
            this.fDocument = new Document(string);
        }

        public boolean hasNext() {
            return this.fLineIndex != this.fDocument.getNumberOfLines();
        }

        public Object next() {
            try {
                IRegion region = this.fDocument.getLineInformation(this.fLineIndex++);
                return this.fDocument.get(region.getOffset(), region.getLength());
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

