/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.OverrideMethodQuery;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class AnonymousTypeCompletionProposal
extends JavaTypeCompletionProposal {
    private IType fDeclaringType;

    public AnonymousTypeCompletionProposal(IJavaProject jproject, ICompilationUnit cu, int start, int length, String constructorCompletion, String displayName, String declaringTypeName, int relevance) {
        super(constructorCompletion, cu, start, length, null, displayName, relevance);
        Assert.isNotNull((Object)declaringTypeName);
        Assert.isNotNull((Object)jproject);
        this.fDeclaringType = this.getDeclaringType(jproject, declaringTypeName);
        this.setImage(this.getImageForType(this.fDeclaringType));
        this.setCursorPosition(constructorCompletion.indexOf(40) + 1);
    }

    private Image getImageForType(IType type) {
        String imageName = "org.eclipse.jdt.ui.class_obj.gif";
        if (type != null) {
            try {
                if (type.isInterface()) {
                    imageName = "org.eclipse.jdt.ui.int_obj.gif";
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return JavaPluginImages.get(imageName);
    }

    private IType getDeclaringType(IJavaProject project, String typeName) {
        try {
            return JavaModelUtil.findType(project, typeName);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset, ImportsStructure impStructure) throws CoreException, BadLocationException {
        String replacementString = this.getReplacementString();
        StringBuffer buf = new StringBuffer();
        buf.append(replacementString);
        if (!replacementString.endsWith(")")) {
            buf.append(')');
        }
        buf.append(" {\n");
        if (!this.createStubs(buf, impStructure)) {
            return false;
        }
        buf.append("}");
        String lineDelim = StubUtility.getLineDelimiterFor(document);
        int tabWidth = CodeFormatterUtil.getTabWidth();
        IRegion region = document.getLineInformationOfOffset(this.getReplacementOffset());
        int indent = Strings.computeIndent(document.get(region.getOffset(), region.getLength()), tabWidth);
        String replacement = StubUtility.codeFormat(buf.toString(), indent, lineDelim);
        this.setReplacementString(Strings.trimLeadingTabsAndSpaces(replacement));
        int pos = offset;
        while (pos < document.getLength() && Character.isWhitespace(document.getChar(pos))) {
            ++pos;
        }
        if (pos < document.getLength() && document.getChar(pos) == ')') {
            this.setReplacementLength(pos - offset + 1);
        }
        return true;
    }

    private boolean createStubs(StringBuffer buf, ImportsStructure imports) throws CoreException {
        OverrideMethodQuery selectionQuery;
        if (this.fDeclaringType == null) {
            return true;
        }
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        settings.createComments = false;
        ITypeHierarchy hierarchy = this.fDeclaringType.newSupertypeHierarchy(null);
        String[] unimplemented = StubUtility.evalUnimplementedMethods(this.fDeclaringType, hierarchy, true, settings, selectionQuery = this.fDeclaringType.isClass() ? new OverrideMethodQuery(JavaPlugin.getActiveWorkbenchShell(), true) : null, imports);
        if (unimplemented != null) {
            int i = 0;
            while (i < unimplemented.length) {
                buf.append(unimplemented[i]);
                if (i < unimplemented.length - 1) {
                    buf.append('\n');
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

