/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportEdit;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CUCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.ICorrectionContext;
import org.eclipse.jdt.internal.ui.text.correction.LocalCorrectionsSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.NewCUCompletionUsingWizardProposal;
import org.eclipse.jdt.internal.ui.text.correction.NewMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.correction.NewVariableCompletionProposal;
import org.eclipse.jdt.internal.ui.text.correction.ReplaceCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.SimilarElement;
import org.eclipse.jdt.internal.ui.text.correction.SimilarElementsRequestor;
import org.eclipse.swt.graphics.Image;

public class UnresolvedElementsSubProcessor {
    public static void getVariableProposals(ICorrectionContext context, List proposals) throws CoreException {
        ITypeBinding senderBinding;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = context.getCoveredNode();
        if (selectedNode == null) {
            return;
        }
        ITypeBinding binding = null;
        ITypeBinding declaringTypeBinding = ASTResolving.getBindingOfParentType(selectedNode);
        if (declaringTypeBinding == null) {
            return;
        }
        int similarNodeKind = 192;
        SimpleName node = null;
        if (selectedNode instanceof SimpleName) {
            node = (SimpleName)selectedNode;
            ASTNode parent = node.getParent();
            if (parent instanceof MethodInvocation && node.equals((Object)((MethodInvocation)parent).getExpression())) {
                similarNodeKind |= 2;
            }
        } else if (selectedNode instanceof QualifiedName) {
            QualifiedName qualifierName = (QualifiedName)selectedNode;
            ITypeBinding qualifierBinding = qualifierName.getQualifier().resolveTypeBinding();
            if (qualifierBinding != null) {
                node = qualifierName.getName();
                binding = qualifierBinding;
            } else {
                node = qualifierName.getQualifier();
                similarNodeKind = node.isSimpleName() ? (similarNodeKind |= 6) : 6;
            }
        } else if (selectedNode instanceof FieldAccess) {
            FieldAccess access = (FieldAccess)selectedNode;
            Expression expression = access.getExpression();
            if (expression != null && (binding = expression.resolveTypeBinding()) != null) {
                node = access.getName();
            }
        } else if (selectedNode instanceof SuperFieldAccess) {
            binding = declaringTypeBinding.getSuperclass();
        } else if (selectedNode instanceof SimpleType) {
            similarNodeKind = 6;
            node = ((SimpleType)selectedNode).getName();
        }
        if (node == null) {
            return;
        }
        String assignedName = null;
        ASTNode parent = node.getParent();
        if (parent.getNodeType() == 59) {
            assignedName = ((VariableDeclarationFragment)parent).getName().getIdentifier();
        }
        SimilarElement[] elements = SimilarElementsRequestor.findSimilarElement(cu, (Name)node, similarNodeKind);
        int i = 0;
        while (i < elements.length) {
            SimilarElement curr = elements[i];
            if ((curr.getKind() & 0xC0) != 0 && !curr.getName().equals(assignedName)) {
                String label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.changevariable.description", curr.getName());
                proposals.add(new ReplaceCorrectionProposal(label, cu, node.getStartPosition(), node.getLength(), curr.getName(), 3));
            }
            ++i;
        }
        if ((similarNodeKind & 0xE) != 0) {
            int relevance = Character.isUpperCase(ASTResolving.getSimpleName((Name)node).charAt(0)) ? 3 : 0;
            UnresolvedElementsSubProcessor.addSimilarTypeProposals(elements, cu, (Name)node, relevance + 1, proposals);
            UnresolvedElementsSubProcessor.addNewTypeProposals(cu, (Name)node, 6, relevance, proposals);
        }
        if ((similarNodeKind & 0xC0) == 0) {
            return;
        }
        SimpleName simpleName = node.isSimpleName() ? node : ((QualifiedName)node).getName();
        ICompilationUnit targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, binding);
        ITypeBinding iTypeBinding = senderBinding = binding != null ? binding : declaringTypeBinding;
        if (senderBinding.isFromSource() && targetCU != null && JavaModelUtil.isEditable(targetCU)) {
            ASTNode anonymDecl;
            Image image;
            String label;
            if (binding == null) {
                label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createfield.description", simpleName.getIdentifier());
                image = JavaPluginImages.get("org.eclipse.jdt.ui.field_private_obj.gif");
            } else {
                label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createfield.other.description", new Object[]{simpleName.getIdentifier(), binding.getName()});
                image = JavaPluginImages.get("org.eclipse.jdt.ui.field_public_obj.gif");
            }
            proposals.add(new NewVariableCompletionProposal(label, targetCU, 2, simpleName, senderBinding, 2, image));
            if (binding == null && senderBinding.isAnonymous() && (anonymDecl = astRoot.findDeclaringNode((IBinding)senderBinding)) != null && !(senderBinding = ASTResolving.getBindingOfParentType(anonymDecl.getParent())).isAnonymous()) {
                label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createfield.other.description", new Object[]{simpleName.getIdentifier(), senderBinding.getName()});
                image = JavaPluginImages.get("org.eclipse.jdt.ui.field_public_obj.gif");
                proposals.add(new NewVariableCompletionProposal(label, targetCU, 2, simpleName, senderBinding, 2, image));
            }
        }
        if (binding == null) {
            Image image;
            String label;
            BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)node);
            int type = bodyDeclaration.getNodeType();
            if (type == 31) {
                label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createparameter.description", simpleName.getIdentifier());
                image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
                proposals.add(new NewVariableCompletionProposal(label, cu, 3, simpleName, null, 1, image));
            }
            if (type == 31 || type == 28) {
                label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createlocal.description", simpleName.getIdentifier());
                image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
                proposals.add(new NewVariableCompletionProposal(label, cu, 1, simpleName, null, 3, image));
            }
        }
    }

    public static void getTypeProposals(ICorrectionContext context, List proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = context.getCoveringNode();
        if (selectedNode == null) {
            return;
        }
        int kind = 14;
        ASTNode parent = selectedNode.getParent();
        switch (parent.getNodeType()) {
            case 55: {
                TypeDeclaration typeDeclaration = (TypeDeclaration)parent;
                if (typeDeclaration.superInterfaces().contains(selectedNode)) {
                    kind = 4;
                    break;
                }
                if (!selectedNode.equals((Object)typeDeclaration.getSuperclass())) break;
                kind = 2;
                break;
            }
            case 31: {
                MethodDeclaration methodDeclaration = (MethodDeclaration)parent;
                if (methodDeclaration.thrownExceptions().contains(selectedNode)) {
                    kind = 2;
                    break;
                }
                if (!selectedNode.equals((Object)methodDeclaration.getReturnType())) break;
                kind = 22;
                break;
            }
            case 62: {
                kind = 6;
                break;
            }
            case 14: 
            case 53: {
                kind = 6;
                break;
            }
            case 44: {
                int superParent = parent.getParent().getNodeType();
                if (superParent != 12) break;
                kind = 2;
            }
        }
        Name node = null;
        if (selectedNode instanceof SimpleType) {
            node = ((SimpleType)selectedNode).getName();
        } else if (selectedNode instanceof ArrayType) {
            Type elementType = ((ArrayType)selectedNode).getElementType();
            if (elementType.isSimpleType()) {
                node = ((SimpleType)elementType).getName();
            }
        } else if (selectedNode instanceof Name) {
            node = (Name)selectedNode;
        } else {
            return;
        }
        SimilarElement[] elements = SimilarElementsRequestor.findSimilarElement(cu, node, kind);
        UnresolvedElementsSubProcessor.addSimilarTypeProposals(elements, cu, node, 3, proposals);
        UnresolvedElementsSubProcessor.addNewTypeProposals(cu, node, kind, 0, proposals);
    }

    private static void addSimilarTypeProposals(SimilarElement[] elements, ICompilationUnit cu, Name node, int relevance, List proposals) throws JavaModelException {
        String resolvedTypeName = null;
        ITypeBinding binding = ASTResolving.guessBindingForTypeReference((ASTNode)node);
        if (binding != null) {
            if (binding.isArray()) {
                binding = binding.getElementType();
            }
            resolvedTypeName = Bindings.getFullyQualifiedName(binding);
            proposals.add(UnresolvedElementsSubProcessor.createTypeRefChangeProposal(cu, resolvedTypeName, node, relevance + 2));
        }
        int i = 0;
        while (i < elements.length) {
            String fullName;
            SimilarElement elem = elements[i];
            if ((elem.getKind() & 0xE) != 0 && !(fullName = elem.getName()).equals(resolvedTypeName)) {
                proposals.add(UnresolvedElementsSubProcessor.createTypeRefChangeProposal(cu, fullName, node, relevance));
            }
            ++i;
        }
    }

    private static CUCorrectionProposal createTypeRefChangeProposal(ICompilationUnit cu, String fullName, Name node, int relevance) throws JavaModelException {
        CUCorrectionProposal proposal = new CUCorrectionProposal("", cu, 0);
        ImportEdit importEdit = new ImportEdit(cu, JavaPreferencesSettings.getCodeGenerationSettings());
        String simpleName = importEdit.addImport(fullName);
        TextEdit root = proposal.getRootTextEdit();
        if (!importEdit.isEmpty()) {
            root.add(importEdit);
        }
        if (node.isSimpleName() && simpleName.equals(((SimpleName)node).getIdentifier())) {
            proposal.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.imp_obj.gif"));
            proposal.setDisplayName(CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.importtype.description", fullName));
            proposal.setRelevance(relevance + 20);
        } else {
            root.add(SimpleTextEdit.createReplace(node.getStartPosition(), node.getLength(), simpleName));
            proposal.setDisplayName(CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.changetype.description", simpleName));
            proposal.setRelevance(relevance);
        }
        return proposal;
    }

    private static void addNewTypeProposals(ICompilationUnit cu, Name refNode, int kind, int relevance, List proposals) throws JavaModelException {
        Name qualifier;
        Name node = refNode;
        do {
            boolean isPossibleName;
            String typeName = ASTResolving.getSimpleName(node);
            qualifier = null;
            boolean bl = isPossibleName = Character.isUpperCase(typeName.charAt(0)) || node == refNode;
            if (!isPossibleName) continue;
            IPackageFragment enclosingPackage = null;
            IType enclosingType = null;
            if (node.isSimpleName()) {
                enclosingPackage = (IPackageFragment)cu.getParent();
            } else {
                Name qualifierName = ((QualifiedName)node).getQualifier();
                IJavaElement[] res = cu.codeSelect(qualifierName.getStartPosition(), qualifierName.getLength());
                if (res != null && res.length > 0 && res[0] instanceof IType) {
                    enclosingType = (IType)res[0];
                } else {
                    qualifier = qualifierName;
                    enclosingPackage = JavaModelUtil.getPackageFragmentRoot((IJavaElement)cu).getPackageFragment(ASTResolving.getFullName(qualifierName));
                }
            }
            if (enclosingPackage != null && !enclosingPackage.getCompilationUnit(String.valueOf(typeName) + ".java").exists()) {
                if ((kind & 2) != 0) {
                    proposals.add(new NewCUCompletionUsingWizardProposal(cu, node, true, (IJavaElement)enclosingPackage, relevance));
                }
                if ((kind & 4) != 0) {
                    proposals.add(new NewCUCompletionUsingWizardProposal(cu, node, false, (IJavaElement)enclosingPackage, relevance));
                }
            }
            if (enclosingType == null || enclosingType.isReadOnly() || enclosingType.getType(typeName).exists()) continue;
            if ((kind & 2) != 0) {
                proposals.add(new NewCUCompletionUsingWizardProposal(cu, node, true, (IJavaElement)enclosingType, relevance));
            }
            if ((kind & 4) == 0) continue;
            proposals.add(new NewCUCompletionUsingWizardProposal(cu, node, false, (IJavaElement)enclosingType, relevance));
        } while ((node = qualifier) != null);
    }

    public static void getMethodProposals(ICorrectionContext context, boolean needsNewName, List proposals) throws CoreException {
        ICompilationUnit targetCU;
        String label;
        boolean isSuperInvocation;
        Expression sender;
        List arguments;
        MethodInvocation methodImpl;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = context.getCoveringNode();
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        SimpleName nameNode = (SimpleName)selectedNode;
        ASTNode invocationNode = nameNode.getParent();
        if (invocationNode instanceof MethodInvocation) {
            methodImpl = (MethodInvocation)invocationNode;
            arguments = methodImpl.arguments();
            sender = methodImpl.getExpression();
            isSuperInvocation = false;
        } else if (invocationNode instanceof SuperMethodInvocation) {
            methodImpl = (SuperMethodInvocation)invocationNode;
            arguments = methodImpl.arguments();
            sender = methodImpl.getQualifier();
            isSuperInvocation = true;
        } else {
            return;
        }
        String methodName = nameNode.getIdentifier();
        SimilarElement[] elements = SimilarElementsRequestor.findSimilarElement(cu, (Name)nameNode, 32);
        ArrayList<SimilarElement> parameterMismatchs = new ArrayList<SimilarElement>();
        int i = 0;
        while (i < elements.length) {
            String curr = elements[i].getName();
            if (curr.equals(methodName) && needsNewName) {
                parameterMismatchs.add(elements[i]);
            } else {
                label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.changemethod.description", curr);
                proposals.add(new ReplaceCorrectionProposal(label, context.getCompilationUnit(), context.getOffset(), context.getLength(), curr, 2));
            }
            ++i;
        }
        UnresolvedElementsSubProcessor.addParameterMissmatchProposals(context, parameterMismatchs, arguments, proposals);
        ITypeBinding binding = null;
        if (sender != null) {
            binding = sender.resolveTypeBinding();
        } else {
            binding = ASTResolving.getBindingOfParentType(invocationNode);
            if (isSuperInvocation && binding != null) {
                binding = binding.getSuperclass();
            }
        }
        if (binding != null && binding.isFromSource() && (targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, binding)) != null) {
            ASTNode anonymDecl;
            Image image;
            if (cu.equals(targetCU)) {
                label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createmethod.description", methodName);
                image = JavaPluginImages.get("org.eclipse.jdt.ui.methpri_obj.gif");
            } else {
                label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createmethod.other.description", new Object[]{methodName, targetCU.getElementName()});
                image = JavaPluginImages.get("org.eclipse.jdt.ui.methpub_obj.gif");
            }
            proposals.add(new NewMethodCompletionProposal(label, targetCU, invocationNode, arguments, binding, 1, image));
            if (binding.isAnonymous() && cu.equals(targetCU) && (anonymDecl = astRoot.findDeclaringNode((IBinding)binding)) != null && !(binding = ASTResolving.getBindingOfParentType(anonymDecl.getParent())).isAnonymous()) {
                Object[] args = new String[]{methodName, binding.getName()};
                label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createmethod.other.description", args);
                image = JavaPluginImages.get("org.eclipse.jdt.ui.methpro_obj.gif");
                proposals.add(new NewMethodCompletionProposal(label, targetCU, invocationNode, arguments, binding, 1, image));
            }
        }
    }

    private static void addParameterMissmatchProposals(ICorrectionContext context, List similarElements, List arguments, List proposals) throws CoreException {
        ITypeBinding[] argTypes = UnresolvedElementsSubProcessor.getArgumentTypes(arguments);
        if (argTypes == null) {
            return;
        }
        int i = 0;
        while (i < similarElements.size()) {
            SimilarElement elem = (SimilarElement)similarElements.get(i);
            String[] paramTypes = elem.getParameterTypes();
            if (paramTypes != null && paramTypes.length == argTypes.length) {
                int idx2;
                int idx1;
                int nProposals = proposals.size();
                int[] indexOfDiff = new int[paramTypes.length];
                int nDiffs = 0;
                int n = 0;
                while (n < argTypes.length) {
                    if (!ASTResolving.canAssign(argTypes[n], paramTypes[n])) {
                        indexOfDiff[nDiffs++] = n;
                    }
                    ++n;
                }
                int k = 0;
                while (k < nDiffs) {
                    ASTRewriteCorrectionProposal proposal;
                    int idx = indexOfDiff[k];
                    Expression nodeToCast = (Expression)arguments.get(idx);
                    String castType = paramTypes[idx];
                    if (nodeToCast.getNodeType() != 11 && (proposal = LocalCorrectionsSubProcessor.getCastProposal(context, castType, nodeToCast)) != null) {
                        proposals.add(proposal);
                        proposal.setDisplayName(CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.addparametercast.description", castType));
                    }
                    ++k;
                }
                if (nDiffs == 2 && ASTResolving.canAssign(argTypes[idx1 = indexOfDiff[0]], paramTypes[idx2 = indexOfDiff[1]]) && ASTResolving.canAssign(argTypes[idx2], paramTypes[idx1])) {
                    Expression arg1 = (Expression)arguments.get(idx1);
                    Expression arg2 = (Expression)arguments.get(idx2);
                    ASTRewrite rewrite = new ASTRewrite(arg1.getParent());
                    rewrite.markAsReplaced((ASTNode)arg1, rewrite.createCopy((ASTNode)arg2));
                    rewrite.markAsReplaced((ASTNode)arg2, rewrite.createCopy((ASTNode)arg1));
                    String label = CorrectionMessages.getString("UnresolvedElementsSubProcessor.swapparameters.description");
                    Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                    ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 8, image);
                    proposal.ensureNoModifications();
                    proposals.add(proposal);
                }
                if (nProposals != proposals.size()) {
                    return;
                }
            }
            ++i;
        }
    }

    private static ITypeBinding[] getArgumentTypes(List arguments) {
        ITypeBinding[] res = new ITypeBinding[arguments.size()];
        int i = 0;
        while (i < res.length) {
            Expression expression = (Expression)arguments.get(i);
            ITypeBinding curr = expression.resolveTypeBinding();
            if (curr == null) {
                return null;
            }
            if ((curr = ASTResolving.normalizeTypeBinding(curr)) == null) {
                curr = expression.getAST().resolveWellKnownType("java.lang.Object");
            }
            res[i] = curr;
            ++i;
        }
        return res;
    }

    public static void getConstructorProposals(ICorrectionContext context, List proposals) throws CoreException {
        ICompilationUnit targetCU;
        ITypeBinding typeBinding;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = context.getCoveringNode();
        if (selectedNode == null) {
            return;
        }
        ITypeBinding targetBinding = null;
        List arguments = null;
        int type = selectedNode.getNodeType();
        if (type == 14) {
            ClassInstanceCreation creation = (ClassInstanceCreation)selectedNode;
            IBinding binding = creation.getName().resolveBinding();
            if (binding instanceof ITypeBinding) {
                targetBinding = (ITypeBinding)binding;
                arguments = creation.arguments();
            }
        } else if (type == 46) {
            typeBinding = ASTResolving.getBindingOfParentType(selectedNode);
            if (typeBinding != null && !typeBinding.isAnonymous()) {
                targetBinding = typeBinding.getSuperclass();
                arguments = ((SuperConstructorInvocation)selectedNode).arguments();
            }
        } else if (type == 17 && (typeBinding = ASTResolving.getBindingOfParentType(selectedNode)) != null && !typeBinding.isAnonymous()) {
            targetBinding = typeBinding;
            arguments = ((ConstructorInvocation)selectedNode).arguments();
        }
        if (targetBinding != null && targetBinding.isFromSource() && (targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, targetBinding)) != null) {
            String label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.createconstructor.description", targetBinding.getName());
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.methpub_obj.gif");
            proposals.add(new NewMethodCompletionProposal(label, targetCU, selectedNode, arguments, targetBinding, 1, image));
        }
    }

    public static void getAmbiguosTypeReferenceProposals(ICorrectionContext context, List proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        int offset = context.getOffset();
        int len = context.getLength();
        IJavaElement[] elements = cu.codeSelect(offset, len);
        int i = 0;
        while (i < elements.length) {
            IJavaElement curr = elements[i];
            if (curr instanceof IType) {
                String qualifiedTypeName = JavaModelUtil.getFullyQualifiedName((IType)curr);
                String label = CorrectionMessages.getFormattedString("UnresolvedElementsSubProcessor.importexplicit.description", qualifiedTypeName);
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.imp_obj.gif");
                CUCorrectionProposal proposal = new CUCorrectionProposal(label, cu, 1, image);
                ImportEdit importEdit = new ImportEdit(cu, JavaPreferencesSettings.getCodeGenerationSettings());
                importEdit.addImport(qualifiedTypeName);
                importEdit.setFindAmbiguosImports(true);
                proposal.getRootTextEdit().add(importEdit);
                proposals.add(proposal);
            }
            ++i;
        }
    }
}

