/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.AbstractCollection;
import java.util.HashSet;
import org.eclipse.jdt.core.CompletionRequestorAdapter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.NameMatcher;
import org.eclipse.jdt.internal.ui.text.correction.SimilarElement;

public class SimilarElementsRequestor
extends CompletionRequestorAdapter {
    public static final int CLASSES = 2;
    public static final int INTERFACES = 4;
    public static final int PRIMITIVETYPES = 8;
    public static final int VOIDTYPE = 16;
    public static final int REF_TYPES = 6;
    public static final int ALL_TYPES = 14;
    public static final int METHODS = 32;
    public static final int FIELDS = 64;
    public static final int LOCALS = 128;
    public static final int VARIABLES = 192;
    private static final String[] PRIM_TYPES = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    private String fPreferredType;
    private int fNumberOfArguments;
    private int fKind;
    private String fName;
    private HashSet fResult;
    private HashSet fOthers;

    public static SimilarElement[] findSimilarElement(ICompilationUnit cu, Name name, int kind) throws JavaModelException {
        int pos = name.getStartPosition();
        int nArguments = -1;
        String identifier = ASTResolving.getSimpleName(name);
        String returnType = null;
        if ((kind & 6) != 0) {
            pos = name.isQualifiedName() ? ((QualifiedName)name).getName().getStartPosition() : name.getStartPosition() + 1;
        } else {
            ITypeBinding binding;
            if (name.getParent().getNodeType() == 32) {
                MethodInvocation invocation = (MethodInvocation)name.getParent();
                if (name.equals((Object)invocation.getName())) {
                    if ((kind & 0x20) != 0) {
                        nArguments = invocation.arguments().size();
                    }
                } else if (invocation.arguments().contains(name)) {
                    pos = invocation.getStartPosition();
                }
            }
            if ((binding = ASTResolving.guessBindingForReference((ASTNode)name)) != null) {
                returnType = binding.getName();
            }
        }
        SimilarElementsRequestor requestor = new SimilarElementsRequestor(identifier, kind, nArguments, returnType);
        return requestor.process(cu, pos);
    }

    private SimilarElementsRequestor(String name, int kind, int nArguments, String preferredType) {
        this.fName = name;
        this.fKind = kind;
        this.fNumberOfArguments = nArguments;
        this.fPreferredType = preferredType;
        this.fResult = new HashSet();
        this.fOthers = new HashSet();
    }

    private void addResult(SimilarElement elem) {
        this.fResult.add(elem);
    }

    private SimilarElement[] process(ICompilationUnit cu, int pos) throws JavaModelException {
        try {
            cu.codeComplete(pos, (ICompletionRequestor)this);
            this.processKeywords();
            if (this.fResult.size() == 0 && this.fOthers.size() < 6) {
                this.fResult = this.fOthers;
            }
            SimilarElement[] similarElementArray = ((AbstractCollection)this.fResult).toArray(new SimilarElement[this.fResult.size()]);
            Object var3_4 = null;
            this.fResult.clear();
            this.fOthers.clear();
            return similarElementArray;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.fResult.clear();
            this.fOthers.clear();
            throw throwable;
        }
    }

    private void processKeywords() {
        String voidType;
        if ((this.fKind & 8) != 0) {
            int i = 0;
            while (i < PRIM_TYPES.length) {
                if (NameMatcher.isSimilarName(this.fName, PRIM_TYPES[i])) {
                    this.addResult(new SimilarElement(8, PRIM_TYPES[i], 50));
                }
                ++i;
            }
        }
        if ((this.fKind & 0x10) != 0 && NameMatcher.isSimilarName(this.fName, voidType = "void")) {
            this.addResult(new SimilarElement(8, voidType, 50));
        }
    }

    private void addType(int kind, char[] packageName, char[] typeName, char[] completionName, int relevance) {
        StringBuffer buf = new StringBuffer();
        if (packageName.length > 0) {
            buf.append(packageName);
            buf.append('.');
        }
        buf.append(typeName);
        SimilarElement elem = new SimilarElement(kind, buf.toString(), relevance);
        if (NameMatcher.isSimilarName(this.fName, new String(typeName))) {
            this.addResult(elem);
        }
    }

    private void addVariable(int kind, char[] name, char[] typePackageName, char[] typeName, int relevance) {
        String variableName = new String(name);
        if (NameMatcher.isSimilarName(this.fName, variableName)) {
            this.addResult(new SimilarElement(kind, variableName, 1));
        } else if (this.fPreferredType != null && this.fPreferredType.equals(JavaModelUtil.concatenateName(typePackageName, typeName))) {
            this.addResult(new SimilarElement(kind, variableName, 0));
        }
    }

    public void acceptClass(char[] packageName, char[] className, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if ((this.fKind & 2) != 0) {
            this.addType(2, packageName, className, completionName, relevance);
        }
    }

    public void acceptInterface(char[] packageName, char[] interfaceName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if ((this.fKind & 4) != 0) {
            this.addType(4, packageName, interfaceName, completionName, relevance);
        }
    }

    public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] name, char[] typePackageName, char[] typeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if ((this.fKind & 0x40) != 0) {
            this.addVariable(64, name, typePackageName, typeName, relevance);
        }
    }

    public void acceptLocalVariable(char[] name, char[] typePackageName, char[] typeName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if ((this.fKind & 0xC0) != 0) {
            this.addVariable(192, name, typePackageName, typeName, relevance);
        }
    }

    public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if ((this.fKind & 0x20) != 0) {
            int similarity;
            String methodName = new String(selector);
            if (this.fName.equals(methodName)) {
                String[] paramTypes = new String[parameterTypeNames.length];
                int i = 0;
                while (i < paramTypes.length) {
                    paramTypes[i] = JavaModelUtil.concatenateName(parameterPackageNames[i], parameterTypeNames[i]);
                    ++i;
                }
                this.addResult(new SimilarElement(32, methodName, paramTypes, relevance));
            } else if ((this.fNumberOfArguments == -1 || this.fNumberOfArguments == parameterTypeNames.length) && (similarity = NameMatcher.getSimilarity(this.fName, methodName)) >= 0) {
                SimilarElement elem = new SimilarElement(32, methodName, null, relevance + similarity);
                this.addResult(elem);
            }
        }
    }
}

