/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.ICorrectionContext;
import org.eclipse.jdt.internal.ui.text.correction.ReplaceCorrectionProposal;
import org.eclipse.swt.graphics.Image;

public class ReturnTypeSubProcessor {
    public static void addMethodWithConstrNameProposals(ICorrectionContext context, List proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = context.getCoveringNode();
        if (selectedNode instanceof MethodDeclaration) {
            MethodDeclaration declaration = (MethodDeclaration)selectedNode;
            ASTRewrite rewrite = new ASTRewrite((ASTNode)declaration);
            rewrite.markAsRemoved((ASTNode)declaration.getReturnType());
            String label = CorrectionMessages.getString("ReturnTypeSubProcessor.constrnamemethod.description");
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 1, image);
            proposal.ensureNoModifications();
            proposals.add(proposal);
        }
    }

    public static void addVoidMethodReturnsProposals(ICorrectionContext context, List proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = context.getCoveringNode();
        if (selectedNode == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof MethodDeclaration && selectedNode.getNodeType() == 41) {
            ReturnStatement returnStatement = (ReturnStatement)selectedNode;
            Expression expr = returnStatement.getExpression();
            if (expr != null) {
                ITypeBinding binding = ASTResolving.normalizeTypeBinding(expr.resolveTypeBinding());
                if (binding == null) {
                    binding = selectedNode.getAST().resolveWellKnownType("java.lang.Object");
                }
                MethodDeclaration methodDeclaration = (MethodDeclaration)decl;
                ASTRewrite rewrite = new ASTRewrite((ASTNode)methodDeclaration);
                Type newReturnType = ASTResolving.getTypeFromTypeBinding(astRoot.getAST(), binding);
                if (methodDeclaration.isConstructor()) {
                    MethodDeclaration modifiedNode = astRoot.getAST().newMethodDeclaration();
                    modifiedNode.setModifiers(methodDeclaration.getModifiers());
                    modifiedNode.setExtraDimensions(methodDeclaration.getExtraDimensions());
                    modifiedNode.setConstructor(false);
                    rewrite.markAsModified((ASTNode)methodDeclaration, (ASTNode)modifiedNode);
                    methodDeclaration.setReturnType(newReturnType);
                    rewrite.markAsInserted((ASTNode)newReturnType);
                } else {
                    rewrite.markAsReplaced((ASTNode)methodDeclaration.getReturnType(), (ASTNode)newReturnType);
                }
                String label = CorrectionMessages.getFormattedString("ReturnTypeSubProcessor.voidmethodreturns.description", binding.getName());
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 2, image);
                proposal.addImport(binding);
                proposal.ensureNoModifications();
                proposals.add(proposal);
            }
            ASTRewrite rewrite = new ASTRewrite((ASTNode)decl);
            rewrite.markAsRemoved((ASTNode)returnStatement);
            String label = CorrectionMessages.getString("ReturnTypeSubProcessor.removereturn.description");
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 1, image);
            proposal.ensureNoModifications();
            proposals.add(proposal);
        }
    }

    public static void addMissingReturnTypeProposals(ICorrectionContext context, List proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = context.getCoveringNode();
        if (selectedNode == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof MethodDeclaration) {
            String typeName;
            Type type;
            MethodDeclaration methodDeclaration = (MethodDeclaration)decl;
            ReturnStatementCollector eval = new ReturnStatementCollector();
            decl.accept((ASTVisitor)eval);
            ITypeBinding typeBinding = eval.getTypeBinding(decl.getAST());
            ASTRewrite rewrite = new ASTRewrite((ASTNode)methodDeclaration);
            AST ast = astRoot.getAST();
            if (typeBinding != null) {
                type = ASTResolving.getTypeFromTypeBinding(ast, typeBinding);
                typeName = typeBinding.getName();
            } else {
                type = ast.newPrimitiveType(PrimitiveType.VOID);
                typeName = "void";
            }
            String label = CorrectionMessages.getFormattedString("ReturnTypeSubProcessor.missingreturntype.description", typeName);
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 2, image);
            if (typeBinding != null) {
                proposal.addImport(typeBinding);
            }
            rewrite.markAsInserted((ASTNode)type);
            methodDeclaration.setReturnType(type);
            MethodDeclaration modifiedNode = ast.newMethodDeclaration();
            modifiedNode.setModifiers(methodDeclaration.getModifiers());
            modifiedNode.setExtraDimensions(methodDeclaration.getExtraDimensions());
            modifiedNode.setConstructor(false);
            rewrite.markAsModified((ASTNode)methodDeclaration, (ASTNode)modifiedNode);
            proposal.ensureNoModifications();
            proposals.add(proposal);
            ASTNode parentType = ASTResolving.findParentType((ASTNode)decl);
            if (parentType instanceof TypeDeclaration) {
                String constructorName = ((TypeDeclaration)parentType).getName().getIdentifier();
                SimpleName nameNode = methodDeclaration.getName();
                label = CorrectionMessages.getFormattedString("ReturnTypeSubProcessor.wrongconstructorname.description", constructorName);
                proposals.add(new ReplaceCorrectionProposal(label, cu, nameNode.getStartPosition(), nameNode.getLength(), constructorName, 1));
            }
        }
    }

    public static void addMissingReturnStatementProposals(ICorrectionContext context, List proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = context.getCoveringNode();
        if (selectedNode == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof MethodDeclaration) {
            MethodDeclaration methodDecl = (MethodDeclaration)decl;
            if (selectedNode instanceof ReturnStatement) {
                ReturnStatement returnStatement = (ReturnStatement)selectedNode;
                if (returnStatement.getExpression() == null) {
                    ASTRewrite rewrite = new ASTRewrite((ASTNode)methodDecl);
                    Expression expression = ASTResolving.getInitExpression(methodDecl.getReturnType(), methodDecl.getExtraDimensions());
                    if (expression != null) {
                        returnStatement.setExpression(expression);
                        rewrite.markAsInserted((ASTNode)expression);
                    }
                    Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                    String label = CorrectionMessages.getString("ReturnTypeSubProcessor.changereturnstatement.description");
                    ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 3, image);
                    proposal.ensureNoModifications();
                    proposals.add(proposal);
                }
            } else {
                Block block = methodDecl.getBody();
                if (block == null) {
                    return;
                }
                AST ast = methodDecl.getAST();
                ASTRewrite rewrite = new ASTRewrite((ASTNode)methodDecl);
                List statements = block.statements();
                ReturnStatement returnStatement = ast.newReturnStatement();
                returnStatement.setExpression(ASTResolving.getInitExpression(methodDecl.getReturnType(), methodDecl.getExtraDimensions()));
                statements.add(returnStatement);
                rewrite.markAsInserted((ASTNode)returnStatement);
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                String label = CorrectionMessages.getString("ReturnTypeSubProcessor.addreturnstatement.description");
                ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 3, image);
                proposal.ensureNoModifications();
                proposals.add(proposal);
            }
        }
    }

    private static class ReturnStatementCollector
    extends ASTVisitor {
        private ArrayList fResult = new ArrayList();

        ReturnStatementCollector() {
        }

        public Iterator returnStatements() {
            return ((AbstractList)this.fResult).iterator();
        }

        public ITypeBinding getTypeBinding(AST ast) {
            boolean couldBeObject = false;
            int i = 0;
            while (i < this.fResult.size()) {
                ReturnStatement node = (ReturnStatement)this.fResult.get(i);
                Expression expr = node.getExpression();
                if (expr != null) {
                    ITypeBinding binding = ASTResolving.normalizeTypeBinding(expr.resolveTypeBinding());
                    if (binding != null) {
                        return binding;
                    }
                } else {
                    return ast.resolveWellKnownType("void");
                }
                couldBeObject = true;
                ++i;
            }
            if (couldBeObject) {
                return ast.resolveWellKnownType("java.lang.Object");
            }
            return ast.resolveWellKnownType("void");
        }

        public boolean visit(ReturnStatement node) {
            this.fResult.add(node);
            return false;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public boolean visit(TypeDeclaration node) {
            return false;
        }
    }
}

