/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreatePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectMainTypeNameProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectPackageDeclarationProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.ICorrectionContext;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;

public class ReorgCorrectionsSubProcessor {
    public static void getWrongTypeNameProposals(ICorrectionContext context, List proposals) throws CoreException {
        String[] args = context.getProblemArguments();
        if (args.length == 2) {
            ICompilationUnit cu = context.getCompilationUnit();
            boolean isLinked = JavaModelUtil.toOriginal(cu).getResource().isLinked();
            proposals.add(new CorrectMainTypeNameProposal(cu, args[1], 1));
            String newCUName = String.valueOf(args[1]) + ".java";
            ICompilationUnit newCU = ((IPackageFragment)cu.getParent()).getCompilationUnit(newCUName);
            if (!newCU.exists() && !isLinked) {
                RenameCompilationUnitChange change = new RenameCompilationUnitChange(cu, newCUName);
                String label = CorrectionMessages.getFormattedString("ReorgCorrectionsSubProcessor.renamecu.description", newCUName);
                proposals.add(new ChangeCorrectionProposal(label, change, 2, JavaPluginImages.get("org.eclipse.jdt.ui.correction_rename.gif")));
            }
        }
    }

    public static void getWrongPackageDeclNameProposals(ICorrectionContext context, List proposals) throws CoreException {
        String[] args = context.getProblemArguments();
        if (args.length == 1) {
            ICompilationUnit cu = context.getCompilationUnit();
            boolean isLinked = JavaModelUtil.toOriginal(cu).getResource().isLinked();
            proposals.add(new CorrectPackageDeclarationProposal(context, 1));
            IPackageDeclaration[] packDecls = cu.getPackageDeclarations();
            String newPackName = packDecls.length > 0 ? packDecls[0].getElementName() : "";
            IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot((IJavaElement)cu);
            IPackageFragment newPack = root.getPackageFragment(newPackName);
            ICompilationUnit newCU = newPack.getCompilationUnit(cu.getElementName());
            if (!newCU.exists() && !isLinked) {
                String label = newPack.isDefaultPackage() ? CorrectionMessages.getFormattedString("ReorgCorrectionsSubProcessor.movecu.default.description", cu.getElementName()) : CorrectionMessages.getFormattedString("ReorgCorrectionsSubProcessor.movecu.description", new Object[]{cu.getElementName(), newPack.getElementName()});
                CompositeChange composite = new CompositeChange(label);
                composite.add(new CreatePackageChange(newPack));
                composite.add(new MoveCompilationUnitChange(cu, newPack));
                proposals.add(new ChangeCorrectionProposal(label, composite, 2, JavaPluginImages.get("org.eclipse.jdt.ui.correction_move.gif")));
            }
        }
    }

    public static void removeImportStatementProposals(ICorrectionContext context, List proposals) throws CoreException {
        ASTNode node;
        final ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = context.getCoveringNode();
        if (selectedNode != null && (node = ASTNodes.getParent(selectedNode, 26)) instanceof ImportDeclaration) {
            ASTRewrite rewrite = new ASTRewrite(node.getParent());
            rewrite.markAsRemoved(node);
            String label = CorrectionMessages.getString("ReorgCorrectionsSubProcessor.unusedimport.description");
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_delete_import.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 1, image);
            proposal.ensureNoModifications();
            proposals.add(proposal);
        }
        String name = CorrectionMessages.getString("ReorgCorrectionsSubProcessor.organizeimports.description");
        ChangeCorrectionProposal proposal = new ChangeCorrectionProposal(name, null, 0){

            public void apply(IDocument document) {
                FileEditorInput input = new FileEditorInput((IFile)JavaModelUtil.toOriginal(cu).getResource());
                IWorkbenchPage p = JavaPlugin.getActivePage();
                if (p == null) {
                    return;
                }
                IEditorPart part = p.findEditor((IEditorInput)input);
                if (part instanceof JavaEditor) {
                    OrganizeImportsAction action = new OrganizeImportsAction((JavaEditor)part);
                    action.run(cu);
                }
            }
        };
        proposals.add(proposal);
    }
}

