/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.template.ContextType;
import org.eclipse.jdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.jdt.internal.corext.template.Template;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComparator;
import org.eclipse.jdt.internal.ui.text.template.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.TemplateProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Point;

public class QuickTemplateProcessor {
    private JavaCompletionProposalComparator fComparator;
    private TemplateEngine fTemplateEngine;

    public QuickTemplateProcessor() {
        ContextType contextType = ContextTypeRegistry.getInstance().getContextType("java");
        if (contextType != null) {
            this.fTemplateEngine = new TemplateEngine(contextType);
        }
        this.fComparator = new JavaCompletionProposalComparator();
    }

    public void computeCompletionProposals(ITextViewer viewer, ICompilationUnit unit, List result) {
        Point s = viewer.getSelectedRange();
        int offset = s.x;
        int length = s.y;
        if (this.fTemplateEngine != null && length > 0 && this.areMultipleLinesSelected(viewer, offset, length)) {
            try {
                this.fTemplateEngine.reset();
                this.fTemplateEngine.complete(viewer, offset, unit);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            TemplateProposal[] templateResults = this.fTemplateEngine.getResults();
            Arrays.sort(templateResults, this.fComparator);
            int i = 0;
            while (i < templateResults.length) {
                TemplateProposal proposal = templateResults[i];
                Template template = proposal.getTemplate();
                Object[] arg = new String[]{template.getName(), template.getDescription()};
                proposal.setDisplayString(CorrectionMessages.getFormattedString("QuickTemplateProcessor.surround.label", arg));
                result.add(proposal);
                ++i;
            }
        }
    }

    private boolean areMultipleLinesSelected(ITextViewer viewer, int offset, int length) {
        try {
            IDocument document = viewer.getDocument();
            int startLine = document.getLineOfOffset(offset);
            int endLine = document.getLineOfOffset(offset + length);
            IRegion line = document.getLineInformation(startLine);
            return startLine != endLine || offset == line.getOffset() && length == line.getLength();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

