/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.AssignToVariableAssistProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.ICorrectionContext;
import org.eclipse.jdt.internal.ui.text.correction.ICorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.correction.LinkedNamesAssistProposal;
import org.eclipse.swt.graphics.Image;

public class QuickAssistProcessor
implements ICorrectionProcessor {
    public void process(ICorrectionContext context, List resultingCollections) throws CoreException {
        int id = context.getProblemId();
        if (id != 0) {
            return;
        }
        this.getAssignToVariableProposals(context, resultingCollections);
        this.getCatchClauseToThrowsProposals(context, resultingCollections);
        this.getRenameLocalProposals(context, resultingCollections);
        this.getUnWrapProposals(context, resultingCollections);
    }

    private void getAssignToVariableProposals(ICorrectionContext context, List resultingCollections) throws CoreException {
        ASTNode node = context.getCoveringNode();
        Statement statement = ASTResolving.findParentStatement(node);
        if (!(statement instanceof ExpressionStatement)) {
            return;
        }
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        Expression expression = expressionStatement.getExpression();
        if (expression.getNodeType() == 7) {
            return;
        }
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        if ((typeBinding = ASTResolving.normalizeTypeBinding(typeBinding)) == null) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        AssignToVariableAssistProposal localProposal = new AssignToVariableAssistProposal(cu, 1, expressionStatement, typeBinding, 2);
        resultingCollections.add(localProposal);
        ASTNode type = ASTResolving.findParentType((ASTNode)expression);
        if (type != null) {
            AssignToVariableAssistProposal fieldProposal = new AssignToVariableAssistProposal(cu, 2, expressionStatement, typeBinding, 1);
            resultingCollections.add(fieldProposal);
        }
    }

    private void getCatchClauseToThrowsProposals(ICorrectionContext context, List resultingCollections) throws CoreException {
        ASTNode node = context.getCoveringNode();
        CatchClause catchClause = (CatchClause)ASTResolving.findAncestor(node, 12);
        if (catchClause == null) {
            return;
        }
        Type type = catchClause.getException().getType();
        if (!type.isSimpleType()) {
            return;
        }
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)catchClause);
        if (!(bodyDeclaration instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
        ASTRewrite rewrite = new ASTRewrite((ASTNode)methodDeclaration);
        AST ast = methodDeclaration.getAST();
        TryStatement tryStatement = (TryStatement)catchClause.getParent();
        if (tryStatement.catchClauses().size() > 1 || tryStatement.getFinally() != null) {
            rewrite.markAsRemoved((ASTNode)catchClause);
        } else {
            List statements = tryStatement.getBody().statements();
            if (statements.size() > 0) {
                ASTNode placeholder = rewrite.createCopy((ASTNode)statements.get(0), (ASTNode)statements.get(statements.size() - 1));
                rewrite.markAsReplaced((ASTNode)tryStatement, placeholder);
            } else {
                rewrite.markAsRemoved((ASTNode)tryStatement);
            }
        }
        ITypeBinding binding = type.resolveBinding();
        if (binding == null || this.isNotYetThrown(binding, methodDeclaration.thrownExceptions())) {
            Name name = ((SimpleType)type).getName();
            Name newName = (Name)ASTNode.copySubtree((AST)ast, (ASTNode)name);
            rewrite.markAsInserted((ASTNode)newName);
            methodDeclaration.thrownExceptions().add(newName);
        }
        String label = CorrectionMessages.getString("QuickAssistProcessor.catchclausetothrows.description");
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.jexception_obj.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        proposal.ensureNoModifications();
        resultingCollections.add(proposal);
    }

    private boolean isNotYetThrown(ITypeBinding binding, List thrownExcpetions) {
        int i = 0;
        while (i < thrownExcpetions.size()) {
            Name name = (Name)thrownExcpetions.get(i);
            ITypeBinding elem = (ITypeBinding)name.resolveBinding();
            if (elem != null && Bindings.findTypeInHierarchy(binding, elem)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void getRenameLocalProposals(ICorrectionContext context, List resultingCollections) throws CoreException {
        ASTNode node = context.getCoveringNode();
        if (!(node instanceof SimpleName)) {
            return;
        }
        SimpleName name = (SimpleName)node;
        IBinding binding = name.resolveBinding();
        if (binding == null || binding.getKind() == 1) {
            return;
        }
        LinkedNamesAssistProposal proposal = new LinkedNamesAssistProposal(name);
        resultingCollections.add(proposal);
    }

    private ASTNode getCopyOfInner(ASTRewrite rewrite, ASTNode statement) {
        if (statement.getNodeType() == 8) {
            Block block = (Block)statement;
            List innerStatements = block.statements();
            int nStatements = innerStatements.size();
            if (nStatements == 1) {
                return rewrite.createCopy((ASTNode)innerStatements.get(0));
            }
            if (nStatements > 1) {
                return rewrite.createCopy((ASTNode)innerStatements.get(0), (ASTNode)innerStatements.get(nStatements - 1));
            }
            return null;
        }
        return rewrite.createCopy(statement);
    }

    private void getUnWrapProposals(ICorrectionContext context, List resultingCollections) throws CoreException {
        MethodInvocation invocation;
        ASTNode node = context.getCoveringNode();
        if (node == null) {
            return;
        }
        ASTNode outer = node;
        Block block = null;
        if (outer.getNodeType() == 8) {
            block = (Block)outer;
            outer = block.getParent();
        }
        Statement body = null;
        String label = null;
        if (outer instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)outer;
            Statement elseBlock = ifStatement.getElseStatement();
            if (elseBlock == null || elseBlock instanceof Block && ((Block)elseBlock).statements().isEmpty()) {
                body = ifStatement.getThenStatement();
            }
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.ifstatement");
        } else if (outer instanceof WhileStatement) {
            body = ((WhileStatement)outer).getBody();
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.whilestatement");
        } else if (outer instanceof ForStatement) {
            body = ((ForStatement)outer).getBody();
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.forstatement");
        } else if (outer instanceof DoStatement) {
            body = ((DoStatement)outer).getBody();
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.dostatement");
        } else if (outer instanceof TryStatement) {
            TryStatement tryStatement = (TryStatement)outer;
            if (tryStatement.catchClauses().isEmpty()) {
                body = tryStatement.getBody();
            }
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.trystatement");
        } else if (outer instanceof AnonymousClassDeclaration) {
            List decls = ((AnonymousClassDeclaration)outer).bodyDeclarations();
            int i = 0;
            while (i < decls.size()) {
                ASTNode elem = (ASTNode)decls.get(i);
                if (elem instanceof MethodDeclaration) {
                    Block curr = ((MethodDeclaration)elem).getBody();
                    if (curr != null && !curr.statements().isEmpty()) {
                        if (body != null) {
                            return;
                        }
                        body = curr;
                    }
                } else if (elem instanceof TypeDeclaration) {
                    return;
                }
                ++i;
            }
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.anonymous");
            outer = ASTResolving.findParentStatement(outer);
        } else if (outer instanceof Block) {
            body = block;
            outer = block;
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.block");
        } else if (outer instanceof ParenthesizedExpression) {
            ParenthesizedExpression expression = (ParenthesizedExpression)outer;
            body = expression.getExpression();
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.parenthesis");
        } else if (outer instanceof MethodInvocation && (invocation = (MethodInvocation)outer).arguments().size() == 1) {
            int kind;
            body = (ASTNode)invocation.arguments().get(0);
            if (invocation.getParent().getNodeType() == 21 && (kind = body.getNodeType()) != 7 && kind != 38 && kind != 37 && kind != 32 && kind != 48) {
                body = null;
            }
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.methodinvocation");
        }
        if (body == null) {
            return;
        }
        ASTRewrite rewrite = new ASTRewrite(outer.getParent());
        ASTNode inner = this.getCopyOfInner(rewrite, (ASTNode)body);
        if (inner != null) {
            rewrite.markAsReplaced(outer, inner);
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.jexception_obj.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
            proposal.ensureNoModifications();
            resultingCollections.add(proposal);
        }
    }
}

