/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.jdt.internal.corext.refactoring.NullChange;
import org.eclipse.jdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionContext;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;

public class NoCorrectionProposal
extends ChangeCorrectionProposal {
    private CorrectionContext fCorrectionContext;
    private String fMessage;

    public NoCorrectionProposal(CorrectionContext correctionContext, String message) {
        super(CorrectionMessages.getString("NoCorrectionProposal.description"), new NullChange(), 0, null);
        this.fCorrectionContext = correctionContext;
        this.fMessage = message;
    }

    public String getAdditionalProposalInfo() {
        if (this.fCorrectionContext != null) {
            return this.showDebugInfo();
        }
        return null;
    }

    private String showDebugInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("<p><b>");
        buf.append(this.getErrorCode(this.fCorrectionContext.getProblemId()));
        buf.append("</b></p>");
        buf.append("<p>");
        buf.append(this.fMessage);
        buf.append("</p>");
        String[] arg = this.fCorrectionContext.getProblemArguments();
        if (arg != null) {
            int i = 0;
            while (i < arg.length) {
                buf.append("<p>");
                buf.append(arg[i]);
                buf.append("</p>");
                ++i;
            }
        }
        return buf.toString();
    }

    private String getErrorCode(int code) {
        StringBuffer buf = new StringBuffer();
        if ((code & 0x1000000) != 0) {
            buf.append("TypeRelated + ");
        }
        if ((code & 0x2000000) != 0) {
            buf.append("FieldRelated + ");
        }
        if ((code & 0x8000000) != 0) {
            buf.append("ConstructorRelated + ");
        }
        if ((code & 0x4000000) != 0) {
            buf.append("MethodRelated + ");
        }
        if ((code & 0x10000000) != 0) {
            buf.append("ImportRelated + ");
        }
        if ((code & 0x20000000) != 0) {
            buf.append("Internal + ");
        }
        if ((code & 0x40000000) != 0) {
            buf.append("Syntax + ");
        }
        buf.append(code & 0xFFFFFF);
        return buf.toString();
    }
}

