/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.swt.graphics.Image;

public class NewVariableCompletionProposal
extends ASTRewriteCorrectionProposal {
    public static final int LOCAL = 1;
    public static final int FIELD = 2;
    public static final int PARAM = 3;
    private int fVariableKind;
    private SimpleName fOriginalNode;
    private ITypeBinding fSenderBinding;
    private boolean fIsInDifferentCU;

    public NewVariableCompletionProposal(String label, ICompilationUnit cu, int variableKind, SimpleName node, ITypeBinding senderBinding, int relevance, Image image) {
        super(label, cu, null, relevance, image);
        this.fVariableKind = variableKind;
        this.fOriginalNode = node;
        this.fSenderBinding = senderBinding;
        this.fIsInDifferentCU = false;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit cu = ASTResolving.findParentCompilationUnit((ASTNode)this.fOriginalNode);
        if (this.fVariableKind == 3) {
            return this.doAddParam(cu);
        }
        if (this.fVariableKind == 2) {
            return this.doAddField(cu);
        }
        return this.doAddLocal(cu);
    }

    private ASTRewrite doAddParam(CompilationUnit cu) throws CoreException {
        AST ast = cu.getAST();
        SimpleName node = this.fOriginalNode;
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration((ASTNode)node);
        if (decl instanceof MethodDeclaration) {
            ASTRewrite rewrite = new ASTRewrite((ASTNode)decl);
            SingleVariableDeclaration newDecl = ast.newSingleVariableDeclaration();
            newDecl.setType(this.evaluateVariableType(ast));
            newDecl.setName(ast.newSimpleName(node.getIdentifier()));
            rewrite.markAsInserted((ASTNode)newDecl);
            ((MethodDeclaration)decl).parameters().add(newDecl);
            return rewrite;
        }
        return null;
    }

    private ASTRewrite doAddLocal(CompilationUnit cu) throws CoreException {
        AST ast = cu.getAST();
        SimpleName node = this.fOriginalNode;
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration((ASTNode)node);
        if (decl instanceof MethodDeclaration || decl instanceof Initializer) {
            Statement statement;
            ASTRewrite rewrite = new ASTRewrite((ASTNode)decl);
            VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
            VariableDeclarationStatement newDecl = ast.newVariableDeclarationStatement(newDeclFrag);
            Type type = this.evaluateVariableType(ast);
            newDecl.setType(type);
            newDeclFrag.setName(ast.newSimpleName(node.getIdentifier()));
            newDeclFrag.setInitializer(ASTResolving.getInitExpression(type, 0));
            ASTNode parent = node.getParent();
            if (parent.getNodeType() == 7) {
                Assignment assignment = (Assignment)parent;
                if (node.equals((Object)assignment.getLeftHandSide())) {
                    ForStatement forStatement;
                    int parentParentKind = parent.getParent().getNodeType();
                    if (parentParentKind == 21) {
                        Expression placeholder = (Expression)rewrite.createCopy((ASTNode)assignment.getRightHandSide());
                        newDeclFrag.setInitializer(placeholder);
                        rewrite.markAsReplaced(assignment.getParent(), (ASTNode)newDecl);
                        return rewrite;
                    }
                    if (parentParentKind == 24 && (forStatement = (ForStatement)parent.getParent()).initializers().size() == 1 && assignment.equals(forStatement.initializers().get(0))) {
                        VariableDeclarationFragment frag = ast.newVariableDeclarationFragment();
                        VariableDeclarationExpression expression = ast.newVariableDeclarationExpression(frag);
                        frag.setName(ast.newSimpleName(node.getIdentifier()));
                        Expression placeholder = (Expression)rewrite.createCopy((ASTNode)assignment.getRightHandSide());
                        frag.setInitializer(placeholder);
                        expression.setType(this.evaluateVariableType(ast));
                        rewrite.markAsReplaced((ASTNode)assignment, (ASTNode)expression);
                        return rewrite;
                    }
                }
            } else if (parent.getNodeType() == 21) {
                rewrite.markAsReplaced(parent, (ASTNode)newDecl);
                return rewrite;
            }
            if ((statement = ASTResolving.findParentStatement((ASTNode)node)) != null && statement.getParent() instanceof Block) {
                Block block = (Block)statement.getParent();
                List statements = block.statements();
                statements.add(0, newDecl);
                rewrite.markAsInserted((ASTNode)newDecl);
                return rewrite;
            }
        }
        return null;
    }

    private ASTRewrite doAddField(CompilationUnit astRoot) throws CoreException {
        SimpleName node = this.fOriginalNode;
        ASTNode newTypeDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        if (newTypeDecl == null) {
            astRoot = AST.parseCompilationUnit((ICompilationUnit)this.getCompilationUnit(), (boolean)true);
            newTypeDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
            this.fIsInDifferentCU = true;
        }
        if (newTypeDecl != null) {
            ASTRewrite rewrite = new ASTRewrite(newTypeDecl);
            AST ast = newTypeDecl.getAST();
            VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
            fragment.setName(ast.newSimpleName(node.getIdentifier()));
            Type type = this.evaluateVariableType(ast);
            FieldDeclaration newDecl = ast.newFieldDeclaration(fragment);
            newDecl.setType(type);
            newDecl.setModifiers(this.evaluateFieldModifiers(newTypeDecl));
            if (this.fSenderBinding.isInterface()) {
                fragment.setInitializer(ASTResolving.getInitExpression(type, 0));
            }
            boolean isAnonymous = newTypeDecl.getNodeType() == 1;
            List decls = isAnonymous ? ((AnonymousClassDeclaration)newTypeDecl).bodyDeclarations() : ((TypeDeclaration)newTypeDecl).bodyDeclarations();
            decls.add(this.findInsertIndex(decls, node.getStartPosition()), newDecl);
            if (this.fIsInDifferentCU) {
                rewrite.markAsInserted((ASTNode)newDecl, "select");
            } else {
                rewrite.markAsInserted((ASTNode)newDecl);
            }
            return rewrite;
        }
        return null;
    }

    private int findInsertIndex(List decls, int currPos) {
        int i = 0;
        while (i < decls.size()) {
            ASTNode curr = (ASTNode)decls.get(i);
            if (curr instanceof FieldDeclaration) {
                if (currPos > curr.getStartPosition() + curr.getLength()) {
                    return i;
                }
                return 0;
            }
            ++i;
        }
        return 0;
    }

    private Type evaluateVariableType(AST ast) throws CoreException {
        ITypeBinding binding = ASTResolving.guessBindingForReference((ASTNode)this.fOriginalNode);
        if (binding != null) {
            this.addImport(binding);
            return ASTResolving.getTypeFromTypeBinding(ast, binding);
        }
        return ast.newSimpleType((Name)ast.newSimpleName("Object"));
    }

    private int evaluateFieldModifiers(ASTNode newTypeDecl) {
        if (this.fSenderBinding.isInterface()) {
            FieldDeclaration[] fieldDecls = ((TypeDeclaration)newTypeDecl).getFields();
            if (fieldDecls.length > 0) {
                return fieldDecls[0].getModifiers();
            }
            return 0;
        }
        int modifiers = 0;
        ASTNode node = ASTResolving.findParentType((ASTNode)this.fOriginalNode);
        if (newTypeDecl.equals((Object)node)) {
            modifiers |= 2;
            if (ASTResolving.isInStaticContext((ASTNode)this.fOriginalNode)) {
                modifiers |= 8;
            }
        } else if (node instanceof AnonymousClassDeclaration) {
            modifiers |= 4;
        } else {
            Name qualifier;
            modifiers |= 1;
            ASTNode parent = this.fOriginalNode.getParent();
            if (parent instanceof QualifiedName && (qualifier = ((QualifiedName)parent).getQualifier()).resolveBinding().getKind() == 2) {
                modifiers |= 8;
            }
        }
        return modifiers;
    }

    public int getVariableKind() {
        return this.fVariableKind;
    }
}

