/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.swt.graphics.Image;

public class NewMethodCompletionProposal
extends ASTRewriteCorrectionProposal {
    private ASTNode fNode;
    private List fArguments;
    private ITypeBinding fSenderBinding;
    private boolean fIsInDifferentCU;

    public NewMethodCompletionProposal(String label, ICompilationUnit targetCU, ASTNode invocationNode, List arguments, ITypeBinding binding, int relevance, Image image) {
        super(label, targetCU, null, relevance, image);
        this.fNode = invocationNode;
        this.fArguments = arguments;
        this.fSenderBinding = binding;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit(this.fNode);
        ASTNode typeDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        ASTNode newTypeDecl = null;
        if (typeDecl != null) {
            this.fIsInDifferentCU = false;
            newTypeDecl = typeDecl;
        } else {
            this.fIsInDifferentCU = true;
            CompilationUnit newRoot = AST.parseCompilationUnit((ICompilationUnit)this.getCompilationUnit(), (boolean)true);
            newTypeDecl = newRoot.findDeclaringNode(this.fSenderBinding.getKey());
        }
        if (newTypeDecl != null) {
            ASTRewrite rewrite = new ASTRewrite(newTypeDecl);
            List methods = this.fSenderBinding.isAnonymous() ? ((AnonymousClassDeclaration)newTypeDecl).bodyDeclarations() : ((TypeDeclaration)newTypeDecl).bodyDeclarations();
            MethodDeclaration newStub = this.getStub(rewrite, newTypeDecl);
            if (!this.fIsInDifferentCU) {
                methods.add(this.findInsertIndex(methods, this.fNode.getStartPosition()), newStub);
            } else if (this.isConstructor()) {
                methods.add(0, newStub);
            } else {
                methods.add(newStub);
            }
            if (this.fIsInDifferentCU) {
                rewrite.markAsInserted((ASTNode)newStub, "select");
            } else {
                rewrite.markAsInserted((ASTNode)newStub);
            }
            return rewrite;
        }
        return null;
    }

    private boolean isConstructor() {
        return this.fNode.getNodeType() != 32 && this.fNode.getNodeType() != 48;
    }

    private MethodDeclaration getStub(ASTRewrite rewrite, ASTNode targetTypeDecl) throws CoreException {
        String string;
        AST ast = targetTypeDecl.getAST();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.setConstructor(this.isConstructor());
        decl.setModifiers(this.evaluateModifiers(targetTypeDecl));
        decl.setName(ast.newSimpleName(this.getMethodName()));
        List arguments = this.fArguments;
        List params = decl.parameters();
        int nArguments = arguments.size();
        ArrayList names = new ArrayList(nArguments);
        int i = 0;
        while (i < arguments.size()) {
            Expression elem = (Expression)arguments.get(i);
            SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
            Type type = this.getParameterType(ast, elem);
            param.setType(type);
            param.setName(ast.newSimpleName(this.getParameterName(names, elem, type)));
            params.add(param);
            ++i;
        }
        Block body = null;
        String bodyStatement = "";
        if (!this.isConstructor()) {
            Type returnType = this.evaluateMethodType(ast);
            if (returnType == null) {
                decl.setReturnType((Type)ast.newPrimitiveType(PrimitiveType.VOID));
            } else {
                decl.setReturnType(returnType);
            }
            if (!this.fSenderBinding.isInterface() && returnType != null) {
                ReturnStatement returnStatement = ast.newReturnStatement();
                returnStatement.setExpression(ASTResolving.getInitExpression(returnType, 0));
                bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, String.valueOf('\n'));
            }
        }
        if (!this.fSenderBinding.isInterface()) {
            body = ast.newBlock();
            String placeHolder = CodeGeneration.getMethodBodyContent(this.getCompilationUnit(), this.fSenderBinding.getName(), this.getMethodName(), this.isConstructor(), bodyStatement, String.valueOf('\n'));
            if (placeHolder != null) {
                ASTNode todoNode = rewrite.createPlaceholder(placeHolder, 4);
                body.statements().add(todoNode);
            }
        }
        decl.setBody(body);
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        if (settings.createComments && !this.fSenderBinding.isAnonymous() && (string = CodeGeneration.getMethodComment(this.getCompilationUnit(), this.fSenderBinding.getName(), decl, null, String.valueOf('\n'))) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createPlaceholder(string, 7);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    private String getParameterName(ArrayList takenNames, Expression argNode, Type type) {
        if (argNode instanceof SimpleName) {
            String name = ((SimpleName)argNode).getIdentifier();
            while (takenNames.contains(name)) {
                name = String.valueOf(name) + '1';
            }
            takenNames.add(name);
            return name;
        }
        int dim = 0;
        if (type.isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            dim = arrayType.getDimensions();
            type = arrayType.getElementType();
        }
        String typeName = ASTNodes.getTypeName(type);
        String packName = Signature.getQualifier((String)typeName);
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        String[] excludedNames = takenNames.toArray(new String[takenNames.size()]);
        String[] names = NamingConventions.suggestArgumentNames((IJavaProject)project, (String)packName, (String)typeName, (int)dim, (String[])excludedNames);
        takenNames.add(names[0]);
        return names[0];
    }

    private int findInsertIndex(List decls, int currPos) {
        int nDecls = decls.size();
        int i = 0;
        while (i < nDecls) {
            ASTNode curr = (ASTNode)decls.get(i);
            if (curr instanceof MethodDeclaration && currPos < curr.getStartPosition() + curr.getLength()) {
                return i + 1;
            }
            ++i;
        }
        return nDecls;
    }

    private String getMethodName() {
        if (this.fNode instanceof MethodInvocation) {
            return ((MethodInvocation)this.fNode).getName().getIdentifier();
        }
        if (this.fNode instanceof SuperMethodInvocation) {
            return ((SuperMethodInvocation)this.fNode).getName().getIdentifier();
        }
        return this.fSenderBinding.getName();
    }

    private int evaluateModifiers(ASTNode targetTypeDecl) {
        if (this.fSenderBinding.isInterface()) {
            MethodDeclaration[] methodDecls = ((TypeDeclaration)targetTypeDecl).getMethods();
            if (methodDecls.length > 0) {
                return methodDecls[0].getModifiers();
            }
            return 0;
        }
        if (this.fNode instanceof MethodInvocation) {
            ASTNode node;
            int modifiers = 0;
            Expression expression = ((MethodInvocation)this.fNode).getExpression();
            if (expression != null) {
                if (expression instanceof Name && ((Name)expression).resolveBinding().getKind() == 2) {
                    modifiers |= 8;
                }
            } else if (ASTResolving.isInStaticContext(this.fNode)) {
                modifiers |= 8;
            }
            modifiers = targetTypeDecl.equals((Object)(node = ASTResolving.findParentType(this.fNode))) ? (modifiers |= 2) : (node instanceof AnonymousClassDeclaration ? (modifiers |= 4) : (modifiers |= 1));
            return modifiers;
        }
        return 1;
    }

    private Type evaluateMethodType(AST ast) throws CoreException {
        ITypeBinding binding = ASTResolving.guessBindingForReference(this.fNode);
        if (binding != null) {
            this.addImport(binding);
            return ASTResolving.getTypeFromTypeBinding(ast, binding);
        }
        return null;
    }

    private Type getParameterType(AST ast, Expression elem) throws CoreException {
        ITypeBinding binding = ASTResolving.normalizeTypeBinding(elem.resolveTypeBinding());
        if (binding != null) {
            this.addImport(binding);
            return ASTResolving.getTypeFromTypeBinding(ast, binding);
        }
        return ast.newSimpleType((Name)ast.newSimpleName("Object"));
    }
}

