/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.swt.graphics.Image;

public class ModifierChangeCompletionProposal
extends ASTRewriteCorrectionProposal {
    private IBinding fBinding;
    private ASTNode fNode;
    private int fIncludedModifiers;
    private int fExcludedModifiers;

    public ModifierChangeCompletionProposal(String label, ICompilationUnit targetCU, IBinding binding, ASTNode node, int includedModifiers, int excludedModifiers, int relevance, Image image) {
        super(label, targetCU, null, relevance, image);
        this.fBinding = binding;
        this.fNode = node;
        this.fIncludedModifiers = includedModifiers;
        this.fExcludedModifiers = excludedModifiers;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit(this.fNode);
        ASTNode boundNode = astRoot.findDeclaringNode(this.fBinding);
        ASTNode declNode = null;
        String groupDesc = null;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            groupDesc = "select";
            CompilationUnit newRoot = AST.parseCompilationUnit((ICompilationUnit)this.getCompilationUnit(), (boolean)true);
            declNode = newRoot.findDeclaringNode(this.fBinding.getKey());
        }
        if (declNode != null) {
            ASTRewrite rewrite = new ASTRewrite(declNode.getParent());
            AST ast = declNode.getAST();
            if (declNode instanceof MethodDeclaration) {
                MethodDeclaration methodDecl = (MethodDeclaration)declNode;
                int newModifiers = methodDecl.getModifiers() & ~this.fExcludedModifiers | this.fIncludedModifiers;
                MethodDeclaration modifiedNode = ast.newMethodDeclaration();
                modifiedNode.setConstructor(methodDecl.isConstructor());
                modifiedNode.setExtraDimensions(methodDecl.getExtraDimensions());
                modifiedNode.setModifiers(newModifiers);
                rewrite.markAsModified((ASTNode)methodDecl, (ASTNode)modifiedNode, groupDesc);
            } else if (declNode instanceof VariableDeclarationFragment) {
                ASTNode parent = declNode.getParent();
                if (parent instanceof FieldDeclaration) {
                    FieldDeclaration fieldDecl = (FieldDeclaration)parent;
                    int newModifiers = fieldDecl.getModifiers() & ~this.fExcludedModifiers | this.fIncludedModifiers;
                    FieldDeclaration modifiedNode = ast.newFieldDeclaration(ast.newVariableDeclarationFragment());
                    modifiedNode.setModifiers(newModifiers);
                    rewrite.markAsModified((ASTNode)fieldDecl, (ASTNode)modifiedNode, groupDesc);
                } else if (parent instanceof VariableDeclarationStatement) {
                    VariableDeclarationStatement varDecl = (VariableDeclarationStatement)parent;
                    int newModifiers = varDecl.getModifiers() & ~this.fExcludedModifiers | this.fIncludedModifiers;
                    VariableDeclarationStatement modifiedNode = ast.newVariableDeclarationStatement(ast.newVariableDeclarationFragment());
                    modifiedNode.setModifiers(newModifiers);
                    rewrite.markAsModified((ASTNode)varDecl, (ASTNode)modifiedNode, groupDesc);
                } else if (parent instanceof VariableDeclarationExpression) {
                    VariableDeclarationExpression varDecl = (VariableDeclarationExpression)parent;
                    int newModifiers = varDecl.getModifiers() & ~this.fExcludedModifiers | this.fIncludedModifiers;
                    VariableDeclarationExpression modifiedNode = ast.newVariableDeclarationExpression(ast.newVariableDeclarationFragment());
                    modifiedNode.setModifiers(newModifiers);
                    rewrite.markAsModified((ASTNode)varDecl, (ASTNode)modifiedNode, groupDesc);
                }
            } else if (declNode instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration variableDeclaration = (SingleVariableDeclaration)declNode;
                int newModifiers = variableDeclaration.getModifiers() & ~this.fExcludedModifiers | this.fIncludedModifiers;
                SingleVariableDeclaration modifiedNode = ast.newSingleVariableDeclaration();
                modifiedNode.setExtraDimensions(variableDeclaration.getExtraDimensions());
                modifiedNode.setModifiers(newModifiers);
                rewrite.markAsModified((ASTNode)variableDeclaration, (ASTNode)modifiedNode, groupDesc);
            } else if (declNode instanceof TypeDeclaration) {
                TypeDeclaration typeDecl = (TypeDeclaration)declNode;
                int newModifiers = typeDecl.getModifiers() & ~this.fExcludedModifiers | this.fIncludedModifiers;
                TypeDeclaration modifiedNode = ast.newTypeDeclaration();
                modifiedNode.setInterface(typeDecl.isInterface());
                modifiedNode.setModifiers(newModifiers);
                rewrite.markAsModified((ASTNode)typeDecl, (ASTNode)modifiedNode, groupDesc);
            }
            return rewrite;
        }
        return null;
    }
}

