/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IMarkerResolution;

public class MarkerResolutionProposal
implements IJavaCompletionProposal {
    private IMarkerResolution fResolution;
    private IMarker fMarker;

    public MarkerResolutionProposal(IMarkerResolution resolution, IMarker marker) {
        this.fResolution = resolution;
        this.fMarker = marker;
    }

    public void apply(IDocument document) {
        this.fResolution.run(this.fMarker);
    }

    public String getAdditionalProposalInfo() {
        try {
            String problemDesc = (String)this.fMarker.getAttribute("message");
            return CorrectionMessages.getFormattedString("MarkerResolutionProposal.additionaldesc", problemDesc);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.fResolution.getLabel();
    }

    public Image getImage() {
        return JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
    }

    public int getRelevance() {
        return 10;
    }

    public Point getSelection(IDocument document) {
        return null;
    }
}

