/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.link.LinkedPositionManager;
import org.eclipse.jdt.internal.ui.text.link.LinkedPositionUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class LinkedNamesAssistProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension2 {
    private SimpleName fNode;
    private IRegion fSelectedRegion;

    public LinkedNamesAssistProposal(SimpleName node) {
        this.fNode = node;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        try {
            ArrayList sameNodes = new ArrayList();
            LinkedNodeFinder finder = new LinkedNodeFinder(this.fNode.resolveBinding(), sameNodes);
            ASTResolving.findParentCompilationUnit((ASTNode)this.fNode).accept((ASTVisitor)finder);
            IDocument document = viewer.getDocument();
            LinkedPositionManager manager = new LinkedPositionManager(document);
            int i = 0;
            while (i < sameNodes.size()) {
                ASTNode elem = (ASTNode)sameNodes.get(i);
                manager.addPosition(elem.getStartPosition(), elem.getLength());
                ++i;
            }
            LinkedPositionUI editor = new LinkedPositionUI(viewer, manager);
            editor.setInitialOffset(offset);
            editor.setFinalCaretOffset(offset);
            editor.enter();
            this.fSelectedRegion = editor.getSelectedRegion();
        }
        catch (BadLocationException badLocationException) {}
    }

    public void apply(IDocument document) {
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        return CorrectionMessages.getString("LinkedNamesAssistProposal.proposalinfo");
    }

    public String getDisplayString() {
        return CorrectionMessages.getString("LinkedNamesAssistProposal.description");
    }

    public Image getImage() {
        return JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return 1;
    }

    public void selected(ITextViewer textViewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer textViewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }

    private static class LinkedNodeFinder
    extends ASTVisitor {
        private IBinding fBinding;
        private ArrayList fResult;

        public LinkedNodeFinder(IBinding binding, ArrayList result) {
            this.fBinding = binding;
            this.fResult = result;
        }

        public boolean visit(MethodDeclaration node) {
            ASTNode typeNode;
            if (node.isConstructor() && this.fBinding.getKind() == 2 && (typeNode = node.getParent()) instanceof TypeDeclaration && this.fBinding == ((TypeDeclaration)typeNode).resolveBinding()) {
                this.fResult.add(node.getName());
            }
            return true;
        }

        public boolean visit(TypeDeclaration node) {
            IMethodBinding binding;
            if (this.fBinding.getKind() == 4 && (binding = (IMethodBinding)this.fBinding).isConstructor() && binding.getDeclaringClass() == node.resolveBinding()) {
                this.fResult.add(node.getName());
            }
            return true;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (this.fBinding == binding) {
                this.fResult.add(node);
            } else if (binding != null && binding.getKind() == this.fBinding.getKind() && binding.getKind() == 4 && this.isConnectedMethod((IMethodBinding)binding, (IMethodBinding)this.fBinding)) {
                this.fResult.add(node);
            }
            return false;
        }

        private boolean isConnectedMethod(IMethodBinding meth1, IMethodBinding meth2) {
            ITypeBinding type2;
            ITypeBinding type1;
            return Bindings.isEqualMethod(meth1, meth2.getName(), meth2.getParameterTypes()) && (Bindings.findTypeInHierarchy(type1 = meth1.getDeclaringClass(), type2 = meth2.getDeclaringClass()) || Bindings.findTypeInHierarchy(type2, type1));
        }
    }
}

