/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.javaeditor.JavaAnnotationIterator;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionContext;
import org.eclipse.jdt.internal.ui.text.correction.ICorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.correction.MarkerResolutionProposal;
import org.eclipse.jdt.internal.ui.text.correction.NoCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.QuickAssistProcessor;
import org.eclipse.jdt.internal.ui.text.correction.QuickFixProcessor;
import org.eclipse.jdt.internal.ui.text.correction.QuickTemplateProcessor;
import org.eclipse.jdt.internal.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class JavaCorrectionProcessor
implements IContentAssistProcessor {
    private static ICorrectionProcessor[] fCodeManipulationProcessors = null;
    private IEditorPart fEditor;

    public static ICorrectionProcessor[] getCodeManipulationProcessors() {
        if (fCodeManipulationProcessors == null) {
            fCodeManipulationProcessors = new ICorrectionProcessor[]{new QuickFixProcessor(), new QuickAssistProcessor()};
        }
        return fCodeManipulationProcessors;
    }

    public static boolean hasCorrections(int problemId) {
        return QuickFixProcessor.hasCorrections(problemId);
    }

    public static boolean hasCorrections(IJavaAnnotation annotation) {
        int problemId = annotation.getId();
        if (problemId == -1) {
            if (annotation instanceof MarkerAnnotation) {
                return JavaCorrectionProcessor.hasCorrections(((MarkerAnnotation)annotation).getMarker());
            }
            return false;
        }
        return JavaCorrectionProcessor.hasCorrections(problemId);
    }

    public static boolean hasCorrections(IMarker marker) {
        if (marker == null || !marker.exists()) {
            return false;
        }
        try {
            if (marker.isSubtypeOf("org.eclipse.jdt.core.problem")) {
                int problemId = marker.getAttribute("id", -1);
                return problemId != -1 && JavaCorrectionProcessor.hasCorrections(problemId);
            }
            IMarkerHelpRegistry registry = PlatformUI.getWorkbench().getMarkerHelpRegistry();
            return registry != null && registry.hasResolutions(marker);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    public JavaCorrectionProcessor(IEditorPart editor) {
        this.fEditor = editor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        ICompilationUnit cu = JavaUI.getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
        IAnnotationModel model = JavaUI.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        ArrayList<NoCorrectionProposal> proposals = new ArrayList<NoCorrectionProposal>();
        if (model != null) {
            this.processProblemAnnotations(cu, model, viewer, documentOffset, proposals);
        }
        if (proposals.isEmpty()) {
            proposals.add(new NoCorrectionProposal(null, null));
        }
        ICompletionProposal[] res = proposals.toArray(new ICompletionProposal[proposals.size()]);
        Arrays.sort(res, new CorrectionsComparator());
        return res;
    }

    private boolean isAtPosition(int offset, Position pos) {
        return pos != null && offset >= pos.getOffset() && offset <= pos.getOffset() + pos.getLength();
    }

    private void processProblemAnnotations(ICompilationUnit cu, IAnnotationModel model, ITextViewer viewer, int offset, ArrayList proposals) {
        if (viewer != null) {
            QuickTemplateProcessor processor = new QuickTemplateProcessor();
            processor.computeCompletionProposals(viewer, cu, proposals);
            if (!proposals.isEmpty()) {
                return;
            }
        }
        CorrectionContext context = new CorrectionContext(cu);
        boolean noProbemFound = true;
        HashSet<Integer> idsProcessed = new HashSet<Integer>();
        JavaAnnotationIterator iter = new JavaAnnotationIterator(model, true);
        while (iter.hasNext()) {
            IJavaAnnotation annot = (IJavaAnnotation)iter.next();
            Position pos = model.getPosition((Annotation)annot);
            if (!this.isAtPosition(offset, pos)) continue;
            int problemId = annot.getId();
            if (problemId != -1) {
                if (idsProcessed.add(new Integer(problemId))) {
                    context.initialize(pos.getOffset(), pos.getLength(), annot.getId(), annot.getArguments());
                    JavaCorrectionProcessor.collectCorrections(context, proposals);
                    proposals.isEmpty();
                }
                noProbemFound = false;
                continue;
            }
            if (!(annot instanceof MarkerAnnotation)) continue;
            IMarker marker = ((MarkerAnnotation)annot).getMarker();
            IMarkerResolution[] res = PlatformUI.getWorkbench().getMarkerHelpRegistry().getResolutions(marker);
            if (res.length <= 0) continue;
            noProbemFound = false;
            int i = 0;
            while (i < res.length) {
                proposals.add(new MarkerResolutionProposal(res[i], marker));
                ++i;
            }
        }
        if (noProbemFound) {
            int length = viewer != null ? viewer.getSelectedRange().y : 0;
            context.initialize(offset, length, 0, null);
            JavaCorrectionProcessor.collectCorrections(context, proposals);
        }
    }

    public static void collectCorrections(CorrectionContext context, ArrayList proposals) {
        ICorrectionProcessor[] processors = JavaCorrectionProcessor.getCodeManipulationProcessors();
        int i = 0;
        while (i < processors.length) {
            try {
                processors[i].process(context, proposals);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
            ++i;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private static class CorrectionsComparator
    implements Comparator {
        private static Collator fgCollator = Collator.getInstance();

        CorrectionsComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof IJavaCompletionProposal && o2 instanceof IJavaCompletionProposal) {
                IJavaCompletionProposal e1 = (IJavaCompletionProposal)o1;
                IJavaCompletionProposal e2 = (IJavaCompletionProposal)o2;
                int del = e2.getRelevance() - e1.getRelevance();
                if (del != 0) {
                    return del;
                }
                return fgCollator.compare(e1.getDisplayString(), e1.getDisplayString());
            }
            return fgCollator.compare(((ICompletionProposal)o1).getDisplayString(), ((ICompletionProposal)o1).getDisplayString());
        }
    }
}

