/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.javaeditor.JavaAnnotationIterator;
import org.eclipse.jdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class JavaCorrectionAssistant
extends ContentAssistant {
    private ITextViewer fViewer;
    private IEditorPart fEditor;
    private Position fPosition;

    public JavaCorrectionAssistant(IEditorPart editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        JavaCorrectionProcessor processor = new JavaCorrectionProcessor(editor);
        this.setContentAssistProcessor(processor, "__dftl_partition_content_type");
        this.setContentAssistProcessor(processor, "__java_string");
        this.setContentAssistProcessor(processor, "__java_character");
        this.setContentAssistProcessor(processor, "__java_javadoc");
        this.setContentAssistProcessor(processor, "__java_multiline_comment");
        this.setContentAssistProcessor(processor, "__java_singleline_comment");
        this.enableAutoActivation(false);
        this.enableAutoInsert(false);
        this.setContextInformationPopupOrientation(20);
        this.setInformationControlCreator(this.getInformationControlCreator());
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        IColorManager manager = textTools.getColorManager();
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        Color c = JavaCorrectionAssistant.getColor(store, "content_assist_proposals_foreground", manager);
        this.setProposalSelectorForeground(c);
        c = JavaCorrectionAssistant.getColor(store, "content_assist_proposals_background", manager);
        this.setProposalSelectorBackground(c);
    }

    private IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter());
            }
        };
    }

    private static Color getColor(IPreferenceStore store, String key, IColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        this.fViewer = textViewer;
    }

    public String showPossibleCompletions() {
        int invocationLength;
        int invocationOffset;
        if (this.fViewer == null) {
            return super.showPossibleCompletions();
        }
        Point selectedRange = this.fViewer.getSelectedRange();
        int initalOffset = selectedRange.x;
        if (this.areMultipleLinesSelected()) {
            try {
                IDocument document = this.fViewer.getDocument();
                IRegion start = document.getLineInformationOfOffset(initalOffset);
                invocationOffset = start.getOffset();
                IRegion end = document.getLineInformationOfOffset(initalOffset + selectedRange.y);
                if (end.getOffset() == initalOffset + selectedRange.y) {
                    int line = document.getLineOfOffset(end.getOffset());
                    end = this.fViewer.getDocument().getLineInformation(line - 1);
                }
                invocationLength = end.getOffset() + end.getLength() - invocationOffset;
            }
            catch (BadLocationException badLocationException) {
                invocationOffset = initalOffset;
                invocationLength = 0;
            }
        } else {
            invocationOffset = this.computeOffsetWithCorrection(initalOffset);
            invocationLength = 0;
        }
        if (invocationOffset != -1) {
            this.storePosition();
            this.fViewer.setSelectedRange(invocationOffset, invocationLength);
            this.fViewer.revealRange(invocationOffset, invocationLength);
        } else {
            this.fPosition = null;
        }
        String errorMsg = super.showPossibleCompletions();
        return errorMsg;
    }

    private int computeOffsetWithCorrection(int initalOffset) {
        if (this.fViewer == null || this.fViewer.getDocument() == null) {
            return -1;
        }
        IRegion lineInfo = null;
        try {
            lineInfo = this.fViewer.getDocument().getLineInformationOfOffset(initalOffset);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
        int startOffset = lineInfo.getOffset();
        int endOffset = startOffset + lineInfo.getLength();
        int result = this.computeOffsetWithCorrection(startOffset, endOffset, initalOffset);
        if (result > 0) {
            return result;
        }
        return -1;
    }

    private int computeOffsetWithCorrection(int startOffset, int endOffset, int initialOffset) {
        IAnnotationModel model = JavaUI.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        int invocationOffset = -1;
        int offsetOfFirstProblem = Integer.MAX_VALUE;
        JavaAnnotationIterator iter = new JavaAnnotationIterator(model, true);
        while (iter.hasNext()) {
            IJavaAnnotation annot = (IJavaAnnotation)iter.next();
            Position pos = model.getPosition((Annotation)annot);
            if (!this.isIncluded(pos, startOffset, endOffset) || !JavaCorrectionProcessor.hasCorrections(annot)) continue;
            offsetOfFirstProblem = Math.min(offsetOfFirstProblem, pos.getOffset());
            if (initialOffset != (invocationOffset = this.computeBestOffset(invocationOffset, pos, initialOffset))) continue;
            return initialOffset;
        }
        if (initialOffset < offsetOfFirstProblem && offsetOfFirstProblem != Integer.MAX_VALUE) {
            return offsetOfFirstProblem;
        }
        return invocationOffset;
    }

    private boolean isIncluded(Position pos, int lineStart, int lineEnd) {
        return pos != null && pos.getOffset() >= lineStart && pos.getOffset() + pos.getLength() <= lineEnd;
    }

    private int computeBestOffset(int invocationOffset, Position pos, int initalOffset) {
        int newOffset = pos.offset;
        if (newOffset <= initalOffset && initalOffset <= newOffset + pos.length) {
            return initalOffset;
        }
        if (invocationOffset < 0) {
            return newOffset;
        }
        if (newOffset <= initalOffset && invocationOffset >= initalOffset) {
            return newOffset;
        }
        if (newOffset <= initalOffset && invocationOffset < initalOffset) {
            return Math.max(invocationOffset, newOffset);
        }
        if (invocationOffset <= initalOffset) {
            return invocationOffset;
        }
        return Math.max(invocationOffset, newOffset);
    }

    protected void possibleCompletionsClosed() {
        super.possibleCompletionsClosed();
        this.restorePosition();
    }

    private boolean areMultipleLinesSelected() {
        Point s = this.fViewer.getSelectedRange();
        if (s.y == 0) {
            return false;
        }
        try {
            IDocument document = this.fViewer.getDocument();
            int startLine = document.getLineOfOffset(s.x);
            int endLine = document.getLineOfOffset(s.x + s.y);
            IRegion line = document.getLineInformation(startLine);
            return startLine != endLine || s.x == line.getOffset() && s.y == line.getLength();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private void storePosition() {
        int initalOffset = this.fViewer.getSelectedRange().x;
        int length = this.fViewer.getSelectedRange().y;
        this.fPosition = new Position(initalOffset, length);
    }

    private void restorePosition() {
        if (this.fPosition != null && !this.fPosition.isDeleted() && this.fViewer.getDocument() != null) {
            this.fViewer.setSelectedRange(this.fPosition.offset, this.fPosition.length);
            this.fViewer.revealRange(this.fPosition.offset, this.fPosition.length);
        }
        this.fPosition = null;
    }
}

