/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.ui.text.correction.CUCorrectionProposal;

public class InsertCorrectionProposal
extends CUCorrectionProposal {
    private String fInsertionString;
    private int fOffset;

    public InsertCorrectionProposal(String label, ICompilationUnit cu, int offset, String insertString, int relevance) {
        super(label, cu, relevance);
        this.fInsertionString = insertString;
        this.fOffset = offset;
    }

    protected CompilationUnitChange createCompilationUnitChange(String name, ICompilationUnit cu, TextEdit root) throws CoreException {
        CompilationUnitChange change = super.createCompilationUnitChange(name, cu, root);
        SimpleTextEdit edit = SimpleTextEdit.createInsert(this.fOffset, this.fInsertionString);
        root.add(edit);
        return change;
    }

    public static int moveBack(int offset, int start, String ignoreCharacters, ICompilationUnit cu) {
        try {
            IBuffer buf = cu.getBuffer();
            while (offset >= start) {
                if (ignoreCharacters.indexOf(buf.getChar(offset - 1)) == -1) {
                    return offset;
                }
                --offset;
            }
        }
        catch (JavaModelException javaModelException) {}
        return start;
    }
}

