/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaMarkerAnnotation;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionContext;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.texteditor.ITextEditor;

public class CorrectionMarkerResolutionGenerator
implements IMarkerResolutionGenerator,
IMarkerResolutionGenerator2 {
    private static final IMarkerResolution[] NO_RESOLUTIONS = new IMarkerResolution[0];

    public boolean hasResolutions(IMarker marker) {
        int id = marker.getAttribute("id", -1);
        return JavaCorrectionProcessor.hasCorrections(id);
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        if (!this.hasResolutions(marker)) {
            return NO_RESOLUTIONS;
        }
        try {
            CorrectionContext context;
            IEditorInput input;
            ICompilationUnit cu = this.getCompilationUnit(marker);
            if (cu != null && (input = EditorUtility.getEditorInput(cu)) != null && (context = this.findCorrectionContext(input, marker)) != null) {
                ArrayList proposals = new ArrayList();
                JavaCorrectionProcessor.collectCorrections(context, proposals);
                int nProposals = proposals.size();
                IMarkerResolution[] resolutions = new IMarkerResolution[nProposals];
                int i = 0;
                while (i < nProposals) {
                    resolutions[i] = new CorrectionMarkerResolution(context, (IJavaCompletionProposal)proposals.get(i));
                    ++i;
                }
                return resolutions;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return new IMarkerResolution[0];
    }

    private ICompilationUnit getCompilationUnit(IMarker marker) {
        IResource res = marker.getResource();
        if (res instanceof IFile && res.isAccessible()) {
            return JavaCore.createCompilationUnitFrom((IFile)((IFile)res));
        }
        return null;
    }

    private CorrectionContext findCorrectionContext(IEditorInput input, IMarker marker) throws JavaModelException {
        IAnnotationModel model = JavaPlugin.getDefault().getCompilationUnitDocumentProvider().getAnnotationModel(input);
        if (model != null) {
            Iterator iter = model.getAnnotationIterator();
            while (iter.hasNext()) {
                Position pos;
                JavaMarkerAnnotation annot;
                Object curr = iter.next();
                if (!(curr instanceof JavaMarkerAnnotation) || !marker.equals((Object)(annot = (JavaMarkerAnnotation)curr).getMarker()) || (pos = model.getPosition((Annotation)annot)) == null) continue;
                ICompilationUnit cu = this.getCompilationUnit(marker);
                return new CorrectionContext(JavaModelUtil.toWorkingCopy(cu), pos.getOffset(), pos.getLength(), annot.getId(), annot.getArguments());
            }
        } else {
            ICompilationUnit cu = this.getCompilationUnit(marker);
            int id = marker.getAttribute("id", -1);
            int start = marker.getAttribute("charStart", -1);
            int end = marker.getAttribute("charEnd", -1);
            String[] arguments = Util.getProblemArgumentsFromMarker((String)marker.getAttribute("arguments", ""));
            if (cu != null && id != -1 && start != -1 && end != -1 && arguments != null) {
                return new CorrectionContext(JavaModelUtil.toWorkingCopy(cu), start, end - start, id, arguments);
            }
        }
        return null;
    }

    public static class CorrectionMarkerResolution
    implements IMarkerResolution {
        private CorrectionContext fCorrectionContext;
        private IJavaCompletionProposal fProposal;

        public CorrectionMarkerResolution(CorrectionContext context, IJavaCompletionProposal proposal) {
            this.fCorrectionContext = context;
            this.fProposal = proposal;
        }

        public String getLabel() {
            return this.fProposal.getDisplayString();
        }

        public void run(IMarker marker) {
            try {
                ICompilationUnit cu = this.fCorrectionContext.getCompilationUnit();
                IEditorPart part = EditorUtility.isOpenInEditor(cu);
                if (part == null && (part = EditorUtility.openInEditor(cu)) instanceof ITextEditor) {
                    ((ITextEditor)part).selectAndReveal(this.fCorrectionContext.getOffset(), this.fCorrectionContext.getLength());
                }
                if (part != null) {
                    IEditorInput input = part.getEditorInput();
                    IDocument doc = JavaPlugin.getDefault().getCompilationUnitDocumentProvider().getDocument(input);
                    this.fProposal.apply(doc);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
    }
}

