/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.text.correction.ICorrectionContext;

public class CorrectionContext
implements ICorrectionContext {
    private ICompilationUnit fCompilationUnit;
    private int fOffset;
    private int fLength;
    private int fProblemId;
    private String[] fProblemArguments;
    private CompilationUnit fASTRoot;
    private NodeFinder fNodeFinder;

    public CorrectionContext(ICompilationUnit cu) {
        this(cu, -1, 0, 0, null);
    }

    public CorrectionContext(ICompilationUnit cu, int offset, int length, int problemId, String[] problemArguments) {
        this.fCompilationUnit = cu;
        this.fASTRoot = null;
        this.fNodeFinder = null;
        this.initialize(offset, length, problemId, problemArguments);
    }

    public void initialize(int offset, int length, int problemId, String[] problemArguments) {
        this.fOffset = offset;
        this.fLength = length;
        this.fProblemId = problemId;
        this.fProblemArguments = problemArguments;
        this.fNodeFinder = null;
    }

    public int getProblemId() {
        return this.fProblemId;
    }

    public String[] getProblemArguments() {
        return this.fProblemArguments;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public CompilationUnit getASTRoot() {
        if (this.fASTRoot == null) {
            this.fASTRoot = AST.parseCompilationUnit((ICompilationUnit)this.fCompilationUnit, (boolean)true);
        }
        return this.fASTRoot;
    }

    public NodeFinder getNodeFinder() {
        if (this.fNodeFinder == null) {
            this.fNodeFinder = new NodeFinder(this.fOffset, this.fLength);
            this.getASTRoot().accept((ASTVisitor)this.fNodeFinder);
        }
        return this.fNodeFinder;
    }

    public ASTNode getCoveringNode() {
        return this.getNodeFinder().getCoveringNode();
    }

    public ASTNode getCoveredNode() {
        return this.getNodeFinder().getCoveredNode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CorrectionContext) {
            CorrectionContext other = (CorrectionContext)obj;
            return this.fCompilationUnit.equals(other.fCompilationUnit) && this.fOffset == other.fOffset && this.fLength == other.fLength && this.fProblemId == other.fProblemId;
        }
        return false;
    }

    public int hashCode() {
        return this.fCompilationUnit.hashCode() + (this.fOffset << 4) + this.fLength;
    }
}

