/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.CUCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.ICorrectionContext;

public class CorrectPackageDeclarationProposal
extends CUCorrectionProposal {
    private ICorrectionContext fCorrectionContext;

    public CorrectPackageDeclarationProposal(ICorrectionContext correctionContext, int relevance) {
        super(CorrectionMessages.getString("CorrectPackageDeclarationProposal.name"), correctionContext.getCompilationUnit(), relevance, JavaPluginImages.get("org.eclipse.jdt.ui.packd_obj.gif"));
        this.fCorrectionContext = correctionContext;
    }

    protected CompilationUnitChange createCompilationUnitChange(String name, ICompilationUnit cu, TextEdit root) throws CoreException {
        CompilationUnitChange change = super.createCompilationUnitChange(name, cu, root);
        IPackageFragment parentPack = (IPackageFragment)cu.getParent();
        IPackageDeclaration[] decls = cu.getPackageDeclarations();
        if (parentPack.isDefaultPackage() && decls.length > 0) {
            int i = 0;
            while (i < decls.length) {
                ISourceRange range = decls[i].getSourceRange();
                root.add(SimpleTextEdit.createDelete(range.getOffset(), range.getLength()));
                ++i;
            }
            return change;
        }
        if (!parentPack.isDefaultPackage() && decls.length == 0) {
            String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)cu);
            String str = "package " + parentPack.getElementName() + ";" + lineDelim + lineDelim;
            root.add(SimpleTextEdit.createInsert(0, str));
            return change;
        }
        root.add(SimpleTextEdit.createReplace(this.fCorrectionContext.getOffset(), this.fCorrectionContext.getLength(), parentPack.getElementName()));
        return change;
    }

    public String getDisplayString() {
        ICompilationUnit cu = this.fCorrectionContext.getCompilationUnit();
        IPackageFragment parentPack = (IPackageFragment)cu.getParent();
        try {
            IPackageDeclaration[] decls = cu.getPackageDeclarations();
            if (parentPack.isDefaultPackage() && decls.length > 0) {
                return CorrectionMessages.getFormattedString("CorrectPackageDeclarationProposal.remove.description", decls[0].getElementName());
            }
            if (!parentPack.isDefaultPackage() && decls.length == 0) {
                return CorrectionMessages.getFormattedString("CorrectPackageDeclarationProposal.add.description", parentPack.getElementName());
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return CorrectionMessages.getFormattedString("CorrectPackageDeclarationProposal.change.description", parentPack.getElementName());
    }
}

