/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.SimpleNameRenamer;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;

public class CorrectMainTypeNameProposal
extends ASTRewriteCorrectionProposal {
    private String fOldName;
    private String fNewName;

    public CorrectMainTypeNameProposal(ICompilationUnit cu, String oldTypeName, int relevance) {
        super("", cu, null, relevance, null);
        this.fNewName = Signature.getQualifier((String)cu.getElementName());
        this.setDisplayName(CorrectionMessages.getFormattedString("ReorgCorrectionsSubProcessor.renametype.description", this.fNewName));
        this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        this.fOldName = oldTypeName;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        char[] content = this.getCompilationUnit().getBuffer().getCharacters();
        CompilationUnit astRoot = AST.parseCompilationUnit((char[])content, (String)(String.valueOf(this.fOldName) + ".java"), (IJavaProject)this.getCompilationUnit().getJavaProject());
        ASTRewrite rewrite = new ASTRewrite((ASTNode)astRoot);
        TypeDeclaration decl = this.findTypeDeclaration(astRoot.types(), this.fOldName);
        if (decl != null) {
            ITypeBinding binding = decl.resolveBinding();
            if (binding != null) {
                SimpleNameRenamer.perform(rewrite, new IBinding[]{binding}, new String[]{this.fNewName}, (ASTNode)astRoot);
            } else {
                rewrite.markAsReplaced((ASTNode)decl.getName(), (ASTNode)astRoot.getAST().newSimpleName(this.fNewName));
            }
        }
        return rewrite;
    }

    private TypeDeclaration findTypeDeclaration(List types, String name) {
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            TypeDeclaration decl = (TypeDeclaration)iter.next();
            if (!name.equals(decl.getName().getIdentifier())) continue;
            return decl;
        }
        return null;
    }
}

