/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.base.Change;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.jdt.internal.corext.textmanipulation.MultiTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.compare.JavaTokenComparator;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class CUCorrectionProposal
extends ChangeCorrectionProposal {
    public static final String SELECTION_GROUP_DESC = "select";
    private ICompilationUnit fCompilationUnit;
    private TextEdit fRootEdit;
    private final int surroundLines = 1;

    public CUCorrectionProposal(String name, ICompilationUnit cu, int relevance) {
        this(name, cu, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
    }

    public CUCorrectionProposal(String name, ICompilationUnit cu, int relevance, Image image) {
        super(name, null, relevance, image);
        this.fRootEdit = new MultiTextEdit();
        this.fCompilationUnit = cu;
    }

    public CUCorrectionProposal(String name, CompilationUnitChange change, int relevance, Image image) {
        super(name, change, relevance, image);
        this.fCompilationUnit = change.getCompilationUnit();
    }

    protected CompilationUnitChange createCompilationUnitChange(String name, ICompilationUnit cu, TextEdit rootEdit) throws CoreException {
        CompilationUnitChange change = new CompilationUnitChange(name, cu);
        change.setEdit(rootEdit);
        change.setSave(false);
        return change;
    }

    protected Change getChange() throws CoreException {
        Change change = super.getChange();
        if (change == null) {
            change = this.createCompilationUnitChange(this.getDisplayString(), this.fCompilationUnit, this.fRootEdit);
            this.setChange(change);
        }
        return change;
    }

    protected final void addEdits(CompilationUnitChange change) throws CoreException {
    }

    public String getAdditionalProposalInfo() {
        StringBuffer buf = new StringBuffer();
        try {
            CompilationUnitChange change = this.getCompilationUnitChange();
            TextBuffer previewConent = change.getPreviewTextBuffer();
            String currentConentString = change.getCurrentContent();
            JavaTokenComparator leftSide = new JavaTokenComparator(previewConent.getContent(), true);
            JavaTokenComparator rightSide = new JavaTokenComparator(currentConentString, true);
            RangeDifference[] differences = RangeDifferencer.findRanges((IRangeComparator)leftSide, (IRangeComparator)rightSide);
            int i = 0;
            while (i < differences.length) {
                RangeDifference curr = differences[i];
                int start = leftSide.getTokenStart(curr.leftStart());
                int end = leftSide.getTokenStart(curr.leftEnd());
                if (curr.kind() == 2 && curr.leftLength() > 0) {
                    buf.append("<b>");
                    this.appendContent(previewConent, start, end, buf, false);
                    buf.append("</b>");
                } else if (curr.kind() == 0) {
                    this.appendContent(previewConent, start, end, buf, true);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return buf.toString();
    }

    private void appendContent(TextBuffer text, int startOffset, int endOffset, StringBuffer buf, boolean surroundLinesOnly) {
        int startLine = text.getLineOfOffset(startOffset);
        int endLine = text.getLineOfOffset(endOffset);
        boolean dotsAdded = false;
        if (surroundLinesOnly && startOffset == 0) {
            startLine = Math.max(endLine - 1, 0);
            buf.append("...<br>");
            dotsAdded = true;
        }
        int i = startLine;
        while (i <= endLine) {
            if (surroundLinesOnly && i - startLine > 1 && endLine - i > 1) {
                if (!dotsAdded) {
                    buf.append("...<br>");
                    dotsAdded = true;
                } else if (endOffset == text.getLength()) {
                    return;
                }
            } else {
                TextRegion lineInfo = text.getLineInformation(i);
                int start = lineInfo.getOffset();
                int end = start + lineInfo.getLength();
                int from = Math.max(start, startOffset);
                int to = Math.min(end, endOffset);
                String content = text.getContent(from, to - from);
                if (!surroundLinesOnly || from != start || !Strings.containsOnlyWhitespaces(content)) {
                    buf.append(content);
                    if (to == end && to != endOffset) {
                        buf.append("<br>");
                    }
                }
            }
            ++i;
        }
    }

    public void apply(IDocument document) {
        try {
            ICompilationUnit unit = JavaModelUtil.toOriginal(this.getCompilationUnit());
            IStatus status = Resources.makeCommittable(unit.getResource(), null);
            if (!status.isOK()) {
                String label = CorrectionMessages.getString("CUCorrectionProposal.error.title");
                String message = CorrectionMessages.getString("CUCorrectionProposal.error.message");
                ErrorDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)label, (String)message, (IStatus)status);
                return;
            }
            CompilationUnitChange change = this.getCompilationUnitChange();
            GroupDescription[] descriptions = change.getGroupDescriptions();
            GroupDescription selection = null;
            int i = 0;
            while (i < descriptions.length) {
                GroupDescription curr = descriptions[i];
                if (SELECTION_GROUP_DESC.equals(curr.getName())) {
                    selection = curr;
                    break;
                }
                ++i;
            }
            IEditorPart part = null;
            if (selection != null) {
                IWorkbenchPage page;
                change.setKeepExecutedTextEdits(true);
                part = EditorUtility.isOpenInEditor(unit);
                if (part == null) {
                    part = EditorUtility.openInEditor(unit, true);
                }
                if ((page = JavaPlugin.getActivePage()) != null && part != null) {
                    page.bringToTop((IWorkbenchPart)part);
                }
            }
            super.apply(document);
            if (part instanceof ITextEditor) {
                TextRange range = change.getNewTextRange(selection.getTextEdits());
                ((ITextEditor)part).selectAndReveal(range.getOffset(), range.getLength());
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }

    public CompilationUnitChange getCompilationUnitChange() throws CoreException {
        return (CompilationUnitChange)this.getChange();
    }

    public TextEdit getRootTextEdit() {
        return this.fRootEdit;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }
}

