/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Point;

public class AssignToVariableAssistProposal
extends ASTRewriteCorrectionProposal {
    public static final int LOCAL = 1;
    public static final int FIELD = 2;
    private int fVariableKind;
    private ExpressionStatement fExpressionStatement;
    private ITypeBinding fTypeBinding;

    public AssignToVariableAssistProposal(ICompilationUnit cu, int variableKind, ExpressionStatement node, ITypeBinding typeBinding, int relevance) {
        super(null, cu, null, relevance, null);
        this.fVariableKind = variableKind;
        this.fExpressionStatement = node;
        this.fTypeBinding = typeBinding;
        if (variableKind == 1) {
            this.setDisplayName(CorrectionMessages.getString("AssignToVariableAssistProposal.assigntolocal.description"));
            this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif"));
        } else {
            this.setDisplayName(CorrectionMessages.getString("AssignToVariableAssistProposal.assigntofield.description"));
            this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.field_private_obj.gif"));
        }
    }

    protected CompilationUnitChange createCompilationUnitChange(String name, ICompilationUnit cu, TextEdit rootEdit) throws CoreException {
        CompilationUnitChange change = super.createCompilationUnitChange(name, cu, rootEdit);
        change.setKeepExecutedTextEdits(true);
        return change;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        if (this.fVariableKind == 2) {
            return this.doAddField();
        }
        return this.doAddLocal();
    }

    private ASTRewrite doAddLocal() throws CoreException {
        Expression expression = this.fExpressionStatement.getExpression();
        ASTRewrite rewrite = new ASTRewrite(this.fExpressionStatement.getParent());
        AST ast = this.fExpressionStatement.getAST();
        String varName = this.suggestLocalVariableNames(this.fTypeBinding);
        VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
        newDeclFrag.setName(ast.newSimpleName(varName));
        newDeclFrag.setInitializer((Expression)rewrite.createCopy((ASTNode)expression));
        VariableDeclarationStatement newDecl = ast.newVariableDeclarationStatement(newDeclFrag);
        newDecl.setType(ASTResolving.getTypeFromTypeBinding(ast, this.fTypeBinding));
        rewrite.markAsReplaced((ASTNode)this.fExpressionStatement, (ASTNode)newDecl, "ID");
        this.addImport(this.fTypeBinding);
        return rewrite;
    }

    private ASTRewrite doAddField() throws CoreException {
        ASTNode newTypeDecl = ASTResolving.findParentType((ASTNode)this.fExpressionStatement);
        Expression expression = this.fExpressionStatement.getExpression();
        boolean isAnonymous = newTypeDecl.getNodeType() == 1;
        List decls = isAnonymous ? ((AnonymousClassDeclaration)newTypeDecl).bodyDeclarations() : ((TypeDeclaration)newTypeDecl).bodyDeclarations();
        ASTRewrite rewrite = new ASTRewrite(newTypeDecl);
        AST ast = this.fExpressionStatement.getAST();
        String varName = this.suggestFieldNames(this.fTypeBinding);
        VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
        newDeclFrag.setName(ast.newSimpleName(varName));
        FieldDeclaration newDecl = ast.newFieldDeclaration(newDeclFrag);
        newDecl.setType(ASTResolving.getTypeFromTypeBinding(ast, this.fTypeBinding));
        newDecl.setModifiers(2);
        Assignment assignment = ast.newAssignment();
        assignment.setLeftHandSide((Expression)ast.newSimpleName(varName));
        assignment.setRightHandSide((Expression)rewrite.createCopy((ASTNode)expression));
        rewrite.markAsReplaced((ASTNode)expression, (ASTNode)assignment, "ID");
        decls.add(this.findInsertIndex(decls, this.fExpressionStatement.getStartPosition()), newDecl);
        this.addImport(this.fTypeBinding);
        rewrite.markAsInserted((ASTNode)newDecl);
        return rewrite;
    }

    private String suggestLocalVariableNames(ITypeBinding binding) {
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        ITypeBinding base = binding.isArray() ? binding.getElementType() : binding;
        IPackageBinding packBinding = base.getPackage();
        String packName = packBinding != null ? packBinding.getName() : "";
        String[] excludedNames = new String[]{};
        String typeName = base.getName();
        String[] names = NamingConventions.suggestLocalVariableNames((IJavaProject)project, (String)packName, (String)typeName, (int)binding.getDimensions(), (String[])excludedNames);
        if (names.length == 0) {
            return "class1";
        }
        return names[0];
    }

    private String suggestFieldNames(ITypeBinding binding) {
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        ITypeBinding base = binding.isArray() ? binding.getElementType() : binding;
        IPackageBinding packBinding = base.getPackage();
        String packName = packBinding != null ? packBinding.getName() : "";
        String[] excludedNames = new String[]{};
        String typeName = base.getName();
        String[] names = NamingConventions.suggestFieldNames((IJavaProject)project, (String)packName, (String)typeName, (int)binding.getDimensions(), (int)binding.getModifiers(), (String[])excludedNames);
        if (names.length == 0) {
            return "class1";
        }
        return names[0];
    }

    private int findInsertIndex(List decls, int currPos) {
        int i = decls.size() - 1;
        while (i >= 0) {
            ASTNode curr = (ASTNode)decls.get(i);
            if (curr instanceof FieldDeclaration && currPos > curr.getStartPosition() + curr.getLength()) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    public int getVariableKind() {
        return this.fVariableKind;
    }

    public Point getSelection(IDocument document) {
        try {
            CompilationUnitChange change = this.getCompilationUnitChange();
            GroupDescription[] desc = change.getGroupDescriptions();
            TextRange range = change.getNewTextRange(desc[0].getTextEdits());
            IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(document.get(range.getOffset(), range.getLength()).toCharArray());
            Point res = new Point(0, 0);
            int tok = scanner.getNextToken();
            while (tok != 158) {
                res.x = scanner.getCurrentTokenStartPosition() + range.getOffset();
                res.y = scanner.getCurrentTokenEndPosition() - scanner.getCurrentTokenStartPosition() + 1;
                tok = scanner.getNextToken();
                if (tok != 167) continue;
                return res;
            }
        }
        catch (CoreException coreException) {
        }
        catch (InvalidInputException invalidInputException) {
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }
}

