/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportEdit;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.correction.CUCorrectionProposal;
import org.eclipse.swt.graphics.Image;

public class ASTRewriteCorrectionProposal
extends CUCorrectionProposal {
    private ASTRewrite fRewrite;
    private ImportEdit fImportEdit;

    public ASTRewriteCorrectionProposal(String name, ICompilationUnit cu, ASTRewrite rewrite, int relevance, Image image) {
        super(name, cu, relevance, image);
        this.fRewrite = rewrite;
        this.fImportEdit = null;
    }

    protected CompilationUnitChange createCompilationUnitChange(String name, ICompilationUnit cu, TextEdit rootEdit) throws CoreException {
        CompilationUnitChange change = super.createCompilationUnitChange(name, cu, rootEdit);
        TextBuffer buffer = null;
        try {
            buffer = TextBuffer.acquire(change.getFile());
            ArrayList groupDescriptions = new ArrayList(5);
            ASTRewrite rewrite = this.getRewrite();
            if (rewrite != null) {
                rewrite.rewriteNode(buffer, rootEdit, groupDescriptions);
                rewrite.removeModifications();
                int i = 0;
                while (i < groupDescriptions.size()) {
                    change.addGroupDescription((GroupDescription)groupDescriptions.get(i));
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (buffer != null) {
                TextBuffer.release(buffer);
            }
            throw throwable;
        }
        Object var9_11 = null;
        if (buffer != null) {
            TextBuffer.release(buffer);
        }
        if (this.fImportEdit != null && !this.fImportEdit.isEmpty()) {
            rootEdit.add(this.fImportEdit);
        }
        return change;
    }

    private ImportEdit getImportEdit() throws CoreException {
        if (this.fImportEdit == null) {
            this.fImportEdit = new ImportEdit(this.getCompilationUnit(), JavaPreferencesSettings.getCodeGenerationSettings());
        }
        return this.fImportEdit;
    }

    public String addImport(String qualifiedTypeName) throws CoreException {
        return this.getImportEdit().addImport(qualifiedTypeName);
    }

    public String addImport(ITypeBinding binding) throws CoreException {
        return this.getImportEdit().addImport(binding);
    }

    protected ASTRewrite getRewrite() throws CoreException {
        return this.fRewrite;
    }

    public void ensureNoModifications() throws CoreException {
        if (this.fRewrite != null && this.fRewrite.hasInserts()) {
            this.getChange();
        }
    }
}

