/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Binding2JavaModel;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class ASTResolving {
    public static ITypeBinding normalizeTypeBinding(ITypeBinding binding) {
        if (binding != null && !binding.isNullType() && !"void".equals(binding.getName())) {
            if (binding.isAnonymous()) {
                ITypeBinding[] baseBindings = binding.getInterfaces();
                if (baseBindings.length > 0) {
                    return baseBindings[0];
                }
                return binding.getSuperclass();
            }
            return binding;
        }
        return null;
    }

    public static ITypeBinding guessBindingForReference(ASTNode node) {
        return ASTResolving.normalizeTypeBinding(ASTResolving.getPossibleReferenceBinding(node));
    }

    private static ITypeBinding getPossibleReferenceBinding(ASTNode node) {
        ASTNode parent = node.getParent();
        switch (parent.getNodeType()) {
            case 7: {
                Assignment assignment = (Assignment)parent;
                if (node.equals((Object)assignment.getLeftHandSide())) {
                    return assignment.getRightHandSide().resolveTypeBinding();
                }
                return assignment.getLeftHandSide().resolveTypeBinding();
            }
            case 27: {
                InfixExpression infix = (InfixExpression)parent;
                if (node.equals((Object)infix.getLeftOperand())) {
                    return infix.getRightOperand().resolveTypeBinding();
                }
                InfixExpression.Operator op = infix.getOperator();
                if (op == InfixExpression.Operator.LEFT_SHIFT || op == InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED || op == InfixExpression.Operator.RIGHT_SHIFT_SIGNED) {
                    return infix.getAST().resolveWellKnownType("int");
                }
                return infix.getLeftOperand().resolveTypeBinding();
            }
            case 62: {
                InstanceofExpression instanceofExpression = (InstanceofExpression)parent;
                return instanceofExpression.getRightOperand().resolveBinding();
            }
            case 59: {
                VariableDeclarationFragment frag = (VariableDeclarationFragment)parent;
                if (!frag.getInitializer().equals((Object)node)) break;
                ASTNode declaration = frag.getParent();
                if (declaration instanceof VariableDeclarationStatement) {
                    return ((VariableDeclarationStatement)declaration).getType().resolveBinding();
                }
                if (!(declaration instanceof FieldDeclaration)) break;
                return ((FieldDeclaration)declaration).getType().resolveBinding();
            }
            case 48: {
                SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)parent;
                IMethodBinding superMethodBinding = ASTNodes.getMethodBinding((Name)superMethodInvocation.getName());
                if (superMethodBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, superMethodInvocation.arguments(), superMethodBinding);
            }
            case 32: {
                MethodInvocation methodInvocation = (MethodInvocation)parent;
                IMethodBinding methodBinding = ASTNodes.getMethodBinding((Name)methodInvocation.getName());
                if (methodBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, methodInvocation.arguments(), methodBinding);
            }
            case 46: {
                SuperConstructorInvocation superInvocation = (SuperConstructorInvocation)parent;
                IMethodBinding superBinding = superInvocation.resolveConstructorBinding();
                if (superBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, superInvocation.arguments(), superBinding);
            }
            case 17: {
                ConstructorInvocation constrInvocation = (ConstructorInvocation)parent;
                IMethodBinding constrBinding = constrInvocation.resolveConstructorBinding();
                if (constrBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, constrInvocation.arguments(), constrBinding);
            }
            case 14: {
                ClassInstanceCreation creation = (ClassInstanceCreation)parent;
                IMethodBinding creationBinding = creation.resolveConstructorBinding();
                if (creationBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, creation.arguments(), creationBinding);
            }
            case 36: {
                return ASTResolving.guessBindingForReference(parent);
            }
            case 2: {
                if (!((ArrayAccess)parent).getIndex().equals((Object)node)) break;
                return parent.getAST().resolveWellKnownType("int");
            }
            case 3: {
                if (!((ArrayCreation)parent).dimensions().contains(node)) break;
                return parent.getAST().resolveWellKnownType("int");
            }
            case 4: {
                ASTNode initializerParent = parent.getParent();
                if (!(initializerParent instanceof ArrayCreation)) break;
                return ((ArrayCreation)initializerParent).getType().getElementType().resolveBinding();
            }
            case 16: {
                ConditionalExpression expression = (ConditionalExpression)parent;
                if (node.equals((Object)expression.getExpression())) {
                    return parent.getAST().resolveWellKnownType("boolean");
                }
                if (node.equals((Object)expression.getElseExpression())) {
                    return expression.getThenExpression().resolveTypeBinding();
                }
                return expression.getElseExpression().resolveTypeBinding();
            }
            case 37: {
                return parent.getAST().resolveWellKnownType("int");
            }
            case 38: {
                if (((PrefixExpression)parent).getOperator() == PrefixExpression.Operator.NOT) {
                    return parent.getAST().resolveWellKnownType("boolean");
                }
                return parent.getAST().resolveWellKnownType("int");
            }
            case 19: 
            case 25: 
            case 61: {
                if (!(node instanceof Expression)) break;
                return parent.getAST().resolveWellKnownType("boolean");
            }
            case 50: {
                if (!((SwitchStatement)parent).getExpression().equals((Object)node)) break;
                return parent.getAST().resolveWellKnownType("int");
            }
            case 41: {
                MethodDeclaration decl = ASTResolving.findParentMethodDeclaration(parent);
                if (decl == null) break;
                return decl.getReturnType().resolveBinding();
            }
            case 11: {
                return ((CastExpression)parent).getType().resolveBinding();
            }
            case 12: 
            case 53: {
                return parent.getAST().resolveWellKnownType("java.lang.Exception");
            }
            case 22: {
                if (!node.equals((Object)((FieldAccess)parent).getName())) break;
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 40: {
                if (!node.equals((Object)((QualifiedName)parent).getName())) break;
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
        }
        return null;
    }

    private static ITypeBinding getParameterTypeBinding(ASTNode node, List args, IMethodBinding binding) {
        ITypeBinding[] paramTypes = binding.getParameterTypes();
        int index = args.indexOf(node);
        if (index >= 0 && index < paramTypes.length) {
            return paramTypes[index];
        }
        return null;
    }

    public static ITypeBinding guessBindingForTypeReference(ASTNode node) {
        return ASTResolving.normalizeTypeBinding(ASTResolving.getPossibleTypeBinding(node));
    }

    private static ITypeBinding getPossibleTypeBinding(ASTNode node) {
        ASTNode parent = node.getParent();
        while (parent instanceof Type) {
            parent = parent.getParent();
        }
        switch (parent.getNodeType()) {
            case 60: {
                return ASTResolving.guessVariableType(((VariableDeclarationStatement)parent).fragments());
            }
            case 23: {
                return ASTResolving.guessVariableType(((FieldDeclaration)parent).fragments());
            }
            case 58: {
                return ASTResolving.guessVariableType(((VariableDeclarationExpression)parent).fragments());
            }
            case 44: {
                SingleVariableDeclaration varDecl = (SingleVariableDeclaration)parent;
                if (varDecl.getInitializer() == null) break;
                return varDecl.getInitializer().resolveTypeBinding();
            }
            case 3: {
                ArrayCreation creation = (ArrayCreation)parent;
                if (creation.getInitializer() != null) {
                    return creation.getInitializer().resolveTypeBinding();
                }
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 14: 
            case 57: {
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
        }
        return null;
    }

    private static ITypeBinding guessVariableType(List fragments) {
        Iterator iter = fragments.iterator();
        while (iter.hasNext()) {
            VariableDeclarationFragment frag = (VariableDeclarationFragment)iter.next();
            if (frag.getInitializer() == null) continue;
            return frag.getInitializer().resolveTypeBinding();
        }
        return null;
    }

    private static int getTypeOrder(PrimitiveType.Code type) {
        if (type == PrimitiveType.BYTE) {
            return 2;
        }
        if (type == PrimitiveType.CHAR) {
            return 3;
        }
        if (type == PrimitiveType.SHORT) {
            return 3;
        }
        if (type == PrimitiveType.INT) {
            return 4;
        }
        if (type == PrimitiveType.LONG) {
            return 5;
        }
        if (type == PrimitiveType.FLOAT) {
            return 6;
        }
        if (type == PrimitiveType.DOUBLE) {
            return 7;
        }
        return 0;
    }

    public static boolean canAssignPrimitive(PrimitiveType.Code toAssignCode, PrimitiveType.Code definedTypeCode) {
        if (toAssignCode == definedTypeCode) {
            return true;
        }
        if (definedTypeCode == PrimitiveType.BOOLEAN || toAssignCode == PrimitiveType.BOOLEAN) {
            return false;
        }
        if (definedTypeCode == PrimitiveType.CHAR && toAssignCode == PrimitiveType.BYTE) {
            return false;
        }
        return ASTResolving.getTypeOrder(definedTypeCode) > ASTResolving.getTypeOrder(toAssignCode);
    }

    public static boolean canAssign(ITypeBinding typeToAssign, String definedType) {
        int arrStart = definedType.indexOf(91);
        if (arrStart != -1) {
            int toAssignDim;
            if (!typeToAssign.isArray()) {
                return false;
            }
            int definedDim = definedType.length() - arrStart;
            if (definedDim == (toAssignDim = typeToAssign.getDimensions() * 2)) {
                definedType = definedType.substring(0, arrStart);
                if ((typeToAssign = typeToAssign.getElementType()).isPrimitive() && !definedType.equals(typeToAssign.getName())) {
                    return false;
                }
                return ASTResolving.canAssign(typeToAssign, definedType);
            }
            if (definedDim < toAssignDim) {
                return ASTResolving.isArrayCompatible(definedType.substring(0, arrStart));
            }
            return false;
        }
        PrimitiveType.Code definedTypeCode = PrimitiveType.toCode((String)definedType);
        if (typeToAssign.isPrimitive()) {
            if (definedTypeCode == null) {
                return false;
            }
            PrimitiveType.Code toAssignCode = PrimitiveType.toCode((String)typeToAssign.getName());
            return ASTResolving.canAssignPrimitive(toAssignCode, definedTypeCode);
        }
        if (definedTypeCode != null) {
            return false;
        }
        if (typeToAssign.isArray()) {
            return ASTResolving.isArrayCompatible(definedType);
        }
        if ("java.lang.Object".equals(definedType)) {
            return true;
        }
        return Bindings.findTypeInHierarchy(typeToAssign, definedType) != null;
    }

    private static boolean isArrayCompatible(String definedType) {
        return "java.lang.Object".equals(definedType) || "java.io.Serializable".equals(definedType) || "java.lang.Cloneable".equals(definedType);
    }

    public static MethodDeclaration findParentMethodDeclaration(ASTNode node) {
        while (node != null && node.getNodeType() != 31) {
            node = node.getParent();
        }
        return (MethodDeclaration)node;
    }

    public static BodyDeclaration findParentBodyDeclaration(ASTNode node) {
        while (node != null && !(node instanceof BodyDeclaration)) {
            node = node.getParent();
        }
        return (BodyDeclaration)node;
    }

    public static CompilationUnit findParentCompilationUnit(ASTNode node) {
        return (CompilationUnit)ASTResolving.findAncestor(node, 15);
    }

    public static ASTNode findParentType(ASTNode node) {
        while (node != null && node.getNodeType() != 55 && node.getNodeType() != 1) {
            node = node.getParent();
        }
        return node;
    }

    public static ASTNode findAncestor(ASTNode node, int nodeType) {
        while (node != null && node.getNodeType() != nodeType) {
            node = node.getParent();
        }
        return node;
    }

    public static ITypeBinding getBindingOfParentType(ASTNode node) {
        while (node != null) {
            if (node instanceof TypeDeclaration) {
                return ((TypeDeclaration)node).resolveBinding();
            }
            if (node instanceof AnonymousClassDeclaration) {
                return ((AnonymousClassDeclaration)node).resolveBinding();
            }
            node = node.getParent();
        }
        return null;
    }

    public static Statement findParentStatement(ASTNode node) {
        while (node != null && !(node instanceof Statement)) {
            if (!((node = node.getParent()) instanceof BodyDeclaration)) continue;
            return null;
        }
        return (Statement)node;
    }

    public static TryStatement findParentTryStatement(ASTNode node) {
        while (node != null && !(node instanceof TryStatement)) {
            if (!((node = node.getParent()) instanceof BodyDeclaration)) continue;
            return null;
        }
        return (TryStatement)node;
    }

    public static boolean isInStaticContext(ASTNode selectedNode) {
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof MethodDeclaration) {
            return Modifier.isStatic((int)((MethodDeclaration)decl).getModifiers());
        }
        if (decl instanceof Initializer) {
            return Modifier.isStatic((int)((Initializer)decl).getModifiers());
        }
        if (decl instanceof FieldDeclaration) {
            return Modifier.isStatic((int)((FieldDeclaration)decl).getModifiers());
        }
        return false;
    }

    public static Type getTypeFromTypeBinding(AST ast, ITypeBinding binding) {
        if (binding.isArray()) {
            int dim = binding.getDimensions();
            return ast.newArrayType(ASTResolving.getTypeFromTypeBinding(ast, binding.getElementType()), dim);
        }
        if (binding.isPrimitive()) {
            String name = binding.getName();
            return ast.newPrimitiveType(PrimitiveType.toCode((String)name));
        }
        if (!binding.isNullType() && !binding.isAnonymous()) {
            return ast.newSimpleType((Name)ast.newSimpleName(binding.getName()));
        }
        return null;
    }

    public static Expression getInitExpression(Type type, int extraDimensions) {
        if (extraDimensions == 0 && type.isPrimitiveType()) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            if (primitiveType.getPrimitiveTypeCode() == PrimitiveType.BOOLEAN) {
                return type.getAST().newBooleanLiteral(false);
            }
            if (primitiveType.getPrimitiveTypeCode() == PrimitiveType.VOID) {
                return null;
            }
            return type.getAST().newNumberLiteral("0");
        }
        return type.getAST().newNullLiteral();
    }

    public static Expression getInitExpression(AST ast, ITypeBinding type) {
        if (type.isPrimitive()) {
            String name = type.getName();
            if ("boolean".equals(name)) {
                return ast.newBooleanLiteral(false);
            }
            if ("void".equals(name)) {
                return null;
            }
            return ast.newNumberLiteral("0");
        }
        return ast.newNullLiteral();
    }

    private static TypeDeclaration findTypeDeclaration(List decls, String name) {
        Iterator iter = decls.iterator();
        while (iter.hasNext()) {
            TypeDeclaration decl;
            ASTNode elem = (ASTNode)iter.next();
            if (!(elem instanceof TypeDeclaration) || !name.equals((decl = (TypeDeclaration)elem).getName().getIdentifier())) continue;
            return decl;
        }
        return null;
    }

    public static TypeDeclaration findTypeDeclaration(CompilationUnit root, ITypeBinding binding) {
        ArrayList<String> names = new ArrayList<String>(5);
        while (binding != null) {
            names.add(binding.getName());
            binding = binding.getDeclaringClass();
        }
        List types = root.types();
        int i = names.size() - 1;
        while (i >= 0) {
            String name = (String)names.get(i);
            TypeDeclaration decl = ASTResolving.findTypeDeclaration(types, name);
            if (decl == null || i == 0) {
                return decl;
            }
            types = decl.bodyDeclarations();
            --i;
        }
        return null;
    }

    public static String getFullName(Name name) {
        return ASTNodes.asString((ASTNode)name);
    }

    public static String getQualifier(Name name) {
        if (name.isQualifiedName()) {
            return ASTResolving.getFullName(((QualifiedName)name).getQualifier());
        }
        return "";
    }

    public static String getSimpleName(Name name) {
        if (name.isQualifiedName()) {
            return ((QualifiedName)name).getName().getIdentifier();
        }
        return ((SimpleName)name).getIdentifier();
    }

    public static ICompilationUnit findCompilationUnitForBinding(ICompilationUnit cu, CompilationUnit astRoot, ITypeBinding binding) throws JavaModelException {
        if (binding != null && binding.isFromSource() && astRoot.findDeclaringNode((IBinding)binding) == null) {
            ICompilationUnit targetCU = Binding2JavaModel.findCompilationUnit(binding, cu.getJavaProject());
            if (targetCU != null) {
                return JavaModelUtil.toWorkingCopy(targetCU);
            }
            return null;
        }
        return cu;
    }
}

