/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import org.eclipse.jdt.internal.ui.text.java.JavaReconcilingStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaReconciler
extends MonoReconciler {
    private ITextEditor fTextEditor;
    private IPartListener fPartListener;

    public JavaReconciler(ITextEditor editor, IReconcilingStrategy strategy, boolean isIncremental) {
        super(strategy, isIncremental);
        this.fTextEditor = editor;
    }

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        this.fPartListener = new PartListener();
        IWorkbenchPartSite site = this.fTextEditor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().addPartListener(this.fPartListener);
    }

    public void uninstall() {
        IWorkbenchPartSite site = this.fTextEditor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().removePartListener(this.fPartListener);
        this.fPartListener = null;
        super.uninstall();
    }

    protected void forceReconciling() {
        super.forceReconciling();
        IReconcilingStrategy strategy = this.getReconcilingStrategy("__dftl_partition_content_type");
        if (strategy instanceof JavaReconcilingStrategy) {
            JavaReconcilingStrategy java = (JavaReconcilingStrategy)strategy;
            java.notifyParticipants(false);
        }
    }

    protected void reconcilerReset() {
        super.reconcilerReset();
        IReconcilingStrategy strategy = this.getReconcilingStrategy("__dftl_partition_content_type");
        if (strategy instanceof JavaReconcilingStrategy) {
            JavaReconcilingStrategy java = (JavaReconcilingStrategy)strategy;
            java.notifyParticipants(true);
        }
    }

    class PartListener
    implements IPartListener {
        PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == JavaReconciler.this.fTextEditor) {
                JavaReconciler.this.forceReconciling();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

