/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.text.HTMLPrinter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;

public class JavaAnnotationHover
implements IAnnotationHover {
    protected int compareRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                int javaAnnotationLine = document.getLineOfOffset(position.getOffset());
                if (line == javaAnnotationLine) {
                    return 1;
                }
                if (javaAnnotationLine <= line && line <= document.getLineOfOffset(position.getOffset() + position.getLength())) {
                    return 2;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return 0;
    }

    protected List select(List exactMatch, List including) {
        return exactMatch;
    }

    protected List getJavaAnnotationsForLine(ISourceViewer viewer, int line) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        ArrayList<IJavaAnnotation> exact = new ArrayList<IJavaAnnotation>();
        ArrayList<IJavaAnnotation> including = new ArrayList<IJavaAnnotation>();
        Iterator e = model.getAnnotationIterator();
        HashMap messagesAtPosition = new HashMap();
        while (e.hasNext()) {
            Position position;
            IJavaAnnotation a;
            Object o = e.next();
            if (!(o instanceof IJavaAnnotation) || (a = (IJavaAnnotation)o).hasOverlay() || (position = model.getPosition((Annotation)a)) == null || this.isDuplicateJavaAnnotation(messagesAtPosition, position, a.getMessage())) continue;
            switch (this.compareRulerLine(position, document, line)) {
                case 1: {
                    exact.add(a);
                    break;
                }
                case 2: {
                    including.add(a);
                }
            }
        }
        return this.select(exact, including);
    }

    private boolean isDuplicateJavaAnnotation(Map messagesAtPosition, Position position, String message) {
        if (messagesAtPosition.containsKey(position)) {
            Object value = messagesAtPosition.get(position);
            if (message.equals(value)) {
                return true;
            }
            if (value instanceof List) {
                List messages = (List)value;
                if (messages.contains(message)) {
                    return true;
                }
                messages.add(message);
            } else {
                ArrayList<Object> messages = new ArrayList<Object>();
                messages.add(value);
                messages.add(message);
                messagesAtPosition.put(position, messages);
            }
        } else {
            messagesAtPosition.put(position, message);
        }
        return false;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List javaAnnotations = this.getJavaAnnotationsForLine(sourceViewer, lineNumber);
        if (javaAnnotations != null) {
            if (javaAnnotations.size() == 1) {
                IJavaAnnotation javaAnnotation = (IJavaAnnotation)javaAnnotations.get(0);
                String message = javaAnnotation.getMessage();
                if (message != null && message.trim().length() > 0) {
                    return this.formatSingleMessage(message);
                }
            } else {
                ArrayList<String> messages = new ArrayList<String>();
                Iterator e = javaAnnotations.iterator();
                while (e.hasNext()) {
                    IJavaAnnotation javaAnnotation = (IJavaAnnotation)e.next();
                    String message = javaAnnotation.getMessage();
                    if (message == null || message.trim().length() <= 0) continue;
                    messages.add(message.trim());
                }
                if (messages.size() == 1) {
                    return this.formatSingleMessage((String)messages.get(0));
                }
                if (messages.size() > 1) {
                    return this.formatMultipleMessages(messages);
                }
            }
        }
        return null;
    }

    private String formatSingleMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(message));
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    private String formatMultipleMessages(List messages) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(JavaUIMessages.getString("JavaAnnotationHover.multipleMarkersAtThisLine")));
        HTMLPrinter.startBulletList(buffer);
        Iterator e = messages.iterator();
        while (e.hasNext()) {
            HTMLPrinter.addBullet(buffer, HTMLPrinter.convertToHTMLContent((String)e.next()));
        }
        HTMLPrinter.endBulletList(buffer);
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }
}

