/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.browsing.JavaElementTypeComparator;
import org.eclipse.jdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.jdt.internal.ui.search.LRUWorkingSetsList;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.WorkingSetComparator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class SearchUtil
extends JavaModelUtil {
    public static int LRU_WORKINGSET_LIST_SIZE = 3;
    private static LRUWorkingSetsList fgLRUWorkingSets;
    private static final String DIALOG_SETTINGS_KEY = "JavaElementSearchActions";
    private static final String STORE_LRU_WORKING_SET_NAMES = "lastUsedWorkingSetNames";
    private static final JavaElementTypeComparator fgJavaElementTypeComparator;
    private static IDialogSettings fgSettingsStore;
    private static final String BIN_PRIM_CONST_WARN_DIALOG_ID = "BinaryPrimitiveConstantWarningDialog";
    static /* synthetic */ Class class$0;

    static {
        fgJavaElementTypeComparator = new JavaElementTypeComparator();
    }

    public static IJavaElement getJavaElement(IMarker marker) {
        if (marker == null || !marker.exists()) {
            return null;
        }
        try {
            String handleId = (String)marker.getAttribute("org.eclipse.jdt.internal.ui.search.handleID");
            IJavaElement je = JavaCore.create((String)handleId);
            if (je == null) {
                return null;
            }
            if (!marker.getAttribute("org.eclipse.jdt.internal.ui.search.isWorkingCopy", false) && je != null && je.exists()) {
                return je;
            }
            if (SearchUtil.isBinary(je) || fgJavaElementTypeComparator.compare((Object)je, 5) > 0) {
                return je;
            }
            ICompilationUnit cu = SearchUtil.findCompilationUnit(je);
            if (cu == null || !cu.exists()) {
                cu = (ICompilationUnit)JavaCore.create((IResource)marker.getResource());
            }
            IWorkingCopy[] workingCopies = JavaUI.getSharedWorkingCopiesOnClasspath();
            int i = 0;
            while (i < workingCopies.length) {
                if (workingCopies[i].getOriginalElement().equals(cu)) {
                    je = SearchUtil.findInWorkingCopy(workingCopies[i], je, true);
                    break;
                }
                ++i;
            }
            if (je != null && !je.exists()) {
                IJavaElement[] jElements = cu.findElements(je);
                je = jElements == null || jElements.length == 0 ? cu.getElementAt(marker.getAttribute("charStart", 0)) : jElements[0];
            }
            return je;
        }
        catch (CoreException ex) {
            ExceptionHandler.handle(ex, SearchMessages.getString("Search.Error.createJavaElement.title"), SearchMessages.getString("Search.Error.createJavaElement.message"));
            return null;
        }
    }

    public static IJavaElement getJavaElement(Object entry) {
        if (entry != null && SearchUtil.isISearchResultViewEntry(entry)) {
            return SearchUtil.getJavaElement((ISearchResultViewEntry)entry);
        }
        return null;
    }

    public static IResource getResource(Object entry) {
        if (entry != null && SearchUtil.isISearchResultViewEntry(entry)) {
            return ((ISearchResultViewEntry)entry).getResource();
        }
        return null;
    }

    public static IJavaElement getJavaElement(ISearchResultViewEntry entry) {
        if (entry != null) {
            return SearchUtil.getJavaElement(entry.getSelectedMarker());
        }
        return null;
    }

    public static boolean isSearchPlugInActivated() {
        return Platform.getPluginRegistry().getPluginDescriptor("org.eclipse.search").isPluginActivated();
    }

    public static boolean isISearchResultViewEntry(Object object) {
        return object != null && SearchUtil.isSearchPlugInActivated() && object instanceof ISearchResultViewEntry;
    }

    private static boolean isBinary(IJavaElement jElement) {
        if (jElement instanceof IMember) {
            return ((IMember)jElement).isBinary();
        }
        IPackageFragmentRoot pkgRoot = (IPackageFragmentRoot)jElement.getAncestor(3);
        return pkgRoot != null && pkgRoot.isArchive();
    }

    private static IJavaElement findInWorkingCopy(IWorkingCopy workingCopy, IJavaElement element, boolean reconcile) throws JavaModelException {
        if (workingCopy != null) {
            if (reconcile) {
                IWorkingCopy iWorkingCopy = workingCopy;
                synchronized (iWorkingCopy) {
                    workingCopy.reconcile();
                    return SearchUtil.findInCompilationUnit((ICompilationUnit)workingCopy, element);
                }
            }
            return SearchUtil.findInCompilationUnit((ICompilationUnit)workingCopy, element);
        }
        return null;
    }

    static ICompilationUnit findCompilationUnit(IJavaElement element) {
        if (element == null) {
            return null;
        }
        if (element.getElementType() == 5) {
            return (ICompilationUnit)element;
        }
        if (element instanceof IMember) {
            return ((IMember)element).getCompilationUnit();
        }
        return SearchUtil.findCompilationUnit(element.getParent());
    }

    public static IMember findInCompilationUnit(ICompilationUnit cu, IMember member) throws JavaModelException {
        if (member.getElementType() == 7) {
            return JavaModelUtil.findTypeInCompilationUnit(cu, JavaModelUtil.getTypeQualifiedName((IType)member));
        }
        IType declaringType = JavaModelUtil.findTypeInCompilationUnit(cu, JavaModelUtil.getTypeQualifiedName(member.getDeclaringType()));
        if (declaringType != null) {
            IInitializer result = null;
            switch (member.getElementType()) {
                case 8: {
                    result = declaringType.getField(member.getElementName());
                    break;
                }
                case 9: {
                    IMethod meth = (IMethod)member;
                    boolean isConstructor = meth.exists() ? meth.isConstructor() : declaringType.getElementName().equals(meth.getElementName());
                    result = JavaModelUtil.findMethod(meth.getElementName(), meth.getParameterTypes(), isConstructor, declaringType);
                    break;
                }
                case 10: {
                    result = declaringType.getInitializer(1);
                }
            }
            if (result != null && result.exists()) {
                return result;
            }
        }
        return null;
    }

    public static IJavaElement findInCompilationUnit(ICompilationUnit cu, IJavaElement element) throws JavaModelException {
        if (element instanceof IMember) {
            return SearchUtil.findInCompilationUnit(cu, (IMember)element);
        }
        int type = element.getElementType();
        switch (type) {
            case 12: {
                return cu.getImportContainer();
            }
            case 11: {
                return SearchUtil.find((IJavaElement[])cu.getPackageDeclarations(), element.getElementName());
            }
            case 13: {
                return SearchUtil.find((IJavaElement[])cu.getImports(), element.getElementName());
            }
            case 5: {
                return cu;
            }
        }
        return null;
    }

    private static IJavaElement find(IJavaElement[] elements, String name) {
        if (elements == null || name == null) {
            return null;
        }
        int i = 0;
        while (i < elements.length) {
            if (name.equals(elements[i].getElementName())) {
                return elements[i];
            }
            ++i;
        }
        return null;
    }

    public static String toString(IWorkingSet[] workingSets) {
        Arrays.sort(workingSets, new WorkingSetComparator());
        String result = "";
        if (workingSets != null && workingSets.length > 0) {
            boolean firstFound = false;
            int i = 0;
            while (i < workingSets.length) {
                String workingSetName = workingSets[i].getName();
                if (firstFound) {
                    result = SearchMessages.getFormattedString("SearchUtil.workingSetConcatenation", new String[]{result, workingSetName});
                } else {
                    result = workingSetName;
                    firstFound = true;
                }
                ++i;
            }
        }
        return result;
    }

    public static void updateLRUWorkingSets(IWorkingSet[] workingSets) {
        if (workingSets == null || workingSets.length < 1) {
            return;
        }
        SearchUtil.getLRUWorkingSets().add(workingSets);
        SearchUtil.saveState();
    }

    private static void saveState() {
        Iterator iter = fgLRUWorkingSets.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IWorkingSet[] workingSets = (IWorkingSet[])iter.next();
            String[] names = new String[workingSets.length];
            int j = 0;
            while (j < workingSets.length) {
                names[j] = workingSets[j].getName();
                ++j;
            }
            fgSettingsStore.put(STORE_LRU_WORKING_SET_NAMES + i, names);
            ++i;
        }
    }

    public static LRUWorkingSetsList getLRUWorkingSets() {
        if (fgLRUWorkingSets == null) {
            SearchUtil.restoreState();
        }
        return fgLRUWorkingSets;
    }

    static void restoreState() {
        fgLRUWorkingSets = new LRUWorkingSetsList(LRU_WORKINGSET_LIST_SIZE);
        fgSettingsStore = JavaPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (fgSettingsStore == null) {
            fgSettingsStore = JavaPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        boolean foundLRU = false;
        int i = LRU_WORKINGSET_LIST_SIZE - 1;
        while (i >= 0) {
            String[] lruWorkingSetNames = fgSettingsStore.getArray(STORE_LRU_WORKING_SET_NAMES + i);
            if (lruWorkingSetNames != null) {
                HashSet<IWorkingSet> workingSets = new HashSet<IWorkingSet>(2);
                int j = 0;
                while (j < lruWorkingSetNames.length) {
                    IWorkingSet workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(lruWorkingSetNames[j]);
                    if (workingSet != null) {
                        workingSets.add(workingSet);
                    }
                    ++j;
                }
                foundLRU = true;
                if (!workingSets.isEmpty()) {
                    fgLRUWorkingSets.add(workingSets.toArray(new IWorkingSet[workingSets.size()]));
                }
            }
            --i;
        }
        if (!foundLRU) {
            SearchUtil.restoreFromOldFormat();
        }
    }

    private static void restoreFromOldFormat() {
        fgLRUWorkingSets = new LRUWorkingSetsList(LRU_WORKINGSET_LIST_SIZE);
        fgSettingsStore = JavaPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (fgSettingsStore == null) {
            fgSettingsStore = JavaPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        boolean foundLRU = false;
        String[] lruWorkingSetNames = fgSettingsStore.getArray(STORE_LRU_WORKING_SET_NAMES);
        if (lruWorkingSetNames != null) {
            int i = lruWorkingSetNames.length - 1;
            while (i >= 0) {
                IWorkingSet workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(lruWorkingSetNames[i]);
                if (workingSet != null) {
                    foundLRU = true;
                    fgLRUWorkingSets.add(new IWorkingSet[]{workingSet});
                }
                --i;
            }
        }
        if (foundLRU) {
            SearchUtil.saveState();
        }
    }

    public static void warnIfBinaryConstant(IJavaElement element, Shell shell) {
        if (SearchUtil.isBinaryPrimitveConstantOrString(element)) {
            OptionalMessageDialog.open(BIN_PRIM_CONST_WARN_DIALOG_ID, shell, SearchMessages.getString("Search.FindReferencesAction.BinPrimConstWarnDialog.title"), null, SearchMessages.getString("Search.FindReferencesAction.BinPrimConstWarnDialog.message"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        }
    }

    private static boolean isBinaryPrimitveConstantOrString(IJavaElement element) {
        if (element != null && element.getElementType() == 8) {
            int flags;
            IField field = (IField)element;
            try {
                flags = field.getFlags();
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
            return field.isBinary() && Flags.isStatic((int)flags) && Flags.isFinal((int)flags) && SearchUtil.isPrimitiveOrString(field);
        }
        return false;
    }

    private static boolean isPrimitiveOrString(IField field) {
        block10: {
            block9: {
                String fieldType;
                try {
                    fieldType = field.getTypeSignature();
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
                char first = fieldType.charAt(0);
                if (first != 'L' && first != 'Q' && first != '[') break block9;
                if (first != 'L') break block10;
                String string = fieldType.substring(1, fieldType.length() - 1);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!string.equals(clazz.getName())) break block10;
            }
            return true;
        }
        return false;
    }
}

