/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class PrettySignature {
    public static String getSignature(IJavaElement element) {
        if (element == null) {
            return null;
        }
        switch (element.getElementType()) {
            case 9: {
                return PrettySignature.getMethodSignature((IMethod)element);
            }
            case 7: {
                return JavaModelUtil.getFullyQualifiedName((IType)element);
            }
        }
        return element.getElementName();
    }

    public static String getMethodSignature(IMethod method) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(JavaModelUtil.getFullyQualifiedName(method.getDeclaringType()));
        buffer.append('.');
        buffer.append(PrettySignature.getUnqualifiedMethodSignature(method));
        return buffer.toString();
    }

    public static String getUnqualifiedTypeSignature(IType type) {
        return type.getElementName();
    }

    public static String getUnqualifiedMethodSignature(IMethod method) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(method.getElementName());
        buffer.append('(');
        String[] types = method.getParameterTypes();
        if (types.length > 0) {
            buffer.append(Signature.toString((String)types[0]));
        }
        int i = 1;
        while (i < types.length) {
            buffer.append(", ");
            buffer.append(Signature.toString((String)types[i]));
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }
}

