/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class OccurrencesFinder
extends ASTVisitor {
    private IBinding fTarget;
    private List fUsages = new ArrayList();
    private List fWriteUsages = new ArrayList();

    public OccurrencesFinder(IBinding target) {
        this.fTarget = target;
    }

    public List getUsages() {
        return this.fUsages;
    }

    public List getWriteUsages() {
        return this.fWriteUsages;
    }

    public boolean visit(QualifiedName node) {
        this.match((Name)node, this.fUsages);
        return super.visit(node);
    }

    public boolean visit(SimpleName node) {
        this.match((Name)node, this.fUsages);
        return super.visit(node);
    }

    public boolean visit(Assignment node) {
        Expression lhs = node.getLeftHandSide();
        Name name = this.getName(lhs);
        if (name != null) {
            this.match(name, this.fWriteUsages);
        }
        lhs.accept((ASTVisitor)this);
        node.getRightHandSide().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        if (node.getInitializer() != null) {
            this.match((Name)node.getName(), this.fWriteUsages);
        }
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (node.getInitializer() != null) {
            this.match((Name)node.getName(), this.fWriteUsages);
        }
        return super.visit(node);
    }

    public boolean visit(PrefixExpression node) {
        Expression operand;
        Name name;
        PrefixExpression.Operator operator = node.getOperator();
        if ((operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) && (name = this.getName(operand = node.getOperand())) != null) {
            this.match(name, this.fWriteUsages);
        }
        return super.visit(node);
    }

    public boolean visit(PostfixExpression node) {
        Expression operand = node.getOperand();
        Name name = this.getName(operand);
        if (name != null) {
            this.match(name, this.fWriteUsages);
        }
        return super.visit(node);
    }

    private void match(Name node, List result) {
        IBinding binding = node.resolveBinding();
        if (binding == null) {
            return;
        }
        if (binding.equals((Object)this.fTarget)) {
            result.add(node);
            return;
        }
        String otherKey = binding.getKey();
        String targetKey = this.fTarget.getKey();
        if (targetKey != null && otherKey != null && targetKey.equals(otherKey)) {
            result.add(node);
        }
    }

    private Name getName(Expression expression) {
        if (expression instanceof SimpleName) {
            return (SimpleName)expression;
        }
        if (expression instanceof QualifiedName) {
            return (QualifiedName)expression;
        }
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).getName();
        }
        return null;
    }
}

