/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jdt.internal.ui.search.WorkingSetsComparator;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class LRUWorkingSetsList {
    private final ArrayList fLRUList;
    private final int fSize;
    private final WorkingSetsComparator fComparator = new WorkingSetsComparator();

    public LRUWorkingSetsList(int size) {
        this.fSize = size;
        this.fLRUList = new ArrayList(size);
    }

    public void add(IWorkingSet[] workingSets) {
        this.removeDeletedWorkingSets();
        IWorkingSet[] existingWorkingSets = this.find(this.fLRUList, workingSets);
        if (existingWorkingSets != null) {
            ((AbstractCollection)this.fLRUList).remove(existingWorkingSets);
        } else if (this.fLRUList.size() == this.fSize) {
            this.fLRUList.remove(this.fSize - 1);
        }
        this.fLRUList.add(0, workingSets);
    }

    public Iterator iterator() {
        this.removeDeletedWorkingSets();
        return ((AbstractList)this.fLRUList).iterator();
    }

    public Iterator sortedIterator() {
        this.removeDeletedWorkingSets();
        ArrayList sortedList = new ArrayList(this.fLRUList);
        Collections.sort(sortedList, this.fComparator);
        return ((AbstractList)sortedList).iterator();
    }

    private void removeDeletedWorkingSets() {
        Iterator iter = ((AbstractList)new ArrayList(this.fLRUList)).iterator();
        block0: while (iter.hasNext()) {
            IWorkingSet[] workingSets = (IWorkingSet[])iter.next();
            int i = 0;
            while (i < workingSets.length) {
                if (PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(workingSets[i].getName()) == null) {
                    ((AbstractCollection)this.fLRUList).remove(workingSets);
                    continue block0;
                }
                ++i;
            }
        }
    }

    private IWorkingSet[] find(ArrayList list, IWorkingSet[] workingSets) {
        HashSet<IWorkingSet> workingSetList = new HashSet<IWorkingSet>(Arrays.asList(workingSets));
        Iterator iter = ((AbstractList)list).iterator();
        while (iter.hasNext()) {
            IWorkingSet[] lruWorkingSets = (IWorkingSet[])iter.next();
            HashSet<IWorkingSet> lruWorkingSetList = new HashSet<IWorkingSet>(Arrays.asList(lruWorkingSets));
            if (!lruWorkingSetList.equals(workingSetList)) continue;
            return lruWorkingSets;
        }
        return null;
    }
}

