/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class JavaSearchScopeFactory {
    private static JavaSearchScopeFactory fgInstance;
    private static IJavaSearchScope EMPTY_SCOPE;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        EMPTY_SCOPE = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[0]);
    }

    private JavaSearchScopeFactory() {
    }

    public static JavaSearchScopeFactory getInstance() {
        if (fgInstance == null) {
            fgInstance = new JavaSearchScopeFactory();
        }
        return fgInstance;
    }

    public IWorkingSet[] queryWorkingSets() throws JavaModelException {
        IWorkingSet[] workingSets;
        Shell shell = JavaPlugin.getActiveWorkbenchShell();
        if (shell == null) {
            return null;
        }
        IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(shell, true);
        if (dialog.open() == 0 && (workingSets = dialog.getSelection()).length > 0) {
            return workingSets;
        }
        return null;
    }

    public IJavaSearchScope createJavaSearchScope(IWorkingSet[] workingSets) {
        if (workingSets == null || workingSets.length < 1) {
            return EMPTY_SCOPE;
        }
        HashSet javaElements = new HashSet(workingSets.length * 10);
        int i = 0;
        while (i < workingSets.length) {
            this.addJavaElements(javaElements, workingSets[i]);
            ++i;
        }
        return this.createJavaSearchScope(javaElements);
    }

    public IJavaSearchScope createJavaSearchScope(IWorkingSet workingSet) {
        HashSet javaElements = new HashSet(10);
        this.addJavaElements(javaElements, workingSet);
        return this.createJavaSearchScope(javaElements);
    }

    public IJavaSearchScope createJavaSearchScope(IResource[] resources) {
        if (resources == null) {
            return EMPTY_SCOPE;
        }
        HashSet javaElements = new HashSet(resources.length);
        this.addJavaElements(javaElements, resources);
        return this.createJavaSearchScope(javaElements);
    }

    public IJavaSearchScope createJavaSearchScope(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            HashSet javaElements = new HashSet(((IStructuredSelection)selection).size());
            while (iter.hasNext()) {
                IResource resource;
                Object selectedElement = iter.next();
                if (selectedElement instanceof ISearchResultViewEntry) {
                    selectedElement = ((ISearchResultViewEntry)selectedElement).getGroupByKey();
                }
                if (selectedElement instanceof IJavaElement) {
                    this.addJavaElements(javaElements, (IJavaElement)selectedElement);
                    continue;
                }
                if (selectedElement instanceof IResource) {
                    this.addJavaElements(javaElements, (IAdaptable)((IResource)selectedElement));
                    continue;
                }
                if (selectedElement instanceof LogicalPackage) {
                    this.addJavaElements(javaElements, (LogicalPackage)((Object)selectedElement));
                    continue;
                }
                if (!(selectedElement instanceof IAdaptable)) continue;
                IAdaptable iAdaptable = (IAdaptable)selectedElement;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) continue;
                this.addJavaElements(javaElements, (IAdaptable)resource);
            }
            return this.createJavaSearchScope(javaElements);
        }
        return EMPTY_SCOPE;
    }

    private IJavaSearchScope createJavaSearchScope(Set javaElements) {
        return SearchEngine.createJavaSearchScope((IJavaElement[])javaElements.toArray(new IJavaElement[javaElements.size()]));
    }

    private void addJavaElements(Set javaElements, IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.addJavaElements(javaElements, (IAdaptable)resources[i]);
            ++i;
        }
    }

    private void addJavaElements(Set javaElements, IAdaptable resource) {
        IJavaElement javaElement;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((javaElement = (IJavaElement)resource.getAdapter((Class)clazz)) == null) {
            return;
        }
        if (javaElement.getElementType() == 4) {
            try {
                this.addJavaElements(javaElements, ((IFolder)resource).members());
            }
            catch (CoreException coreException) {}
        }
        this.addJavaElements(javaElements, javaElement);
    }

    private void addJavaElements(Set javaElements, IJavaElement javaElement) {
        switch (javaElement.getElementType()) {
            case 2: {
                this.addJavaElements(javaElements, (IJavaProject)javaElement);
                break;
            }
            default: {
                javaElements.add(javaElement);
            }
        }
    }

    private void addJavaElements(Set javaElements, IJavaProject javaProject) {
        IPackageFragmentRoot[] roots;
        try {
            roots = javaProject.getPackageFragmentRoots();
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        int i = 0;
        while (i < roots.length) {
            if (!roots[i].isExternal()) {
                javaElements.add(roots[i]);
            }
            ++i;
        }
    }

    private void addJavaElements(Set javaElements, IWorkingSet workingSet) {
        if (workingSet == null) {
            return;
        }
        IAdaptable[] elements = workingSet.getElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IJavaElement) {
                this.addJavaElements(javaElements, (IJavaElement)elements[i]);
            } else {
                this.addJavaElements(javaElements, elements[i]);
            }
            ++i;
        }
    }

    public void addJavaElements(Set javaElements, LogicalPackage selectedElement) {
        IPackageFragment[] packages = selectedElement.getFragments();
        int i = 0;
        while (i < packages.length) {
            this.addJavaElements(javaElements, (IJavaElement)packages[i]);
            ++i;
        }
    }
}

