/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.search.JavaSearchResultCollector;
import org.eclipse.jdt.internal.ui.search.PrettySignature;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class JavaSearchOperation
extends WorkspaceModifyOperation {
    private IWorkspace fWorkspace;
    private IJavaElement fElementPattern;
    private int fLimitTo;
    private String fStringPattern;
    private boolean fIsCaseSensitive;
    private int fSearchFor;
    private IJavaSearchScope fScope;
    private String fScopeDescription;
    private JavaSearchResultCollector fCollector;

    protected JavaSearchOperation(IWorkspace workspace, int limitTo, IJavaSearchScope scope, String scopeDescription, JavaSearchResultCollector collector) {
        this.fWorkspace = workspace;
        this.fLimitTo = limitTo;
        this.fScope = scope;
        this.fScopeDescription = scopeDescription;
        this.fCollector = collector;
        this.fCollector.setOperation(this);
    }

    public JavaSearchOperation(IWorkspace workspace, IJavaElement pattern, int limitTo, IJavaSearchScope scope, String scopeDescription, JavaSearchResultCollector collector) {
        this(workspace, limitTo, scope, scopeDescription, collector);
        this.fElementPattern = pattern;
    }

    public JavaSearchOperation(IWorkspace workspace, String pattern, boolean caseSensitive, int searchFor, int limitTo, IJavaSearchScope scope, String scopeDescription, JavaSearchResultCollector collector) {
        this(workspace, limitTo, scope, scopeDescription, collector);
        this.fStringPattern = pattern;
        this.fIsCaseSensitive = caseSensitive;
        this.fSearchFor = searchFor;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException {
        this.fCollector.setProgressMonitor(monitor);
        SearchEngine engine = new SearchEngine(JavaUI.getSharedWorkingCopiesOnClasspath());
        if (this.fElementPattern != null) {
            engine.search(this.fWorkspace, this.fElementPattern, this.fLimitTo, this.fScope, (IJavaSearchResultCollector)this.fCollector);
        } else {
            engine.search(this.fWorkspace, SearchEngine.createSearchPattern((String)this.fStringPattern, (int)this.fSearchFor, (int)this.fLimitTo, (boolean)this.fIsCaseSensitive), this.fScope, (IJavaSearchResultCollector)this.fCollector);
        }
    }

    String getSingularLabel() {
        String desc = null;
        if (this.fElementPattern != null) {
            desc = this.fLimitTo == 2 && this.fElementPattern.getElementType() == 9 ? PrettySignature.getUnqualifiedMethodSignature((IMethod)this.fElementPattern) : this.fElementPattern.getElementName();
            if ("".equals(desc) && this.fElementPattern.getElementType() == 4) {
                desc = SearchMessages.getString("JavaSearchOperation.default_package");
            }
        } else {
            desc = this.fStringPattern;
        }
        Object[] args = new String[]{desc, this.fScopeDescription};
        switch (this.fLimitTo) {
            case 1: {
                return SearchMessages.getFormattedString("JavaSearchOperation.singularImplementorsPostfix", args);
            }
            case 0: {
                return SearchMessages.getFormattedString("JavaSearchOperation.singularDeclarationsPostfix", args);
            }
            case 2: {
                return SearchMessages.getFormattedString("JavaSearchOperation.singularReferencesPostfix", args);
            }
            case 3: {
                return SearchMessages.getFormattedString("JavaSearchOperation.singularOccurrencesPostfix", args);
            }
            case 4: {
                return SearchMessages.getFormattedString("JavaSearchOperation.singularReadReferencesPostfix", args);
            }
            case 5: {
                return SearchMessages.getFormattedString("JavaSearchOperation.singularWriteReferencesPostfix", args);
            }
        }
        return SearchMessages.getFormattedString("JavaSearchOperation.singularOccurrencesPostfix", args);
    }

    String getPluralLabelPattern() {
        String desc = null;
        if (this.fElementPattern != null) {
            desc = this.fLimitTo == 2 && this.fElementPattern.getElementType() == 9 ? PrettySignature.getUnqualifiedMethodSignature((IMethod)this.fElementPattern) : this.fElementPattern.getElementName();
            if ("".equals(desc) && this.fElementPattern.getElementType() == 4) {
                desc = SearchMessages.getString("JavaSearchOperation.default_package");
            }
        } else {
            desc = this.fStringPattern;
        }
        Object[] args = new String[]{desc, "{0}", this.fScopeDescription};
        switch (this.fLimitTo) {
            case 1: {
                return SearchMessages.getFormattedString("JavaSearchOperation.pluralImplementorsPostfix", args);
            }
            case 0: {
                return SearchMessages.getFormattedString("JavaSearchOperation.pluralDeclarationsPostfix", args);
            }
            case 2: {
                return SearchMessages.getFormattedString("JavaSearchOperation.pluralReferencesPostfix", args);
            }
            case 3: {
                return SearchMessages.getFormattedString("JavaSearchOperation.pluralOccurrencesPostfix", args);
            }
            case 4: {
                return SearchMessages.getFormattedString("JavaSearchOperation.pluralReadReferencesPostfix", args);
            }
            case 5: {
                return SearchMessages.getFormattedString("JavaSearchOperation.pluralWriteReferencesPostfix", args);
            }
        }
        return SearchMessages.getFormattedString("JavaSearchOperation.pluralOccurrencesPostfix", args);
    }

    ImageDescriptor getImageDescriptor() {
        if (this.fLimitTo == 1 || this.fLimitTo == 0) {
            return JavaPluginImages.DESC_OBJS_SEARCH_DECL;
        }
        return JavaPluginImages.DESC_OBJS_SEARCH_REF;
    }
}

