/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.search.GotoMarkerAction;
import org.eclipse.jdt.internal.ui.search.OccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.OccurrencesInFileLabelProvider;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.ui.IGroupByKeyComputer;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.texteditor.MarkerUtilities;

public abstract class FindOccurrencesEngine {
    public static final String IS_WRITEACCESS = "writeAccess";
    public static final String IS_VARIABLE = "variable";
    private IRunnableWithProgress fNullOperation = this.getNullOperation();

    public static FindOccurrencesEngine create(IJavaElement root) {
        ICompilationUnit unit = (ICompilationUnit)root.getAncestor(5);
        if (unit != null) {
            return new FindOccurencesCUEngine(unit);
        }
        IClassFile cf = (IClassFile)root.getAncestor(6);
        if (cf != null) {
            return new FindOccurencesClassFileEngine(cf);
        }
        return null;
    }

    protected abstract CompilationUnit createAST();

    protected abstract IJavaElement getInput();

    protected abstract ISourceReference getSourceReference();

    protected abstract IResource getMarkerOwner() throws JavaModelException;

    protected abstract void addSpecialAttributes(Map var1) throws JavaModelException;

    public String run(int offset, int length) throws JavaModelException {
        ISourceReference sr = this.getSourceReference();
        if (sr.getSourceRange() == null) {
            return SearchMessages.getString("FindOccurrencesEngine.noSource.text");
        }
        final CompilationUnit root = this.createAST();
        if (root == null) {
            return SearchMessages.getString("FindOccurrencesEngine.cannotParse.text");
        }
        final Name name = this.getNameNode(root, offset, length);
        if (name == null) {
            return SearchMessages.getString("FindOccurrencesEngine.noJavaElement.text");
        }
        final IBinding target = name.resolveBinding();
        Document document = new Document(this.getSourceReference().getSource());
        if (target == null) {
            return null;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable((IDocument)document){
            private final /* synthetic */ IDocument val$document;
            {
                this.val$document = iDocument;
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                IJavaElement element = FindOccurrencesEngine.this.getInput();
                ISearchResultView view = FindOccurrencesEngine.this.startSearch(element.getElementName(), name);
                OccurrencesFinder finder = new OccurrencesFinder(target);
                root.accept((ASTVisitor)finder);
                List matches = finder.getUsages();
                List writeMatches = finder.getWriteUsages();
                IResource file = FindOccurrencesEngine.this.getMarkerOwner();
                Iterator each = matches.iterator();
                while (each.hasNext()) {
                    ASTNode node = (ASTNode)each.next();
                    FindOccurrencesEngine.this.addMatch(view, file, FindOccurrencesEngine.this.createMarker(file, this.val$document, node, writeMatches.contains(node), target instanceof IVariableBinding));
                }
                FindOccurrencesEngine.this.searchFinished(view);
            }
        };
        this.run(runnable);
        return null;
    }

    public Name getNameNode(CompilationUnit root, int offset, int length) {
        ASTNode node = NodeFinder.perform((ASTNode)root, offset, length);
        if (node instanceof Name) {
            return (Name)node;
        }
        Name name = NameNodeFinder.perform(node);
        if (name == null || name.getStartPosition() != node.getStartPosition() || name.getLength() != node.getLength()) {
            return null;
        }
        return name;
    }

    private ISearchResultView startSearch(String fileName, Name name) {
        SearchUI.activateSearchResultView();
        ISearchResultView view = SearchUI.getSearchResultView();
        String elementName = ASTNodes.asString((ASTNode)name);
        if (view != null) {
            view.searchStarted(null, this.getSingularLabel(elementName, fileName), this.getPluralLabel(elementName, fileName), JavaPluginImages.DESC_OBJS_SEARCH_REF, "org.eclipse.jdt.ui.JavaFileSearch", (ILabelProvider)new OccurrencesInFileLabelProvider(), (IAction)new GotoMarkerAction(), (IGroupByKeyComputer)new SearchGroupByKeyComputer(), null);
        }
        return view;
    }

    private void addMatch(ISearchResultView view, IResource file, IMarker marker) {
        if (view != null) {
            view.addMatch("", this.getGroupByKey(marker), file, marker);
        }
    }

    private void searchFinished(ISearchResultView view) {
        if (view != null) {
            view.searchFinished();
        }
    }

    private Object getGroupByKey(IMarker marker) {
        try {
            return marker.getAttribute("lineNumber");
        }
        catch (CoreException coreException) {
            return marker;
        }
    }

    private IMarker createMarker(IResource file, IDocument document, ASTNode element, boolean writeAccess, boolean isVariable) throws CoreException {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>(10);
        IMarker marker = file.createMarker("org.eclipse.search.searchmarker");
        int startPosition = element.getStartPosition();
        MarkerUtilities.setCharStart(attributes, (int)startPosition);
        MarkerUtilities.setCharEnd(attributes, (int)(startPosition + element.getLength()));
        this.addSpecialAttributes(attributes);
        if (writeAccess) {
            attributes.put(IS_WRITEACCESS, new Boolean(true));
        }
        if (isVariable) {
            attributes.put(IS_VARIABLE, new Boolean(true));
        }
        try {
            int line = document.getLineOfOffset(startPosition);
            MarkerUtilities.setLineNumber(attributes, (int)line);
            IRegion region = document.getLineInformation(line);
            String lineContents = document.get(region.getOffset(), region.getLength());
            MarkerUtilities.setMessage(attributes, (String)lineContents.trim());
        }
        catch (BadLocationException badLocationException) {}
        marker.setAttributes(attributes);
        return marker;
    }

    private String getPluralLabel(String nodeContents, String elementName) {
        Object[] args = new String[]{nodeContents, "{0}", elementName};
        return SearchMessages.getFormattedString("JavaSearchInFile.pluralPostfix", args);
    }

    private String getSingularLabel(String nodeContents, String elementName) {
        Object[] args = new String[]{nodeContents, elementName};
        return SearchMessages.getFormattedString("JavaSearchInFile.singularPostfix", args);
    }

    private void run(final IWorkspaceRunnable runnable) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    JavaCore.run((IWorkspaceRunnable)runnable, null);
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
            }
        });
    }

    private IRunnableWithProgress getNullOperation() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            }
        };
    }

    private static class SearchGroupByKeyComputer
    implements IGroupByKeyComputer {
        SearchGroupByKeyComputer() {
        }

        public Object computeGroupByKey(IMarker marker) {
            return marker;
        }
    }

    private static class NameNodeFinder
    extends ASTVisitor {
        Name result;

        NameNodeFinder() {
        }

        public static Name perform(ASTNode root) {
            NameNodeFinder finder = new NameNodeFinder();
            root.accept((ASTVisitor)finder);
            return finder.result;
        }

        public boolean visit(SimpleName node) {
            this.result = node;
            return false;
        }

        public boolean visit(QualifiedName node) {
            this.result = node;
            return false;
        }
    }

    private static class FindOccurencesClassFileEngine
    extends FindOccurrencesEngine {
        private IClassFile fClassFile;

        public FindOccurencesClassFileEngine(IClassFile file) {
            this.fClassFile = file;
        }

        protected CompilationUnit createAST() {
            return AST.parseCompilationUnit((IClassFile)this.fClassFile, (boolean)true);
        }

        protected IJavaElement getInput() {
            return this.fClassFile;
        }

        protected IResource getMarkerOwner() {
            return this.fClassFile.getJavaProject().getProject();
        }

        protected void addSpecialAttributes(Map attributes) throws JavaModelException {
            attributes.put("org.eclipse.ui.editorID", "org.eclipse.jdt.ui.ClassFileEditor");
            JavaCore.addJavaElementMarkerAttributes((Map)attributes, (IJavaElement)this.fClassFile.getType());
            attributes.put("org.eclipse.jdt.internal.ui.search.handleID", this.fClassFile.getType().getHandleIdentifier());
        }

        protected ISourceReference getSourceReference() {
            return this.fClassFile;
        }
    }

    private static class FindOccurencesCUEngine
    extends FindOccurrencesEngine {
        private ICompilationUnit fCUnit;

        public FindOccurencesCUEngine(ICompilationUnit unit) {
            this.fCUnit = unit;
        }

        protected CompilationUnit createAST() {
            return AST.parseCompilationUnit((ICompilationUnit)this.fCUnit, (boolean)true);
        }

        protected IJavaElement getInput() {
            return this.fCUnit;
        }

        protected IResource getMarkerOwner() throws JavaModelException {
            ICompilationUnit original = WorkingCopyUtil.getOriginal(this.fCUnit);
            return original.getUnderlyingResource();
        }

        protected void addSpecialAttributes(Map attributes) {
        }

        protected ISourceReference getSourceReference() {
            return this.fCUnit;
        }
    }
}

