/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jface.viewers.IStructuredSelection;

class StructuredSelectionUtil {
    private static final IResource[] EMPTY = new IResource[0];

    private StructuredSelectionUtil() {
    }

    static boolean hasNonResources(IStructuredSelection ss) {
        Iterator iter = ss.iterator();
        while (iter.hasNext()) {
            if (ResourceUtil.getResource(iter.next()) != null) continue;
            return true;
        }
        return false;
    }

    static IResource[] getResources(IStructuredSelection ss) {
        if (ss == null || ss.isEmpty()) {
            return EMPTY;
        }
        List selectedResources = StructuredSelectionUtil.getResourceList(ss);
        return selectedResources.toArray(new IResource[selectedResources.size()]);
    }

    private static List getResourceList(IStructuredSelection ss) {
        ArrayList<IResource> result = new ArrayList<IResource>(0);
        Iterator iter = ss.iterator();
        while (iter.hasNext()) {
            IResource resource = ResourceUtil.getResource(iter.next());
            if (resource == null) continue;
            result.add(resource);
        }
        return result;
    }
}

