/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceReferenceUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;

public abstract class SourceReferenceAction
extends SelectionDispatchAction {
    private static final ISourceRange fgUnknownRange = new SourceRange(-1, 0);

    protected SourceReferenceAction(IWorkbenchSite site) {
        super(site);
    }

    protected ISourceReference[] getElementsToProcess(IStructuredSelection selection) {
        return SourceReferenceUtil.removeAllWithParentsSelected(this.getSelectedElements(selection));
    }

    public final void run(final IStructuredSelection selection) {
        BusyIndicator.showWhile((Display)JavaPlugin.getActiveWorkbenchShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    SourceReferenceAction.this.perform(selection);
                }
                catch (CoreException e) {
                    ExceptionHandler.handle(e, SourceReferenceAction.this.getText(), ReorgMessages.getString("SourceReferenceAction.exception"));
                }
            }
        });
    }

    protected abstract void perform(IStructuredSelection var1) throws CoreException;

    private boolean canOperateOn(IStructuredSelection selection) {
        try {
            if (selection.isEmpty()) {
                return false;
            }
            Object[] elems = selection.toArray();
            int i = 0;
            while (i < elems.length) {
                Object elem = elems[i];
                if (!this.canWorkOn(elem)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            return false;
        }
    }

    private ISourceReference[] getSelectedElements(IStructuredSelection selection) {
        return SourceReferenceAction.getWorkingCopyElements(selection.toList());
    }

    protected boolean canWorkOn(Object elem) throws JavaModelException {
        IMember member;
        if (elem == null) {
            return false;
        }
        if (!(elem instanceof ISourceReference)) {
            return false;
        }
        if (!(elem instanceof IJavaElement)) {
            return false;
        }
        if (elem instanceof IClassFile) {
            return false;
        }
        if (elem instanceof ICompilationUnit) {
            return false;
        }
        if (elem instanceof IMember && (member = (IMember)elem).isBinary() && (member.getSourceRange() == null || fgUnknownRange.equals(member.getSourceRange()))) {
            return false;
        }
        if (SourceReferenceAction.isDeletedFromEditor((ISourceReference)elem)) {
            return false;
        }
        if (elem instanceof IMember) {
            return true;
        }
        if (elem instanceof IImportContainer) {
            return true;
        }
        if (elem instanceof IImportDeclaration) {
            return true;
        }
        return elem instanceof IPackageDeclaration;
    }

    private static boolean isDeletedFromEditor(ISourceReference elem) throws JavaModelException {
        if (elem instanceof IMember && ((IMember)elem).isBinary()) {
            return false;
        }
        ICompilationUnit cu = SourceReferenceUtil.getCompilationUnit(elem);
        ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(cu);
        if (wc.equals(cu)) {
            return false;
        }
        IJavaElement element = (IJavaElement)elem;
        IJavaElement wcElement = JavaModelUtil.findInCompilationUnit(wc, element);
        return wcElement == null || !wcElement.exists();
    }

    private static ISourceReference[] getWorkingCopyElements(List l) {
        ArrayList<Object> wcList = new ArrayList<Object>(l.size());
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            ICompilationUnit cu;
            ISourceReference element = (ISourceReference)iter.next();
            if (!(element instanceof IJavaElement)) {
                wcList.add(element);
            }
            if ((cu = SourceReferenceUtil.getCompilationUnit(element)) == null) {
                wcList.add(element);
                continue;
            }
            if (cu.isWorkingCopy()) {
                wcList.add(element);
                continue;
            }
            ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(cu);
            try {
                IJavaElement wcElement = JavaModelUtil.findInCompilationUnit(wc, (IJavaElement)element);
                if (wcElement == null || !wcElement.exists()) continue;
                wcList.add(wcElement);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return wcList.toArray(new ISourceReference[wcList.size()]);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canOperateOn(selection));
    }
}

