/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenamePackageRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICopyQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.reorg.ReorgMessages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ReorgQueries
implements ICopyQueries {
    private static final String EMPTY = " ";

    private static String removeTrailingJava(String name) {
        Assert.isTrue(name.endsWith(".java"));
        return name.substring(0, name.length() - ".java".length());
    }

    public INewNameQuery createNewCompilationUnitNameQuery(ICompilationUnit cu) {
        String[] keys = new String[]{ReorgQueries.removeTrailingJava(cu.getElementName())};
        String message = ReorgMessages.getFormattedString("ReorgQueries.enterNewNameQuestion", keys);
        return ReorgQueries.createStaticQuery(ReorgQueries.createCompilationUnitNameValidator(cu), message, ReorgQueries.removeTrailingJava(cu.getElementName()));
    }

    public INewNameQuery createNewResourceNameQuery(IResource res) {
        String[] keys = new String[]{res.getName()};
        String message = ReorgMessages.getFormattedString("ReorgQueries.enterNewNameQuestion", keys);
        return ReorgQueries.createStaticQuery(ReorgQueries.createResourceNameValidator(res), message, res.getName());
    }

    public INewNameQuery createNewPackageNameQuery(IPackageFragment pack) {
        String[] keys = new String[]{pack.getElementName()};
        String message = ReorgMessages.getFormattedString("ReorgQueries.enterNewNameQuestion", keys);
        return ReorgQueries.createStaticQuery(ReorgQueries.createPackageNameValidator(pack), message, pack.getElementName());
    }

    public INewNameQuery createNullQuery() {
        return this.createStaticQuery(null);
    }

    public INewNameQuery createStaticQuery(final String newName) {
        return new INewNameQuery(){

            public String getNewName() {
                return newName;
            }
        };
    }

    private static INewNameQuery createStaticQuery(final IInputValidator validator, final String message, final String initial) {
        return new INewNameQuery(){

            public String getNewName() {
                InputDialog dialog = new InputDialog(JavaPlugin.getActiveWorkbenchShell(), ReorgMessages.getString("ReorgQueries.nameConflictMessage"), message, initial, validator);
                if (dialog.open() == 1) {
                    throw new OperationCanceledException();
                }
                return dialog.getValue();
            }
        };
    }

    private static IInputValidator createResourceNameValidator(final IResource res) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || "".equals(newText) || res.getParent() == null) {
                    return ReorgQueries.EMPTY;
                }
                if (res.getParent().findMember(newText) != null) {
                    return ReorgMessages.getString("ReorgQueries.resourceWithThisNameAlreadyExists");
                }
                if (!res.getParent().getFullPath().isValidSegment(newText)) {
                    return ReorgMessages.getString("ReorgQueries.invalidNameMessage");
                }
                IStatus status = res.getParent().getWorkspace().validateName(newText, res.getType());
                if (status.getSeverity() == 4) {
                    return status.getMessage();
                }
                if (res.getName().equalsIgnoreCase(newText)) {
                    return ReorgMessages.getString("ReorgQueries.resourceExistsWithDifferentCaseMassage");
                }
                return null;
            }
        };
        return validator;
    }

    private static IInputValidator createCompilationUnitNameValidator(final ICompilationUnit cu) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                RefactoringStatus refStatus;
                if (newText == null || "".equals(newText)) {
                    return ReorgQueries.EMPTY;
                }
                String newCuName = String.valueOf(newText) + ".java";
                IStatus status = JavaConventions.validateCompilationUnitName((String)newCuName);
                if (status.getSeverity() == 4) {
                    return status.getMessage();
                }
                try {
                    refStatus = Checks.checkCompilationUnitNewName(cu, newText);
                }
                catch (JavaModelException javaModelException) {
                    return ReorgQueries.EMPTY;
                }
                if (refStatus.hasFatalError()) {
                    return refStatus.getFirstMessage(4);
                }
                if (cu.getElementName().equalsIgnoreCase(newCuName)) {
                    return ReorgMessages.getString("ReorgQueries.resourceExistsWithDifferentCaseMassage");
                }
                return null;
            }
        };
        return validator;
    }

    private static IInputValidator createPackageNameValidator(final IPackageFragment pack) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || "".equals(newText)) {
                    return ReorgQueries.EMPTY;
                }
                IStatus status = JavaConventions.validatePackageName((String)newText);
                if (status.getSeverity() == 4) {
                    return status.getMessage();
                }
                IJavaElement parent = pack.getParent();
                try {
                    if (parent instanceof IPackageFragmentRoot && !RenamePackageRefactoring.isPackageNameOkInRoot(newText, (IPackageFragmentRoot)parent)) {
                        return ReorgMessages.getString("ReorgQueries.packagewithThatNameexistsMassage");
                    }
                }
                catch (JavaModelException javaModelException) {
                    return ReorgQueries.EMPTY;
                }
                if (pack.getElementName().equalsIgnoreCase(newText)) {
                    return ReorgMessages.getString("ReorgQueries.resourceExistsWithDifferentCaseMassage");
                }
                return null;
            }
        };
        return validator;
    }

    static class OverwriteQuery {
        private boolean alwaysOverwriteNonReadOnly = false;
        private boolean alwaysOverwrite = false;
        private boolean fCanceled = false;

        OverwriteQuery() {
        }

        public boolean overwrite(Object element) {
            IResource resource = ResourceUtil.getResource(element);
            if (resource != null) {
                IPath location = resource.getLocation();
                if (location == null) {
                    return false;
                }
                if (!location.toFile().exists()) {
                    return false;
                }
            }
            if (this.fCanceled) {
                return false;
            }
            if (this.alwaysOverwrite) {
                return true;
            }
            boolean isReadOnly = OverwriteQuery.isReadOnly(element);
            if (this.alwaysOverwriteNonReadOnly && !isReadOnly) {
                return true;
            }
            Shell parentShell = JavaPlugin.getActiveWorkbenchShell();
            int[] result = new int[1];
            Runnable query = new Runnable(this, element, isReadOnly, parentShell, result){
                private final /* synthetic */ Object val$element;
                private final /* synthetic */ boolean val$isReadOnly;
                private final /* synthetic */ OverwriteQuery this$1;
                private final /* synthetic */ Shell val$parentShell;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = overwriteQuery;
                    this.val$element = object;
                    this.val$isReadOnly = bl;
                    this.val$parentShell = shell;
                    this.val$result = nArray;
                }

                public void run() {
                    int[] resultId = new int[]{2, 4, 3, 1};
                    String message = this.this$1.createMessage(this.val$element, this.val$isReadOnly);
                    MessageDialog dialog = new MessageDialog(this.val$parentShell, ReorgMessages.getString("ReorgQueries.Confirm_Overwritting"), null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    dialog.open();
                    this.val$result[0] = resultId[dialog.getReturnCode()];
                }
            };
            parentShell.getDisplay().syncExec(query);
            if (result[0] == 4) {
                this.alwaysOverwriteNonReadOnly = true;
                if (isReadOnly) {
                    this.alwaysOverwrite = true;
                }
                return true;
            }
            if (result[0] == 2) {
                return true;
            }
            if (result[0] == 1) {
                this.fCanceled = true;
                return false;
            }
            if (result[0] == 3) {
                return false;
            }
            Assert.isTrue(false);
            return false;
        }

        public String createMessage(Object element, boolean isReadOnly) {
            String[] keys = new String[]{ReorgUtils.getName(element)};
            if (isReadOnly) {
                return ReorgMessages.getFormattedString("ReorgQueries.exists_read-only", keys);
            }
            return ReorgMessages.getFormattedString("ReorgQueries.exists", keys);
        }

        public boolean isCanceled() {
            return this.fCanceled;
        }

        private static boolean isReadOnly(Object element) {
            if (element instanceof IResource) {
                return OverwriteQuery.isReadOnlyResource((IResource)element);
            }
            if (element instanceof IJavaElement) {
                IResource resource = ResourceUtil.getResource(element);
                if (resource == null) {
                    return false;
                }
                if (OverwriteQuery.isReadOnlyResource(resource)) {
                    return true;
                }
                return ((IJavaElement)element).isReadOnly();
            }
            return false;
        }

        private static boolean isReadOnlyResource(IResource resource) {
            IStatus status = Resources.makeCommittable(resource, null);
            if (status.isOK()) {
                return false;
            }
            if (status.getCode() == 10003) {
                return false;
            }
            return status.getCode() != 274;
        }
    }
}

