/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.IReorgExceptionHandler;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.reorg.ReorgMessages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

class ReorgExceptionHandler
implements IReorgExceptionHandler {
    private MultiStatus fStatus;
    private boolean fForceOutOfSyncDelete;

    ReorgExceptionHandler() {
        String id = JavaPlugin.getDefault().getDescriptor().getUniqueIdentifier();
        this.fStatus = new MultiStatus(id, 0, ReorgMessages.getString("ReorgExceptionHandler.see_details"), null);
        this.fForceOutOfSyncDelete = false;
    }

    public void handle(ChangeContext context, IChange change, Exception e) {
        if (e instanceof JavaModelException) {
            JavaModelException jme = (JavaModelException)((Object)e);
            if (jme.getException() instanceof CoreException) {
                this.fStatus.merge(((CoreException)jme.getException()).getStatus());
            }
        } else if (e instanceof CoreException) {
            this.fStatus.merge(((CoreException)((Object)e)).getStatus());
        } else if (e instanceof OperationCanceledException) {
            throw (OperationCanceledException)((Object)e);
        }
    }

    public boolean forceDeletingResourceOutOfSynch(String name, CoreException e) {
        if (this.fForceOutOfSyncDelete) {
            return true;
        }
        int result = ReorgExceptionHandler.queryDeleteOutOfSync(name);
        if (result == 2) {
            return true;
        }
        if (result == 4) {
            this.fForceOutOfSyncDelete = true;
            return true;
        }
        return false;
    }

    MultiStatus getStatus() {
        return this.fStatus;
    }

    private static int queryDeleteOutOfSync(String name) {
        Shell shell = JavaPlugin.getActiveWorkbenchShell();
        final MessageDialog dialog = new MessageDialog(shell, ReorgMessages.getString("ReorgExceptionHandler.error.title"), null, ReorgMessages.getFormattedString("ReorgExceptionHandler.error.message", new String[]{name}), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL}, 0);
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        int result = dialog.getReturnCode();
        if (result == 0) {
            return 2;
        }
        if (result == 1) {
            return 4;
        }
        return 3;
    }
}

