/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.refactoring.CheckConditionsOperation;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringErrorDialogUtil;
import org.eclipse.jdt.internal.ui.reorg.ClipboardActionUtil;
import org.eclipse.jdt.internal.ui.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.reorg.ReorgQueries;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.ListContentProvider;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public abstract class ReorgDestinationAction
extends SelectionDispatchAction {
    static /* synthetic */ Class class$0;

    protected ReorgDestinationAction(IWorkbenchSite site) {
        super(site);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canOperateOn(selection));
    }

    protected boolean canOperateOn(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        if (ClipboardActionUtil.hasOnlyProjects(selection)) {
            if (selection.size() != 1) {
                return false;
            }
            IAdaptable iAdaptable = (IAdaptable)selection.getFirstElement();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IProject project = (IProject)iAdaptable.getAdapter((Class)clazz);
            return project.isAccessible();
        }
        return ClipboardActionUtil.canActivate(this.createRefactoring(selection.toList()));
    }

    protected void run(IStructuredSelection selection) {
        if (!this.needsSaving(selection)) {
            this.doRun(selection);
        } else {
            RefactoringSaveHelper helper = new RefactoringSaveHelper();
            try {
                if (helper.saveEditors()) {
                    this.doRun(selection);
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                helper.triggerBuild();
                throw throwable;
            }
            Object var3_5 = null;
            helper.triggerBuild();
        }
    }

    private void doRun(IStructuredSelection selection) {
        try {
            List elements = selection.toList();
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!ActionUtil.mustDisableJavaModelAction(this.getShell(), element)) continue;
                return;
            }
            if (!ReorgDestinationAction.ensureSaved(elements, this.getActionName())) {
                return;
            }
            ReorgRefactoring refactoring = this.createRefactoring(elements);
            ReorgDestinationAction.setUnsavedFileList(refactoring, elements);
            Object destination = this.selectDestination(refactoring);
            if (destination == null) {
                return;
            }
            String duplicate = ReorgDestinationAction.getDuplicatedElementName(elements);
            if (duplicate != null) {
                String message = ReorgMessages.getFormattedString("ReorgDestinationAction.duplicate", duplicate);
                MessageDialog.openInformation((Shell)JavaPlugin.getActiveWorkbenchShell().getShell(), (String)ReorgMessages.getString("ReorgDestinationAction.duplicate_name"), (String)message);
                return;
            }
            refactoring.setDestination(destination);
            Set excluded = ReorgDestinationAction.getExcluded(refactoring);
            if (excluded == null) {
                return;
            }
            if (excluded.size() == elements.size()) {
                return;
            }
            refactoring.setExcludedElements(excluded);
            if (!this.isOkToProceed(refactoring)) {
                return;
            }
            this.reorg(refactoring);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), ReorgMessages.getString("ReorgDestinationAction.exception_title"), ReorgMessages.getString("ReorgDestinationAction.exception"));
        }
    }

    private static String getDuplicatedElementName(List elements) {
        Object[] names = ReorgDestinationAction.getElementNames(elements);
        if (names.length == 0) {
            return null;
        }
        Arrays.sort(names);
        Object last = names[0];
        int i = 1;
        while (i < names.length) {
            if (((String)last).equals(names[i])) {
                return last;
            }
            last = names[i];
            ++i;
        }
        return null;
    }

    abstract String getActionName();

    abstract String getDestinationDialogMessage();

    abstract ReorgRefactoring createRefactoring(List var1);

    private static Set getExcluded(ReorgRefactoring refactoring) throws JavaModelException {
        Map elements = refactoring.getElementsThatExistInTarget();
        ReorgQueries.OverwriteQuery overwriteQuery = new ReorgQueries.OverwriteQuery();
        HashSet result = new HashSet();
        Iterator iter = elements.keySet().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            Object conflicting = elements.get(element);
            if (overwriteQuery.overwrite(conflicting)) continue;
            result.add(element);
        }
        if (overwriteQuery.isCanceled()) {
            return null;
        }
        return result;
    }

    protected boolean isOkToProceed(ReorgRefactoring refactoring) throws JavaModelException {
        return true;
    }

    private boolean needsSaving(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof ICompilationUnit) && !(element instanceof IType)) continue;
            return true;
        }
        return false;
    }

    void reorg(ReorgRefactoring refactoring) throws JavaModelException {
        CheckConditionsOperation runnable = new CheckConditionsOperation(refactoring, 6);
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getActionName(), ReorgMessages.getString("ReorgDestinationAction.error_occurred"));
            return;
        }
        catch (InterruptedException interruptedException) {
            Assert.isTrue(false);
        }
        RefactoringStatus status = runnable.getStatus();
        if (status == null) {
            return;
        }
        if (status.hasFatalError()) {
            RefactoringErrorDialogUtil.open(this.getActionName(), status);
        } else {
            this.doReorg(refactoring);
        }
    }

    private void doReorg(ReorgRefactoring refactoring) throws JavaModelException {
        MultiStatus status = ClipboardActionUtil.perform(refactoring);
        if (status.isOK()) {
            return;
        }
        JavaPlugin.log((IStatus)status);
        ErrorDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)this.getActionName(), (String)ReorgMessages.getString("ReorgDestinationAction.error"), (IStatus)status);
    }

    private static boolean ensureSaved(List elements, String actionName) {
        ArrayList unsavedEditors = new ArrayList();
        ArrayList unsavedElements = new ArrayList();
        ReorgDestinationAction.collectUnsavedEditors(elements, unsavedEditors, unsavedElements);
        if (unsavedEditors.isEmpty()) {
            return true;
        }
        ListSelectionDialog dialog = ReorgDestinationAction.createUnsavedEditorDialog(unsavedElements);
        if (dialog.open() != 0) {
            return false;
        }
        IEditorPart[] unsavedEditorArray = unsavedEditors.toArray(new IEditorPart[unsavedEditors.size()]);
        IRunnableWithProgress r = ReorgDestinationAction.createSaveEditorOperation(dialog.getResult(), unsavedEditorArray);
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, false, r);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, actionName, ReorgMessages.getString("ReorgAction.exception.saving"));
            return false;
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    private static void setUnsavedFileList(ReorgRefactoring refactoring, List elements) {
        ArrayList unsavedEditors = new ArrayList(0);
        ReorgDestinationAction.collectUnsavedEditors(elements, unsavedEditors, new ArrayList(0));
        refactoring.setUnsavedFiles(ReorgDestinationAction.getFiles(unsavedEditors));
    }

    private static IFile[] getFiles(List editorParts) {
        ArrayList<IFile> result = new ArrayList<IFile>(editorParts.size());
        Iterator iter = editorParts.iterator();
        while (iter.hasNext()) {
            IEditorPart each = (IEditorPart)iter.next();
            IEditorInput input = each.getEditorInput();
            if (!(input instanceof IFileEditorInput)) continue;
            result.add(((IFileEditorInput)input).getFile());
        }
        return result.toArray(new IFile[result.size()]);
    }

    private static IRunnableWithProgress createSaveEditorOperation(final Object[] elementsToSave, final IEditorPart[] unsavedEditors) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) {
                pm.beginTask(ReorgMessages.getString("ReorgAction.task.saving"), elementsToSave.length);
                int i = 0;
                while (i < elementsToSave.length) {
                    IEditorPart editor = ReorgDestinationAction.findEditor(elementsToSave[i], unsavedEditors);
                    if (editor != null) {
                        editor.doSave((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    } else {
                        pm.worked(1);
                    }
                    ++i;
                }
                pm.done();
            }
        };
    }

    private static IEditorPart findEditor(Object element, IEditorPart[] unsavedEditors) {
        int i = 0;
        while (i < unsavedEditors.length) {
            if (EditorUtility.isEditorInput(element, unsavedEditors[i])) {
                return unsavedEditors[i];
            }
            ++i;
        }
        return null;
    }

    private static ListSelectionDialog createUnsavedEditorDialog(List unsavedElements) {
        int labelFlags = JavaElementLabelProvider.SHOW_DEFAULT | 0x800;
        Shell parent = JavaPlugin.getActiveWorkbenchShell();
        String msg = ReorgMessages.getString("ReorgAction.checkSaveTargets");
        ListSelectionDialog dialog = new ListSelectionDialog(parent, (Object)unsavedElements, (IStructuredContentProvider)new ListContentProvider(), (ILabelProvider)new JavaElementLabelProvider(labelFlags), msg);
        dialog.setTitle(ReorgMessages.getString("ReorgAction.checkSaveTargets.title"));
        dialog.setInitialSelections(unsavedElements.toArray());
        return dialog;
    }

    private static void collectUnsavedEditors(List elements, List unsavedEditors, List unsavedElements) {
        IEditorPart[] editors = JavaPlugin.getDirtyEditors();
        int i = 0;
        while (i < editors.length) {
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!EditorUtility.isEditorInput(element, editors[i])) continue;
                unsavedEditors.add(editors[i]);
                unsavedElements.add(element);
            }
            ++i;
        }
    }

    private static String[] getElementNames(List elements) {
        String[] result = new String[elements.size()];
        int i = 0;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            result[i] = ReorgUtils.getName(iter.next());
            ++i;
        }
        return result;
    }

    protected Object selectDestination(ReorgRefactoring refactoring) {
        DestinationDialogContentProvider cp = new DestinationDialogContentProvider();
        ElementTreeSelectionDialog dialog = this.createDestinationSelectionDialog(JavaPlugin.getActiveWorkbenchShell(), (ILabelProvider)new DestinationRenderer(256), cp, refactoring);
        ReorgDestinationAction.initDialog(dialog, this.getActionName(), this.getDestinationDialogMessage(), refactoring, null);
        return this.openDialog(dialog);
    }

    protected Object openDialog(ElementTreeSelectionDialog dialog) {
        if (dialog.open() != 1) {
            return dialog.getFirstResult();
        }
        return null;
    }

    public static void initDialog(ElementTreeSelectionDialog dialog, String title, String message, ReorgRefactoring refactoring, Object selection) {
        dialog.setTitle(title);
        dialog.setValidator((ISelectionStatusValidator)new ReorgSelectionValidator(refactoring));
        dialog.addFilter((ViewerFilter)new ContainerFilter(refactoring));
        dialog.setSorter((ViewerSorter)new JavaElementSorter());
        dialog.setMessage(message);
        dialog.setSize(60, 18);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        if (selection == null) {
            selection = ReorgDestinationAction.computeCommonParent(refactoring.getElementsToReorg());
        }
        dialog.setInitialSelection(selection);
    }

    ElementTreeSelectionDialog createDestinationSelectionDialog(Shell parent, ILabelProvider labelProvider, StandardJavaElementContentProvider cp, ReorgRefactoring refactoring) {
        return new ElementTreeSelectionDialog(parent, labelProvider, (ITreeContentProvider)cp);
    }

    private static Object computeCommonParent(List elements) {
        if (elements.isEmpty()) {
            return null;
        }
        Object parent = elements.get(0);
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            parent = ReorgDestinationAction.computeCommonParent(parent, iter.next());
        }
        IResource parentRes = ReorgDestinationAction.getResource(parent);
        IJavaElement parentElement = JavaCore.create((IResource)parentRes);
        if (parentElement != null) {
            return parentElement;
        }
        return ReorgDestinationAction.getResource(parent);
    }

    private static Object computeCommonParent(Object e1, Object e2) {
        IResource r1 = ReorgDestinationAction.getResource(e1);
        IResource r2 = ReorgDestinationAction.getResource(e2);
        if (r1 == null && r2 == null) {
            return null;
        }
        if (r1 == null) {
            return r2.getParent();
        }
        if (r2 == null) {
            return r1.getParent();
        }
        if (r1.equals((Object)r2)) {
            return r1.getParent();
        }
        if (r1.getFullPath().isPrefixOf(r2.getFullPath())) {
            return r1;
        }
        if (r2.getFullPath().isPrefixOf(r1.getFullPath())) {
            return r2;
        }
        IPath p1 = r1.getParent().getFullPath();
        IPath p2 = r2.getParent().getFullPath();
        Path commonPath = new Path("");
        int segCount = Math.min(p1.segmentCount(), p2.segmentCount());
        int i = 0;
        while (i < segCount) {
            if (!p1.segment(i).equals(p2.segment(i))) break;
            commonPath = commonPath.append(p1.segment(i));
            ++i;
        }
        return ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)commonPath);
    }

    private static IResource getResource(Object o) {
        try {
            if (o instanceof IResource) {
                return (IResource)o;
            }
            if (o instanceof IJavaElement) {
                return ((IJavaElement)o).getCorrespondingResource();
            }
            return null;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    static final class DestinationDialogContentProvider
    extends StandardJavaElementContentProvider {
        DestinationDialogContentProvider() {
        }

        public boolean hasChildren(Object element) {
            return !(element instanceof IPackageFragment) && super.hasChildren(element);
        }

        public Object[] getChildren(Object parentElement) {
            try {
                if (parentElement instanceof IJavaModel) {
                    return StandardJavaElementContentProvider.concatenate(this.getJavaProjects((IJavaModel)parentElement), DestinationDialogContentProvider.getNonJavaProjects((IJavaModel)parentElement));
                }
                return super.getChildren(parentElement);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return new Object[0];
            }
        }

        private static Object[] getNonJavaProjects(IJavaModel model) throws JavaModelException {
            return model.getNonJavaResources();
        }
    }

    private static class ContainerFilter
    extends ViewerFilter {
        private ReorgRefactoring fRefactoring;

        ContainerFilter(ReorgRefactoring refactoring) {
            Assert.isNotNull(refactoring);
            this.fRefactoring = refactoring;
        }

        public boolean select(Viewer viewer, Object parent, Object o) {
            if (this.fRefactoring.getElementsToReorg().contains(o)) {
                return false;
            }
            return this.fRefactoring.canBeAncestor(o);
        }
    }

    static class DestinationRenderer
    extends JavaElementLabelProvider {
        public DestinationRenderer(int flags) {
            super(flags);
        }

        public String getText(Object element) {
            IPackageFragmentRoot root;
            if (element instanceof IPackageFragmentRoot && (root = (IPackageFragmentRoot)element).getResource() instanceof IProject) {
                return ReorgMessages.getString("DestinationRenderer.packages");
            }
            return super.getText(element);
        }
    }

    private static class ReorgSelectionValidator
    implements ISelectionStatusValidator {
        private ReorgRefactoring fRefactoring;

        public ReorgSelectionValidator(ReorgRefactoring refactoring) {
            Assert.isNotNull(refactoring);
            this.fRefactoring = refactoring;
        }

        public IStatus validate(Object[] selection) {
            if (selection.length != 1) {
                return new StatusInfo(4, "");
            }
            try {
                if (this.fRefactoring.isValidDestination(selection[0])) {
                    return new StatusInfo();
                }
                return new StatusInfo(4, "");
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), ReorgMessages.getString("ReorgDestinationAction.exception_title"), ReorgMessages.getString("ReorgDestinationAction.exception"));
                return new StatusInfo(4, "");
            }
        }
    }
}

