/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.reorg.ClipboardActionUtil;
import org.eclipse.jdt.internal.ui.reorg.CopyResourcesToClipboardAction;
import org.eclipse.jdt.internal.ui.reorg.CopySourceReferencesToClipboardAction;
import org.eclipse.jdt.internal.ui.reorg.CutSourceReferencesToClipboardAction;
import org.eclipse.jdt.internal.ui.reorg.DeleteResourcesAction;
import org.eclipse.jdt.internal.ui.reorg.DeleteSourceReferencesAction;
import org.eclipse.jdt.internal.ui.reorg.DualReorgAction;
import org.eclipse.jdt.internal.ui.reorg.JdtCopyAction;
import org.eclipse.jdt.internal.ui.reorg.MockWorkbenchSite;
import org.eclipse.jdt.internal.ui.reorg.PasteResourcesFromClipboardAction;
import org.eclipse.jdt.internal.ui.reorg.PasteSourceReferencesFromClipboardAction;
import org.eclipse.jdt.internal.ui.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.reorg.TypedSource;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;

public class ReorgActionFactory {
    private ReorgActionFactory() {
    }

    public static SelectionDispatchAction createCutAction(IWorkbenchSite site, Clipboard clipboard, SelectionDispatchAction pasteAction) {
        String helpContextID = "org.eclipse.jdt.ui.cut_action";
        CutSourceReferencesToClipboardAction a1 = new CutSourceReferencesToClipboardAction(site, clipboard, pasteAction, helpContextID);
        ISharedImages workbenchImages = ReorgActionFactory.getWorkbenchSharedImages();
        a1.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        a1.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT"));
        a1.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT_HOVER"));
        return a1;
    }

    public static SelectionDispatchAction createCopyAction(IWorkbenchSite site, Clipboard clipboard, SelectionDispatchAction pasteAction) {
        CopyResourcesToClipboardAction a1 = new CopyResourcesToClipboardAction(site, clipboard, pasteAction);
        CopySourceReferencesToClipboardAction a2 = new CopySourceReferencesToClipboardAction(site, clipboard, pasteAction);
        String helpContextID = "org.eclipse.jdt.ui.copy_action";
        DualReorgAction dual = new DualReorgAction(site, ReorgMessages.getString("ReorgGroup.copy"), ReorgMessages.getString("copyAction.description"), a1, a2, helpContextID);
        ISharedImages workbenchImages = ReorgActionFactory.getWorkbenchSharedImages();
        dual.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        dual.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        dual.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY_HOVER"));
        return dual;
    }

    public static SelectionDispatchAction createPasteAction(IWorkbenchSite site, Clipboard clipboard) {
        PasteResourcesFromClipboardAction a1 = new PasteResourcesFromClipboardAction(site, clipboard);
        PasteSourceReferencesFromClipboardAction a2 = new PasteSourceReferencesFromClipboardAction(site, clipboard);
        String helpContextID = "org.eclipse.jdt.ui.paste_action";
        DualReorgAction dual = new DualReorgAction(site, ReorgMessages.getString("ReorgGroup.paste"), ReorgMessages.getString("ReorgGroup.pasteAction.description"), a1, a2, helpContextID);
        ISharedImages workbenchImages = ReorgActionFactory.getWorkbenchSharedImages();
        dual.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        dual.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE"));
        dual.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE_HOVER"));
        return dual;
    }

    public static SelectionDispatchAction createDeleteAction(IWorkbenchSite site) {
        DeleteResourcesAction a1 = new DeleteResourcesAction(site);
        DeleteSourceReferencesAction a2 = new DeleteSourceReferencesAction(site);
        String helpContextID = "org.eclipse.jdt.ui.delete_action";
        DualReorgAction dual = new DualReorgAction(site, ReorgMessages.getString("ReorgGroup.delete"), ReorgMessages.getString("deleteAction.description"), a1, a2, helpContextID);
        ISharedImages workbenchImages = ReorgActionFactory.getWorkbenchSharedImages();
        dual.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        dual.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        dual.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE_HOVER"));
        return dual;
    }

    public static ISharedImages getWorkbenchSharedImages() {
        return JavaPlugin.getDefault().getWorkbench().getSharedImages();
    }

    public static SelectionDispatchAction createPasteAction(final ISourceReference[] elements, Object target) {
        return new PasteSourceReferencesFromClipboardAction(new MockWorkbenchSite(new Object[]{target}), null){

            protected TypedSource[] getContentsToPaste() {
                ArrayList<TypedSource> result = new ArrayList<TypedSource>(elements.length);
                int i = 0;
                while (i < elements.length) {
                    try {
                        result.add(new TypedSource(elements[i]));
                    }
                    catch (JavaModelException javaModelException) {}
                    ++i;
                }
                return result.toArray(new TypedSource[result.size()]);
            }
        };
    }

    public static DeleteSourceReferencesAction createDeleteSourceReferencesAction(ISourceReference[] elements) {
        return new DeleteSourceReferencesAction(new MockWorkbenchSite(elements));
    }

    public static JdtCopyAction createDnDCopyAction(List elems, final IResource destination) {
        JdtCopyAction action = new JdtCopyAction(new MockWorkbenchSite(elems)){

            protected Object selectDestination(ReorgRefactoring ref) {
                return ClipboardActionUtil.tryConvertingToJava(destination);
            }
        };
        return action;
    }

    public static JdtCopyAction createDnDCopyAction(IResource[] resourceData, IResource destination) {
        return ReorgActionFactory.createDnDCopyAction(ClipboardActionUtil.getConvertedResources(resourceData), destination);
    }
}

